/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.signature;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.signature.StringSignature;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class ApplicationVersionSignature {
    private static final ConcurrentHashMap<String, Key> PACKAGE_NAME_TO_KEY = new ConcurrentHashMap();

    public static Key obtain(Context context) {
        Key key;
        String string = context.getPackageName();
        Key key2 = PACKAGE_NAME_TO_KEY.get(string);
        if (key2 == null && (key2 = PACKAGE_NAME_TO_KEY.putIfAbsent(string, key = ApplicationVersionSignature.obtainVersionSignature(context))) == null) {
            key2 = key;
        }
        return key2;
    }

    static void reset() {
        PACKAGE_NAME_TO_KEY.clear();
    }

    private static Key obtainVersionSignature(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        String string = packageInfo != null ? String.valueOf(packageInfo.versionCode) : UUID.randomUUID().toString();
        return new StringSignature(string);
    }

    private ApplicationVersionSignature() {
    }
}

