/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.component.common.utils.CLog;
import java.util.StringTokenizer;

public class HTTPStatus {
    private static final String TAG = "Lelink-HTTPStatus";
    public static final int CONTINUE = 100;
    public static final int OK = 200;
    public static final int PARTIAL_CONTENT = 206;
    public static final int BAD_REQUEST = 400;
    public static final int NOT_FOUND = 404;
    public static final int PRECONDITION_FAILED = 412;
    public static final int INVALID_RANGE = 416;
    public static final int INTERNAL_SERVER_ERROR = 510;
    public static final int INTERNAL_SERVER_ERROR2 = 600;
    public static final int INTERNAL_SERVER_IO_ERROR = 7000;
    private String version = "";
    private int statusCode = 0;
    private String reasonPhrase = "";

    public static String code2String(int n2) {
        switch (n2) {
            case 100: {
                return "Continue";
            }
            case 200: {
                return "OK";
            }
            case 206: {
                return "Partial Content";
            }
            case 400: {
                return "Bad Request";
            }
            case 404: {
                return "Not Found";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 416: {
                return "Invalid Range";
            }
            case 510: {
                return "Internal Server Error";
            }
            case 600: {
                return "No route to host";
            }
            case 7000: {
                return "io write error";
            }
        }
        return "";
    }

    public HTTPStatus() {
        this.setVersion("");
        this.setStatusCode(0);
        this.setReasonPhrase("");
    }

    public HTTPStatus(String string, int n2, String string2) {
        this.setVersion(string);
        this.setStatusCode(n2);
        this.setReasonPhrase(string2);
    }

    public HTTPStatus(String string) {
        this.set(string);
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setStatusCode(int n2) {
        this.statusCode = n2;
    }

    public void setReasonPhrase(String string) {
        this.reasonPhrase = string;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public static final boolean isSuccessful(int n2) {
        return 200 <= n2 && n2 < 300;
    }

    public boolean isSuccessful() {
        return HTTPStatus.isSuccessful(this.getStatusCode());
    }

    public void set(String string) {
        if (string == null) {
            this.setVersion("1.1");
            this.setStatusCode(510);
            this.setReasonPhrase(HTTPStatus.code2String(510));
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            String string2 = stringTokenizer.nextToken();
            this.setVersion(string2.trim());
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            String string3 = stringTokenizer.nextToken();
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStatusCode(n2);
            String string4 = "";
            while (stringTokenizer.hasMoreTokens()) {
                if (0 <= string4.length()) {
                    string4 = string4 + " ";
                }
                string4 = string4 + stringTokenizer.nextToken();
            }
            this.setReasonPhrase(string4.trim());
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
        }
    }
}

