/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.app.Application;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.widget.Toast;
import com.herohan.uvcapp.CameraException;
import com.herohan.uvcapp.CameraPreviewConfig;
import com.herohan.uvcapp.IImageCapture;
import com.herohan.uvcapp.ImageCaptureConfig;
import com.herohan.uvcapp.VideoCapture;
import com.herohan.uvcapp.VideoCaptureConfig;
import com.serenegiant.usb.Format;
import com.serenegiant.usb.IButtonCallback;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.UVCControl;
import com.serenegiant.usb.UVCParam;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.uvccamera.R;
import java.util.List;

public interface ICameraHelper {
    public void setStateCallback(StateCallback var1);

    public List<UsbDevice> getDeviceList();

    public void selectDevice(UsbDevice var1);

    public List<Format> getSupportedFormatList();

    public List<Size> getSupportedSizeList();

    public Size getPreviewSize();

    public void setPreviewSize(Size var1);

    public void addSurface(Object var1, boolean var2);

    public void removeSurface(Object var1);

    public void setButtonCallback(IButtonCallback var1);

    public void setFrameCallback(IFrameCallback var1, int var2);

    public void openCamera();

    public void openCamera(Size var1);

    public void openCamera(UVCParam var1);

    public void closeCamera();

    public void startPreview();

    public void stopPreview();

    public UVCControl getUVCControl();

    public void takePicture(IImageCapture.OutputFileOptions var1, IImageCapture.OnImageCaptureCallback var2);

    public boolean isRecording();

    public void startRecording(VideoCapture.OutputFileOptions var1, VideoCapture.OnVideoCaptureCallback var2);

    public void stopRecording();

    public boolean isCameraOpened();

    public void release();

    public void releaseAll();

    public CameraPreviewConfig getPreviewConfig();

    public void setPreviewConfig(CameraPreviewConfig var1);

    public ImageCaptureConfig getImageCaptureConfig();

    public void setImageCaptureConfig(ImageCaptureConfig var1);

    public VideoCaptureConfig getVideoCaptureConfig();

    public void setVideoCaptureConfig(VideoCaptureConfig var1);

    public static interface StateCallback {
        public void onAttach(UsbDevice var1);

        public void onDeviceOpen(UsbDevice var1, boolean var2);

        public void onCameraOpen(UsbDevice var1);

        public void onCameraClose(UsbDevice var1);

        public void onDeviceClose(UsbDevice var1);

        public void onDetach(UsbDevice var1);

        public void onCancel(UsbDevice var1);

        default public void onError(UsbDevice device, CameraException e) {
            Application context = UVCUtils.getApplication();
            String tip = e.getCode() == CameraException.CAMERA_OPEN_ERROR_BUSY ? context.getString(R.string.error_busy_need_replug) : context.getString(R.string.error_unknown_need_replug);
            Toast.makeText((Context)context, (CharSequence)tip, (int)0).show();
        }
    }
}

