/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Rcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.base64;
import java.util.Date;

public class TSIGRecord
extends Record {
    private static final long serialVersionUID = -88820909016649306L;
    private Name alg;
    private Date timeSigned;
    private int fudge;
    private byte[] signature;
    private int originalID;
    private int error;
    private byte[] other;

    TSIGRecord() {
    }

    @Override
    Record getObject() {
        return new TSIGRecord();
    }

    public TSIGRecord(Name name, int n2, long l2, Name name2, Date date, int n3, byte[] byArray, int n4, int n5, byte[] byArray2) {
        super(name, 250, n2, l2);
        this.alg = TSIGRecord.checkName("alg", name2);
        this.timeSigned = date;
        this.fudge = TSIGRecord.checkU16("fudge", n3);
        this.signature = byArray;
        this.originalID = TSIGRecord.checkU16("originalID", n4);
        this.error = TSIGRecord.checkU16("error", n5);
        this.other = byArray2;
    }

    @Override
    void rrFromWire(DNSInput dNSInput) {
        this.alg = new Name(dNSInput);
        long l2 = dNSInput.readU16();
        long l3 = dNSInput.readU32();
        long l4 = (l2 << 32) + l3;
        this.timeSigned = new Date(l4 * 1000L);
        this.fudge = dNSInput.readU16();
        int n2 = dNSInput.readU16();
        this.signature = dNSInput.readByteArray(n2);
        this.originalID = dNSInput.readU16();
        this.error = dNSInput.readU16();
        int n3 = dNSInput.readU16();
        this.other = (byte[])(n3 > 0 ? dNSInput.readByteArray(n3) : null);
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) {
        throw tokenizer.exception("no text format defined for TSIG");
    }

    @Override
    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.alg);
        stringBuffer.append(" ");
        if (Options.check("multiline")) {
            stringBuffer.append("(\n\t");
        }
        stringBuffer.append(this.timeSigned.getTime() / 1000L);
        stringBuffer.append(" ");
        stringBuffer.append(this.fudge);
        stringBuffer.append(" ");
        stringBuffer.append(this.signature.length);
        if (Options.check("multiline")) {
            stringBuffer.append("\n");
            stringBuffer.append(base64.formatString(this.signature, 64, "\t", false));
        } else {
            stringBuffer.append(" ");
            stringBuffer.append(base64.toString(this.signature));
        }
        stringBuffer.append(" ");
        stringBuffer.append(Rcode.TSIGstring(this.error));
        stringBuffer.append(" ");
        if (this.other == null) {
            stringBuffer.append(0);
        } else {
            stringBuffer.append(this.other.length);
            if (Options.check("multiline")) {
                stringBuffer.append("\n\n\n\t");
            } else {
                stringBuffer.append(" ");
            }
            if (this.error == 18) {
                if (this.other.length != 6) {
                    stringBuffer.append("<invalid BADTIME other data>");
                } else {
                    long l2 = ((long)(this.other[0] & 0xFF) << 40) + ((long)(this.other[1] & 0xFF) << 32) + (long)((this.other[2] & 0xFF) << 24) + (long)((this.other[3] & 0xFF) << 16) + (long)((this.other[4] & 0xFF) << 8) + (long)(this.other[5] & 0xFF);
                    stringBuffer.append("<server time: ");
                    stringBuffer.append(new Date(l2 * 1000L));
                    stringBuffer.append(">");
                }
            } else {
                stringBuffer.append("<");
                stringBuffer.append(base64.toString(this.other));
                stringBuffer.append(">");
            }
        }
        if (Options.check("multiline")) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public int getFudge() {
        return this.fudge;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getOther() {
        return this.other;
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.alg.toWire(dNSOutput, null, bl);
        long l2 = this.timeSigned.getTime() / 1000L;
        int n2 = (int)(l2 >> 32);
        long l3 = l2 & 0xFFFFFFFFL;
        dNSOutput.writeU16(n2);
        dNSOutput.writeU32(l3);
        dNSOutput.writeU16(this.fudge);
        dNSOutput.writeU16(this.signature.length);
        dNSOutput.writeByteArray(this.signature);
        dNSOutput.writeU16(this.originalID);
        dNSOutput.writeU16(this.error);
        if (this.other != null) {
            dNSOutput.writeU16(this.other.length);
            dNSOutput.writeByteArray(this.other);
        } else {
            dNSOutput.writeU16(0);
        }
    }
}

