/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.hpplay.glide.load.ResourceDecoder;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.model.ImageVideoWrapper;
import java.io.IOException;
import java.io.InputStream;

public class ImageVideoBitmapDecoder
implements ResourceDecoder<ImageVideoWrapper, Bitmap> {
    private static final String TAG = "ImageVideoDecoder";
    private final ResourceDecoder<InputStream, Bitmap> streamDecoder;
    private final ResourceDecoder<ParcelFileDescriptor, Bitmap> fileDescriptorDecoder;

    public ImageVideoBitmapDecoder(ResourceDecoder<InputStream, Bitmap> resourceDecoder, ResourceDecoder<ParcelFileDescriptor, Bitmap> resourceDecoder2) {
        this.streamDecoder = resourceDecoder;
        this.fileDescriptorDecoder = resourceDecoder2;
    }

    @Override
    public Resource<Bitmap> decode(ImageVideoWrapper imageVideoWrapper, int n2, int n3) {
        ParcelFileDescriptor parcelFileDescriptor;
        Resource<Bitmap> resource;
        block4: {
            resource = null;
            InputStream inputStream = imageVideoWrapper.getStream();
            if (inputStream != null) {
                try {
                    resource = this.streamDecoder.decode(inputStream, n2, n3);
                }
                catch (IOException iOException) {
                    if (!Log.isLoggable((String)TAG, (int)2)) break block4;
                    Log.v((String)TAG, (String)"Failed to load image from stream, trying FileDescriptor", (Throwable)iOException);
                }
            }
        }
        if (resource == null && (parcelFileDescriptor = imageVideoWrapper.getFileDescriptor()) != null) {
            resource = this.fileDescriptorDecoder.decode(parcelFileDescriptor, n2, n3);
        }
        return resource;
    }

    @Override
    public String getId() {
        return "ImageVideoBitmapDecoder.com.bumptech.glide.load.resource.bitmap";
    }
}

