/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.modulelinker.patch;

import android.annotation.TargetApi;
import android.os.Build;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.Log;
import com.hpplay.component.modulelinker.ModuleLoadUtils;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import dalvik.system.DexFile;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class SystemHookUtils {
    private static final String TAG = "SystemHookUtils";
    public static final String PATH_BASECLASSLOADER = "dalvik.system.BaseDexClassLoader";
    public static final String PATH_LIBRARY_PATH = "java.library.path";
    public static final String PATH_LIBCORE = "libcore.io.Libcore";
    public static final String METHOD_PATHLIST = "pathList";
    public static final String METHOD_ADDDEXPATH = "addDexPath";
    public static final String METHOD_ADDNATIVEPATH = "addNativePath";
    public static final String METHOD_MAKEPATHELEMENTS = "makePathElements";
    public static final String METHOD_NATIVELIBRARYPATHELEMENTS = "nativeLibraryPathElements";
    public static final String METHOD_GETDEXPATHS = "getDexPaths";
    public static final String METHOD_STAT = "stat";
    public static final String METHOD_FINDCLASS = "findClass";
    public static final String FIELD_OS = "os";
    public static final String FIELD_DEXELEMENTS = "dexElements";
    public static final String FIELD_DEXFILED = "dexFile";

    public static boolean hookSystemField(String string, String string2) {
        try {
            File file = new File(ModuleLinker.getInstance().getContext().getFilesDir() + File.separator + "/hpplay/dex/");
            if (!file.exists()) {
                file.mkdirs();
            }
            ClassLoader classLoader = ModuleLinker.getInstance().getContext().getClassLoader();
            Object object = ModuleLoadUtils.getField(classLoader, Class.forName(PATH_BASECLASSLOADER), METHOD_PATHLIST);
            if (Build.VERSION.SDK_INT >= 26) {
                ModuleLoadUtils.exeMethod(object, METHOD_ADDDEXPATH, string, file);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(string2);
                    ModuleLoadUtils.exeMethod(object, METHOD_ADDNATIVEPATH, arrayList);
                }
                return true;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                SystemHookUtils.hookMakePathElements(object, string, string2, file);
                return true;
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return false;
    }

    private static void hookMakePathElements(Object object, String string, String string2, File file) {
        ArrayList arrayList = new ArrayList();
        Object object2 = ModuleLoadUtils.exeMethod(object, METHOD_MAKEPATHELEMENTS, SystemHookUtils.splitPaths(string, false), file, arrayList);
        Object object3 = ModuleLoadUtils.getField(object, FIELD_DEXELEMENTS);
        Object object4 = SystemHookUtils.merge(object2, object3);
        ModuleLoadUtils.setField(object, FIELD_DEXELEMENTS, object4);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            List<File> list = SystemHookUtils.splitPaths(string2, false);
            List<File> list2 = SystemHookUtils.splitPaths(System.getProperty(PATH_LIBRARY_PATH), true);
            ArrayList<File> arrayList2 = new ArrayList<File>(list);
            arrayList2.addAll(list2);
            Object object5 = ModuleLoadUtils.exeMethod(object, METHOD_MAKEPATHELEMENTS, arrayList2, null, arrayList);
            ModuleLoadUtils.setField(object, METHOD_NATIVELIBRARYPATHELEMENTS, object5);
        }
    }

    @TargetApi(value=21)
    private static List<File> splitPaths(String string, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (string != null) {
            for (String string2 : string.split(File.pathSeparator)) {
                if (bl) {
                    try {
                        Object object = ModuleLoadUtils.getStaticField(PATH_LIBCORE, FIELD_OS);
                        StructStat structStat = (StructStat)ModuleLoadUtils.exeMethod(object, METHOD_STAT, string2);
                        if (!OsConstants.S_ISDIR((int)structStat.st_mode)) {
                        }
                    }
                    catch (Exception exception) {}
                    continue;
                }
                arrayList.add(new File(string2));
            }
        }
        return arrayList;
    }

    private static Object merge(Object object, Object object2) {
        Class<?> clazz = object2.getClass().getComponentType();
        int n2 = Array.getLength(object);
        int n3 = Array.getLength(object2);
        int n4 = Array.getLength(object) + Array.getLength(object2);
        Object object3 = Array.newInstance(clazz, n4);
        System.arraycopy(object, 0, object3, 0, n2);
        System.arraycopy(object2, 0, object3, n2, n3);
        return object3;
    }

    public static Class findClassByBaseclassLoader(String string) {
        try {
            Object object = ModuleLoadUtils.getField(ModuleLinker.getInstance().getContext(), Class.forName(PATH_BASECLASSLOADER), METHOD_PATHLIST);
            ArrayList arrayList = new ArrayList();
            return (Class)ModuleLoadUtils.exeMethod(object, METHOD_FINDCLASS, string, arrayList);
        }
        catch (Exception exception) {
            Log.i((String)TAG, (String)" parent find class failed");
            return null;
        }
    }

    public static List<DexFile> findDexFiles(ClassLoader classLoader) {
        ArrayList<DexFile> arrayList = new ArrayList<DexFile>();
        try {
            Object object = ModuleLoadUtils.getField(classLoader, Class.forName(PATH_BASECLASSLOADER), METHOD_PATHLIST);
            if (Build.VERSION.SDK_INT >= 26) {
                List list = (List)ModuleLoadUtils.exeMethod(object, METHOD_GETDEXPATHS, new Object[0]);
                if (list != null) {
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        String string = (String)list.get(i2);
                        Log.d((String)TAG, (String)(" dex path " + string));
                        DexFile dexFile = new DexFile(string);
                        arrayList.add(dexFile);
                    }
                }
                Log.i((String)TAG, (String)("android high version sdk find dex file size " + arrayList.size()));
            } else {
                Object[] objectArray = (Object[])ModuleLoadUtils.getField(object, FIELD_DEXELEMENTS);
                if (objectArray != null && objectArray.length > 0) {
                    for (int i3 = 0; i3 < objectArray.length; ++i3) {
                        DexFile dexFile = (DexFile)ModuleLoadUtils.getField(objectArray[i3], FIELD_DEXFILED);
                        Log.d((String)TAG, (String)("android low version sdk find dex file path " + dexFile.getName()));
                        arrayList.add(dexFile);
                    }
                }
                Log.i((String)TAG, (String)("android low version sdk find dex file size " + arrayList.size()));
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return arrayList;
    }
}

