/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.control;

import com.hpplay.cybergarage.soap.SOAPResponse;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.upnp.UPnPStatus;
import com.hpplay.cybergarage.xml.Node;

public class ControlResponse
extends SOAPResponse {
    public static final String FAULT_CODE = "Client";
    public static final String FAULT_STRING = "UPnPError";
    private UPnPStatus upnpErr = new UPnPStatus();

    public ControlResponse() {
        this.setServer(UPnP.getServerName());
    }

    public ControlResponse(SOAPResponse sOAPResponse) {
        super(sOAPResponse);
    }

    public void setFaultResponse(int n2, String string) {
        this.setStatusCode(510);
        Node node = this.getBodyNode();
        Node node2 = this.createFaultResponseNode(n2, string);
        node.addNode(node2);
        Node node3 = this.getEnvelopeNode();
        this.setContent(node3);
    }

    public void setFaultResponse(int n2) {
        this.setFaultResponse(n2, UPnPStatus.code2String(n2));
    }

    private Node createFaultResponseNode(int n2, String string) {
        Node node = new Node("s:Fault");
        Node node2 = new Node("faultcode");
        node2.setValue("s:Client");
        node.addNode(node2);
        Node node3 = new Node("faultstring");
        node3.setValue(FAULT_STRING);
        node.addNode(node3);
        Node node4 = new Node("detail");
        node.addNode(node4);
        Node node5 = new Node(FAULT_STRING);
        node5.setAttribute("xmlns", "urn:schemas-upnp-org:control-1-0");
        node4.addNode(node5);
        Node node6 = new Node("errorCode");
        node6.setValue(n2);
        node5.addNode(node6);
        Node node7 = new Node("errorDescription");
        node7.setValue(string);
        node5.addNode(node7);
        return node;
    }

    private Node createFaultResponseNode(int n2) {
        return this.createFaultResponseNode(n2, UPnPStatus.code2String(n2));
    }

    private Node getUPnPErrorNode() {
        Node node = this.getFaultDetailNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith(FAULT_STRING);
    }

    private Node getUPnPErrorCodeNode() {
        Node node = this.getUPnPErrorNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("errorCode");
    }

    private Node getUPnPErrorDescriptionNode() {
        Node node = this.getUPnPErrorNode();
        if (node == null) {
            return null;
        }
        return node.getNodeEndsWith("errorDescription");
    }

    public int getUPnPErrorCode() {
        Node node = this.getUPnPErrorCodeNode();
        if (node == null) {
            return -1;
        }
        String string = node.getValue();
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getUPnPErrorDescription() {
        Node node = this.getUPnPErrorDescriptionNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public UPnPStatus getUPnPError() {
        int n2 = 0;
        String string = "";
        n2 = this.getUPnPErrorCode();
        string = this.getUPnPErrorDescription();
        this.upnpErr.setCode(n2);
        this.upnpErr.setDescription(string);
        return this.upnpErr;
    }
}

