/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.os.Bundle;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;

public class ImageCaptureConfig
implements Cloneable {
    private static final String OPTION_CAPTURE_STRATEGY = "imageCapture.captureStrategy";
    private static final String OPTION_CAPTURE_MODE = "imageCapture.captureMode";
    private static final String OPTION_JPEG_COMPRESSION_QUALITY = "imageCapture.jpegCompressionQuality";
    private static final int DEFAULT_CAPTURE_STRATEGY = 0;
    private static final int DEFAULT_CAPTURE_MODE = 1;
    private static final int DEFAULT_JPEG_COMPRESSION_QUALITY = 95;
    private Bundle mMutableConfig = new Bundle();

    ImageCaptureConfig() {
    }

    Bundle getMutableConfig() {
        return this.mMutableConfig;
    }

    public ImageCaptureConfig setCaptureStrategy(int strategy) {
        this.getMutableConfig().putInt(OPTION_CAPTURE_STRATEGY, strategy);
        return this;
    }

    public int getCaptureStrategy() {
        return this.getMutableConfig().getInt(OPTION_CAPTURE_STRATEGY, 0);
    }

    public ImageCaptureConfig setCaptureMode(int mode) {
        this.getMutableConfig().putInt(OPTION_CAPTURE_MODE, mode);
        return this;
    }

    public int getCaptureMode() {
        return this.getMutableConfig().getInt(OPTION_CAPTURE_MODE, 1);
    }

    public ImageCaptureConfig setJpegCompressionQuality(@IntRange(from=1L, to=100L) int quality) {
        this.getMutableConfig().putInt(OPTION_JPEG_COMPRESSION_QUALITY, quality);
        return this;
    }

    public int getJpegCompressionQuality() {
        return this.getMutableConfig().getInt(OPTION_JPEG_COMPRESSION_QUALITY, 95);
    }

    public boolean hasJpegCompressionQuality() {
        return this.getMutableConfig().containsKey(OPTION_JPEG_COMPRESSION_QUALITY);
    }

    @NonNull
    protected Object clone() {
        ImageCaptureConfig obj = null;
        try {
            obj = (ImageCaptureConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (obj == null) {
            obj = new ImageCaptureConfig();
        }
        obj.mMutableConfig = (Bundle)this.mMutableConfig.clone();
        return obj;
    }
}

