/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.request.animation;

import android.content.Context;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.animation.GlideAnimationFactory;
import com.hpplay.glide.request.animation.NoAnimation;
import com.hpplay.glide.request.animation.ViewAnimation;

public class ViewAnimationFactory<R>
implements GlideAnimationFactory<R> {
    private final ViewAnimation.AnimationFactory animationFactory;
    private GlideAnimation<R> glideAnimation;

    public ViewAnimationFactory(Animation animation) {
        this(new ConcreteAnimationFactory(animation));
    }

    public ViewAnimationFactory(Context context, int n2) {
        this(new ResourceAnimationFactory(context, n2));
    }

    ViewAnimationFactory(ViewAnimation.AnimationFactory animationFactory) {
        this.animationFactory = animationFactory;
    }

    @Override
    public GlideAnimation<R> build(boolean bl, boolean bl2) {
        if (bl || !bl2) {
            return NoAnimation.get();
        }
        if (this.glideAnimation == null) {
            this.glideAnimation = new ViewAnimation(this.animationFactory);
        }
        return this.glideAnimation;
    }

    private static class ResourceAnimationFactory
    implements ViewAnimation.AnimationFactory {
        private final Context context;
        private final int animationId;

        public ResourceAnimationFactory(Context context, int n2) {
            this.context = context.getApplicationContext();
            this.animationId = n2;
        }

        @Override
        public Animation build() {
            return AnimationUtils.loadAnimation((Context)this.context, (int)this.animationId);
        }
    }

    private static class ConcreteAnimationFactory
    implements ViewAnimation.AnimationFactory {
        private final Animation animation;

        public ConcreteAnimationFactory(Animation animation) {
            this.animation = animation;
        }

        @Override
        public Animation build() {
            return this.animation;
        }
    }
}

