/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.imsdk;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.log.LeLog;
import com.hpplay.imsdk.IMConnectBean;
import com.hpplay.imsdk.MessageBean;
import com.hpplay.imsdk.MessageClient;
import com.hpplay.imsdk.OnConnectServerListener;
import com.hpplay.imsdk.OnReceiveMessageListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;

public class IMEntrance
implements Observer {
    private final String TAG = "IM_IMEntrance";
    public static final int IM_AUTH_RESULT_SUCCESS = 0;
    public static final int IM_AUTH_RESULT_FAIL = 1;
    public static final int IM_AUTH_RESULT_SERVER_FULL = 2;
    private final String PATH_PUSH = "/1/push";
    private final String PATH_PUSHS = "/1/pushs";
    private final String PATH_PUSHALL = "/1/push/all";
    private final String PATH_PUSHROOM = "/1/push/room";
    private final int PORT_CONNECT = 8080;
    private final int PORT_PUSH = 7172;
    private static IMEntrance instance = null;
    private AsyncTask mIMConnectTask;
    private MessageClient mMsgClient;
    private volatile boolean disconnect = true;
    private OnReceiveMessageListener mReceiveMessageListener;
    private String uid;
    private String appid;
    private String imUrl;
    private int sdkversion;
    private String token;
    private long qrtime;
    private String qrurl;
    private String capability;
    private OnConnectServerListener mConnectListener;
    private final int WHAT_MSG = 1;
    private final int WHAT_RECONNECT = 2;
    public static int sRetryCount = 0;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    MessageBean messageBean = (MessageBean)message.obj;
                    if (IMEntrance.this.mReceiveMessageListener == null) break;
                    IMEntrance.this.mReceiveMessageListener.onMsg(messageBean.opt, messageBean.message);
                    break;
                }
                case 2: {
                    IMEntrance.this.disconnect();
                    if (IMEntrance.this.mConnectListener == null) break;
                    IMEntrance.this.mConnectListener.onRestart();
                }
            }
            return false;
        }
    });
    private OnReceiveMessageListener msgReceiver = new OnReceiveMessageListener(){

        @Override
        public void onMsg(long l2, String string) {
            MessageBean messageBean = new MessageBean(l2, string);
            IMEntrance.this.mHandler.obtainMessage(1, (Object)messageBean).sendToTarget();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IMEntrance getInstance() {
        Class<IMEntrance> clazz = IMEntrance.class;
        synchronized (IMEntrance.class) {
            if (instance == null) {
                instance = new IMEntrance();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private IMEntrance() {
    }

    public boolean connect(IMConnectBean iMConnectBean) {
        if (!this.disconnect) {
            LeLog.i("IM_IMEntrance", "connect im is connecting now, call disconnect here");
            this.disconnect();
        }
        LeLog.i("IM_IMEntrance", "connect imUrl: " + iMConnectBean.imUrl + "  uid: " + iMConnectBean.uid);
        this.disconnect = false;
        return this.init(iMConnectBean);
    }

    private boolean init(IMConnectBean iMConnectBean) {
        if (this.disconnect) {
            LeLog.w("IM_IMEntrance", "init can not init, reason: already disconnect");
            return false;
        }
        this.uid = iMConnectBean.uid;
        this.appid = iMConnectBean.appid;
        this.imUrl = iMConnectBean.imUrl;
        this.sdkversion = iMConnectBean.sdkVersion;
        this.token = iMConnectBean.token;
        this.qrtime = iMConnectBean.qrTime;
        this.qrurl = iMConnectBean.qrUrl;
        this.capability = iMConnectBean.capability;
        try {
            String string = this.getHost(this.imUrl);
            this.mMsgClient = new MessageClient(string, 8080, this.uid, this.capability, this.appid, this.token);
            this.mMsgClient.setMsgReceiver(this.msgReceiver);
            this.mMsgClient.setOnConnectListener(this.mConnectListener);
            this.mMsgClient.addObserver(this);
            this.mIMConnectTask = AsyncManager.getInstance().exeRunnable(this.mMsgClient, null);
        }
        catch (Exception exception) {
            LeLog.w("IM_IMEntrance", exception);
            return false;
        }
        return true;
    }

    public void updateCapability(final String string) {
        this.capability = string;
        if (!this.isConnected()) {
            LeLog.w("IM_IMEntrance", "updateCapability ignore");
            return;
        }
        AsyncManager.getInstance().exeRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    ((IMEntrance)IMEntrance.this).mMsgClient.capability = string;
                    IMEntrance.this.mMsgClient.updateCapabilityWrite();
                }
                catch (Exception exception) {
                    LeLog.w("IM_IMEntrance", exception);
                }
            }
        }, null);
    }

    public boolean isConnected() {
        return this.mMsgClient != null && this.mMsgClient.isRunning();
    }

    public void disconnect() {
        LeLog.i("IM_IMEntrance", "disconnect");
        this.disconnect = true;
        this.mReceiveMessageListener = null;
        if (this.mMsgClient != null) {
            this.mMsgClient.deleteObservers();
            this.mMsgClient.stop();
            this.mMsgClient.deleteObservers();
        }
        if (this.mIMConnectTask != null) {
            this.mIMConnectTask.cancel(true);
            this.mIMConnectTask = null;
        }
    }

    public void setReceiveMessageListener(OnReceiveMessageListener onReceiveMessageListener) {
        this.mReceiveMessageListener = onReceiveMessageListener;
    }

    public void setOnConnectListener(OnConnectServerListener onConnectServerListener) {
        this.mConnectListener = onConnectServerListener;
        if (this.mMsgClient != null) {
            this.mMsgClient.setOnConnectListener(this.mConnectListener);
        }
    }

    public void sendSingleMsg(int n2, String string, String string2, String string3) {
        this.sendSingleMsg(n2, string, string2, string3, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 0) {
                    LeLog.i("IM_IMEntrance", "sendSingleMsg success");
                } else {
                    LeLog.i("IM_IMEntrance", "sendSingleMsg failed");
                }
            }
        });
    }

    public void sendSingleMsg(int n2, String string, String string2, String string3, AsyncHttpRequestListener asyncHttpRequestListener) {
        LeLog.i("IM_IMEntrance", "sendSingleMsg");
        String string4 = this.getPushUrl() + "/1/push" + "?uid=" + string2 + "&appid=" + string3;
        String string5 = this.padLeft(Integer.toHexString(n2), 8);
        String string6 = string5 + "," + string;
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string4, string6);
        asyncHttpParameter.in.requestMethod = 1;
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    public void sendChannelMsg(int n2, String string, int n3) {
        LeLog.i("IM_IMEntrance", "sendChannelMsg");
        String string2 = this.getPushUrl() + "/1/push/room" + "?rid=" + n3;
        String string3 = this.padLeft(Integer.toHexString(n2), 8);
        String string4 = string3 + "," + string;
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string2, string4);
        asyncHttpParameter.in.requestMethod = 1;
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 0) {
                    LeLog.i("IM_IMEntrance", "sendChannelMsg success");
                } else {
                    LeLog.i("IM_IMEntrance", "sendChannelMsg failed");
                }
            }
        });
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.disconnect) {
            LeLog.w("IM_IMEntrance", "update im already disconnect,ignore");
            return;
        }
        this.mHandler.obtainMessage(2).sendToTarget();
    }

    private String getHost(String string) {
        if (string.startsWith("http")) {
            try {
                String string2 = string.lastIndexOf(":") > string.indexOf("://") + 3 ? string.substring(string.indexOf("://") + 3, string.lastIndexOf(":")) : string.substring(string.indexOf("://") + 3);
                return string2;
            }
            catch (Exception exception) {
                LeLog.w("IM_IMEntrance", exception);
            }
        }
        return string;
    }

    private String getPushUrl() {
        if (!TextUtils.isEmpty((CharSequence)this.imUrl)) {
            if (this.imUrl.endsWith(":")) {
                return this.imUrl + 7172;
            }
            return this.imUrl + ":" + 7172;
        }
        return "";
    }

    private String padLeft(String string, int n2) {
        if (string.length() >= n2) {
            return string;
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = string.getBytes();
        Arrays.fill(byArray, (byte)48);
        System.arraycopy(byArray2, 0, byArray, n2 - byArray2.length, byArray2.length);
        return new String(byArray);
    }
}

