/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.tony.bluetoothunityapi.BluetoothDeviceAddress;
import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.EmptyActivity;
import com.tony.bluetoothunityapi.ScanResultBluetoothDevice;
import com.tony.bluetoothunityapi.ble.BluetoothHelperCharacteristic;
import com.tony.bluetoothunityapi.ble.BluetoothHelperService;
import com.tony.bluetoothunityapi.transceiver.CharacteristicTransceiver;
import com.tony.bluetoothunityapi.transceiver.ITransceiver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Semaphore;

@SuppressLint(value={"MissingPermission"})
public class BLEBluetoothHelper
extends BluetoothHelper {
    private BluetoothGatt gatt;
    private BluetoothGattCharacteristic txCharacteristic;
    private BluetoothGattCharacteristic rxCharacteristic;
    private CharacteristicTransceiver transceiver;
    private BluetoothHelperCharacteristic cTxCharacteristic;
    private BluetoothHelperCharacteristic cRxCharacteristic;
    private int retries;
    private final UUID PORT_UUID = UUID.fromString("0000ffe0-0000-1000-8000-00805f9b34fb");
    private final UUID PORT_UUID_CHAR = UUID.fromString("0000ffe1-0000-1000-8000-00805f9b34fb");
    private final UUID ADA_DATA_OUT_CHAR = UUID.fromString("6e400002-b5a3-f393-e0a9-e50e24dcca9e");
    private final UUID ADA_DATA_IN_CHAR = UUID.fromString("6e400003-b5a3-f393-e0a9-e50e24dcca9e");
    private final UUID ADA_SERVICE_UUID = UUID.fromString("6e400001-b5a3-f393-e0a9-e50e24dcca9e");
    private final UUID ADA_CONFIG_CHAR = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private final UUID DF_ROBOT_SERVICE_UUID = UUID.fromString("0000dfb0-0000-1000-8000-00805f9b34fb");
    private final UUID DF_ROBOT_SERVICE_UUID_CHAR = UUID.fromString("0000dfb1-0000-1000-8000-00805f9b34fb");
    private LinkedList<BluetoothHelperService> services;
    private List<BluetoothHelperService> peripheralServices;
    private LinkedList<ScanResultBluetoothDevice> bleDevices;
    private static final LinkedList<ScanResultBluetoothDevice> sharedBleDevices = new LinkedList();
    private LinkedList<BluetoothGattCharacteristic> pendingCharacteristics;
    private LinkedList<BluetoothGattCharacteristic> pendingUnsCharacteristics;
    private boolean discoveringServices;
    private final Semaphore semaphore;
    private final ScanCallback scanCallback = new ScanCallback(){

        public void onScanResult(int callbackType, ScanResult result) {
            super.onScanResult(callbackType, result);
            this.processResult(result);
        }

        public void onBatchScanResults(List<ScanResult> results) {
            super.onBatchScanResults(results);
            Log.d((String)"BluetoothAPI", (String)"found devices ...");
            for (ScanResult r : results) {
                this.processResult(r);
            }
        }

        public void onScanFailed(int errorCode) {
            super.onScanFailed(errorCode);
            Log.d((String)"BluetoothAPI", (String)("Scan failed [" + errorCode + "] ..."));
        }

        private void processResult(ScanResult result) {
            Log.d((String)"BluetoothAPI", (String)"found device ...");
            BluetoothDevice device = result.getDevice();
            result.getRssi();
            ScanResultBluetoothDevice bleScanResult = new ScanResultBluetoothDevice(device, result.getRssi());
            Log.d((String)"BluetoothAPI", (String)("found device [" + device.getName() + "][" + device.getAddress() + "]"));
            if (device.getName() == null) {
                return;
            }
            int index = BLEBluetoothHelper.this.bleDevices.indexOf(bleScanResult);
            if (index == -1) {
                BLEBluetoothHelper.this.bleDevices.add(bleScanResult);
            } else {
                ((ScanResultBluetoothDevice)BLEBluetoothHelper.this.bleDevices.get(index)).setRssi((result.getRssi() + ((ScanResultBluetoothDevice)BLEBluetoothHelper.this.bleDevices.get(index)).getRssi()) / 2);
            }
        }
    };
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            Log.d((String)"BluetoothAPI", (String)("onConnectionStateChange " + status));
            if (status != 0) {
                Log.d((String)"BluetoothAPI", (String)"onConnectionStateChange failed");
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
            } else if (newState == 2 && !BLEBluetoothHelper.this.discoveringServices) {
                BLEBluetoothHelper.this.discoveringServices = true;
                BLEBluetoothHelper.this.retries = 0;
                gatt.requestConnectionPriority(1);
                Log.d((String)"BluetoothAPI", (String)("Discovering services " + gatt.getServices().size()));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Log.e((String)"BluetoothAPI", (String)"Error", (Throwable)e);
                }
                if (gatt.getServices().size() != 0) {
                    this.onServicesDiscovered(gatt, status);
                } else if (!gatt.discoverServices()) {
                    Log.w((String)"BluetoothAPI", (String)"Unable to discover services");
                    gatt.disconnect();
                    gatt.close();
                    BLEBluetoothHelper.this.invokeOnConnectionFailed();
                } else {
                    Log.d((String)"BluetoothAPI", (String)"Discovering services started");
                }
            } else if (newState == 0 && (BLEBluetoothHelper.this.connected || BLEBluetoothHelper.this.isConnecting)) {
                Log.w((String)"BluetoothAPI", (String)"disconnecting!");
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.peripheralServices.clear();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
            } else if (newState == 1) {
                Log.d((String)"BluetoothAPI", (String)"Connecting");
                BLEBluetoothHelper.this.discoveringServices = false;
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            BLEBluetoothHelper.this.discoveringServices = false;
            BLEBluetoothHelper.this.gatt = gatt;
            Log.d((String)"BluetoothAPI", (String)"onServicesDiscovered");
            BLEBluetoothHelper.this.peripheralServices.clear();
            if (gatt.getServices().size() == 0) {
                Log.w((String)"BluetoothAPI", (String)"no services discovered, disconnecting");
                if (!BLEBluetoothHelper.this.refreshDeviceCache(gatt)) {
                    Log.w((String)"BluetoothAPI", (String)"failed to refresh cache");
                }
                gatt.disconnect();
                gatt.close();
                BLEBluetoothHelper.this.peripheralServices.clear();
                BLEBluetoothHelper.this.invokeOnConnectionFailed();
                return;
            }
            for (BluetoothGattService service : gatt.getServices()) {
                Log.d((String)"BluetoothAPI", (String)service.getUuid().toString());
                BluetoothHelperService s = new BluetoothHelperService(service.getUuid().toString());
                for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
                    s.addCharacteristic(new BluetoothHelperCharacteristic(characteristic.getUuid().toString()));
                }
                BLEBluetoothHelper.this.peripheralServices.add(s);
            }
            this.startSubscription(gatt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            try {
                BLEBluetoothHelper.this.semaphore.acquire();
                if (BLEBluetoothHelper.this.streamManager == null) {
                    BluetoothHelperCharacteristic charac = new BluetoothHelperCharacteristic();
                    charac.setService(characteristic.getService().getUuid().toString());
                    charac.setName(characteristic.getUuid().toString());
                    BLEBluetoothHelper.this.invokeOnCharacteristicChanged(characteristic.getValue(), charac);
                } else if (BLEBluetoothHelper.this.transceiver != null) {
                    BLEBluetoothHelper.this.transceiver.InvokeMessageReceived(characteristic.getValue());
                }
            }
            catch (Exception e) {
                Log.e((String)"BluetoothAPI", (String)"Error", (Throwable)e);
            }
            finally {
                BLEBluetoothHelper.this.semaphore.release();
            }
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            super.onMtuChanged(gatt, mtu, status);
            if (status != 0) {
                Log.d((String)"BluetoothAPI", (String)"onMtuChanged failed");
            } else {
                Log.d((String)"BluetoothAPI", (String)"MTU changed successfully");
            }
        }

        private void startSubscription(BluetoothGatt gatt) {
            Log.d((String)"BluetoothAPI", (String)"Ready to subscribe");
            if (BLEBluetoothHelper.this.services.size() == 0 || BLEBluetoothHelper.this.cTxCharacteristic != null || BLEBluetoothHelper.this.cRxCharacteristic != null) {
                BLEBluetoothHelper.this.subscribeToSerialServices(gatt);
            } else {
                BLEBluetoothHelper.this.subscribeToSelectedServices(gatt);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            Log.d((String)"BluetoothAPI", (String)"Characteristic read");
            BluetoothHelperCharacteristic charac = new BluetoothHelperCharacteristic();
            charac.setService(characteristic.getService().getUuid().toString());
            charac.setName(characteristic.getUuid().toString());
            BLEBluetoothHelper.this.invokeOnCharacteristicChanged(characteristic.getValue(), charac);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorWrite(gatt, descriptor, status);
            Log.d((String)"BluetoothAPI", (String)("Subscription Completed " + status));
            BLEBluetoothHelper.this.subscribeSingleCharacteristics(gatt);
        }
    };
    private final Runnable scanningRunnable = new Runnable(){

        @Override
        public void run() {
            BluetoothHelper.isScanning = false;
            Log.d((String)"BluetoothAPI", (String)"Stopping scan");
            BLEBluetoothHelper.this.bluetoothAdapter.getBluetoothLeScanner().stopScan(BLEBluetoothHelper.this.scanCallback);
            BLEBluetoothHelper.this.bluetoothAdapter.getBluetoothLeScanner().flushPendingScanResults(BLEBluetoothHelper.this.scanCallback);
            sharedBleDevices.clear();
            BluetoothHelper.nearbyDevices.clear();
            sharedBleDevices.addAll(BLEBluetoothHelper.this.bleDevices);
            Log.d((String)"BluetoothAPI", (String)("found " + sharedBleDevices.size() + " devices"));
            for (ScanResultBluetoothDevice device : sharedBleDevices) {
                BluetoothDeviceAddress deviceAddress = new BluetoothDeviceAddress(device.getName(), device.getAddress(), device.getRssi());
                BluetoothHelper.nearbyDevices.add(deviceAddress);
            }
            BLEBluetoothHelper.this.isDevicePaired();
            BLEBluetoothHelper.this.invokeOnScanEnded();
        }
    };
    private final Runnable connectionRunnable = new Runnable(){

        @Override
        public void run() {
            if (!BLEBluetoothHelper.this.isConnecting || BLEBluetoothHelper.this.connected) {
                return;
            }
            BLEBluetoothHelper.this.retries--;
            try {
                BLEBluetoothHelper.this.gatt.disconnect();
                BLEBluetoothHelper.this.gatt.close();
                BLEBluetoothHelper.this.gatt = null;
                if (BLEBluetoothHelper.this.retries > 0) {
                    BLEBluetoothHelper.this.connect();
                } else {
                    Log.d((String)"BluetoothAPI", (String)"No more retries, disconnecting");
                    BLEBluetoothHelper.this.invokeOnConnectionFailed();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    private void subscribeToSerialServices(BluetoothGatt gatt) {
        try {
            if (this.cRxCharacteristic != null || this.cTxCharacteristic != null) {
                BluetoothGattService service;
                if (this.cTxCharacteristic != null) {
                    service = gatt.getService(BLEBluetoothHelper.GetUUIDFromString(this.cTxCharacteristic.getService()));
                    if (service != null) {
                        this.txCharacteristic = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(this.cTxCharacteristic.getName()));
                        if (this.txCharacteristic == null) {
                            this.invokeOnCharacteristicNotFound(this.cTxCharacteristic.getService(), this.cTxCharacteristic.getName());
                        }
                    } else {
                        this.invokeOnServiceNotFound(this.cTxCharacteristic.getService());
                    }
                }
                if (this.cRxCharacteristic != null) {
                    service = gatt.getService(BLEBluetoothHelper.GetUUIDFromString(this.cRxCharacteristic.getService()));
                    if (service != null) {
                        this.rxCharacteristic = this.subscribeNotifyIndicateCharacteristic(gatt, service, BLEBluetoothHelper.GetUUIDFromString(this.cRxCharacteristic.getName()));
                    } else {
                        this.invokeOnServiceNotFound(this.cTxCharacteristic.getService());
                    }
                }
            } else {
                BluetoothGattService service = gatt.getService(this.PORT_UUID);
                if (service != null) {
                    Log.d((String)"BluetoothAPI", (String)("TX RX [" + this.PORT_UUID.toString() + "]"));
                    this.txCharacteristic = (BluetoothGattCharacteristic)service.getCharacteristics().get(0);
                    this.rxCharacteristic = this.subscribeNotifyIndicateCharacteristic(gatt, service, this.PORT_UUID_CHAR);
                } else {
                    service = gatt.getService(this.ADA_SERVICE_UUID);
                    if (service != null) {
                        Log.d((String)"BluetoothAPI", (String)("TX RX [" + this.ADA_SERVICE_UUID.toString() + "]"));
                        this.rxCharacteristic = this.subscribeNotifyIndicateCharacteristic(gatt, service, this.ADA_DATA_IN_CHAR);
                        this.txCharacteristic = service.getCharacteristic(this.ADA_DATA_OUT_CHAR);
                    } else {
                        service = gatt.getService(this.DF_ROBOT_SERVICE_UUID);
                        if (service != null) {
                            Log.d((String)"BluetoothAPI", (String)("TX RX [" + this.DF_ROBOT_SERVICE_UUID.toString() + "]"));
                            this.txCharacteristic = (BluetoothGattCharacteristic)service.getCharacteristics().get(0);
                            this.rxCharacteristic = this.subscribeNotifyIndicateCharacteristic(gatt, service, this.DF_ROBOT_SERVICE_UUID_CHAR);
                        } else {
                            Log.d((String)"BluetoothAPI", (String)"Not subscribing");
                        }
                    }
                }
            }
            this.invokeOnConnected();
        }
        catch (Exception ex) {
            Log.d((String)"BluetoothAPI", (String)"Error", (Throwable)ex);
            gatt.disconnect();
            gatt.close();
            this.invokeOnConnectionFailed();
        }
    }

    private boolean refreshDeviceCache(BluetoothGatt gatt) {
        try {
            Method localMethod = gatt.getClass().getMethod("refresh", new Class[0]);
            return (Boolean)localMethod.invoke((Object)gatt, new Object[0]);
        }
        catch (Exception ex) {
            Log.e((String)"BluetoothAPI", (String)"An exception occurred while refreshing device", (Throwable)ex);
            return false;
        }
    }

    private BluetoothGattCharacteristic subscribeNotifyIndicateCharacteristic(BluetoothGatt gatt, BluetoothGattService s, UUID c) {
        BluetoothGattDescriptor config;
        BluetoothGattCharacteristic characteristic = s.getCharacteristic(c);
        if (characteristic == null) {
            this.invokeOnCharacteristicNotFound(s.getUuid().toString(), c.toString());
            return null;
        }
        if (!gatt.setCharacteristicNotification(characteristic, true)) {
            Log.d((String)"BluetoothAPI", (String)("subscription failed for [" + c.toString() + "]"));
        }
        if ((config = characteristic.getDescriptor(this.ADA_CONFIG_CHAR)) != null) {
            int j = characteristic.getProperties();
            if ((j & 0x20) != 0) {
                config.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                gatt.writeDescriptor(config);
            } else if ((j & 0x10) != 0) {
                config.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                gatt.writeDescriptor(config);
            }
        }
        return characteristic;
    }

    private void subscribeToSelectedServices(BluetoothGatt gatt) {
        try {
            for (BluetoothHelperService srvc : this.services) {
                this.subscribeBleService(srvc);
            }
            this.subscribeSingleCharacteristics(gatt);
        }
        catch (Exception ex) {
            Log.d((String)"BluetoothAPI", (String)"Error", (Throwable)ex);
            gatt.disconnect();
            gatt.close();
            this.invokeOnConnectionFailed();
        }
    }

    private void subscribeBleService(BluetoothHelperService srvc) {
        Log.d((String)"BluetoothAPI", (String)("Service Name : " + srvc.getName()));
        BluetoothGattService service = this.gatt.getService(BLEBluetoothHelper.GetUUIDFromString(srvc.getName()));
        if (service == null) {
            Log.d((String)"BluetoothAPI", (String)"service is null");
            this.invokeOnServiceNotFound(srvc.getName());
            return;
        }
        for (BluetoothHelperCharacteristic characteristic : srvc.getCharacteristics()) {
            Log.d((String)"BluetoothAPI", (String)characteristic.getName());
            BluetoothGattCharacteristic gattCharacteristic = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(characteristic.getName()));
            if (gattCharacteristic == null) {
                Log.d((String)"BluetoothAPI", (String)"characteristic is null");
                this.invokeOnCharacteristicNotFound(characteristic.getService(), characteristic.getName());
                continue;
            }
            Log.d((String)"BluetoothAPI", (String)("Adding " + characteristic.getName()));
            this.pendingCharacteristics.add(gattCharacteristic);
        }
    }

    private void unsubscribeBleService(BluetoothHelperService srvc) {
        Log.d((String)"BluetoothAPI", (String)("Service Name : " + srvc.getName()));
        BluetoothGattService service = this.gatt.getService(BLEBluetoothHelper.GetUUIDFromString(srvc.getName()));
        if (service == null) {
            Log.d((String)"BluetoothAPI", (String)"service is null");
            this.invokeOnServiceNotFound(srvc.getName());
            return;
        }
        for (BluetoothHelperCharacteristic characteristic : srvc.getCharacteristics()) {
            Log.d((String)"BluetoothAPI", (String)characteristic.getName());
            BluetoothGattCharacteristic gattCharacteristic = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(characteristic.getName()));
            if (gattCharacteristic == null) {
                Log.d((String)"BluetoothAPI", (String)"characteristic is null");
                this.invokeOnCharacteristicNotFound(characteristic.getService(), characteristic.getName());
                continue;
            }
            Log.d((String)"BluetoothAPI", (String)("Removing " + characteristic.getName()));
            this.pendingUnsCharacteristics.add(gattCharacteristic);
        }
    }

    private void subscribeSingleCharacteristics(BluetoothGatt gatt) {
        if (this.pendingCharacteristics.size() == 0) {
            Log.d((String)"BluetoothAPI", (String)("Done subscribing ... " + this.connected));
            this.services.clear();
            this.invokeOnConnected();
            return;
        }
        Log.d((String)"BluetoothAPI", (String)"Subscribing...");
        BluetoothGattCharacteristic characteristic = this.pendingCharacteristics.poll();
        if (characteristic == null) {
            Log.w((String)"BluetoothAPI", (String)"NO characteristic, should not reach here");
            return;
        }
        Log.d((String)"BluetoothAPI", (String)("Subscribing to : " + characteristic.getUuid().toString()));
        characteristic.setWriteType(2);
        gatt.setCharacteristicNotification(characteristic, true);
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.ADA_CONFIG_CHAR);
        if (descriptor != null) {
            Log.d((String)"BluetoothAPI", (String)("descr uuid : " + descriptor.getUuid().toString()));
            int j = characteristic.getProperties();
            if ((j & 0x20) != 0) {
                descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                gatt.writeDescriptor(descriptor);
                Log.d((String)"BluetoothAPI", (String)("indication : " + descriptor.getUuid().toString()));
            } else if ((j & 0x10) != 0) {
                descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                gatt.writeDescriptor(descriptor);
                Log.d((String)"BluetoothAPI", (String)("notification : " + descriptor.getUuid().toString()));
            } else {
                this.subscribeSingleCharacteristics(gatt);
            }
        } else {
            this.subscribeSingleCharacteristics(gatt);
        }
    }

    private void unsubscribeSingleCharacteristics(BluetoothGatt gatt) {
        if (this.pendingUnsCharacteristics.size() == 0) {
            Log.d((String)"BluetoothAPI", (String)"Done unsubscribing ... ");
            return;
        }
        Log.d((String)"BluetoothAPI", (String)"Unsubscribing...");
        BluetoothGattCharacteristic characteristic = this.pendingUnsCharacteristics.poll();
        if (characteristic == null) {
            Log.w((String)"BluetoothAPI", (String)"No characteristic, should not reach here");
            return;
        }
        Log.d((String)"BluetoothAPI", (String)("Unsubscribing from : " + characteristic.getUuid().toString()));
        characteristic.setWriteType(2);
        gatt.setCharacteristicNotification(characteristic, false);
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(this.ADA_CONFIG_CHAR);
        if (descriptor != null) {
            Log.d((String)"BluetoothAPI", (String)("descr uuid : " + descriptor.getUuid().toString()));
            int j = characteristic.getProperties();
            if ((j & 0x20) != 0) {
                descriptor.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                gatt.writeDescriptor(descriptor);
                Log.d((String)"BluetoothAPI", (String)("disable indication : " + descriptor.getUuid().toString()));
            } else if ((j & 0x10) != 0) {
                descriptor.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
                gatt.writeDescriptor(descriptor);
                Log.d((String)"BluetoothAPI", (String)("disable notification : " + descriptor.getUuid().toString()));
            } else {
                this.unsubscribeSingleCharacteristics(gatt);
            }
        } else {
            this.unsubscribeSingleCharacteristics(gatt);
        }
    }

    BLEBluetoothHelper(Context context, String deviceName) {
        super(context, deviceName);
        this.semaphore = new Semaphore(1);
    }

    @Override
    protected void BTinit() {
        super.BTinit();
        this.peripheralServices = new ArrayList<BluetoothHelperService>();
        this.bleDevices = new LinkedList();
        this.services = new LinkedList();
        this.transceiver = new CharacteristicTransceiver(this);
        this.pendingCharacteristics = new LinkedList();
        this.pendingUnsCharacteristics = new LinkedList();
        this.retries = 0;
    }

    @Override
    public boolean scanNearbyDevices(int scanningTime) {
        if (isScanning) {
            return false;
        }
        if (!this.bluetoothAdapter.isEnabled()) {
            throw new BluetoothHelper.BlueToothNotEnabledException();
        }
        isScanning = true;
        Log.d((String)"BluetoothAPI", (String)"Preparing scanning");
        if (!this.areLocationPermissionsGranted() || this.isLocationServiceOff()) {
            return this.startCompanionScanning();
        }
        this.bleDevices.clear();
        Log.d((String)"BluetoothAPI", (String)"Start scanning");
        this.bluetoothAdapter.getBluetoothLeScanner().startScan(this.scanCallback);
        Log.d((String)"BluetoothAPI", (String)"Scan started");
        Handler stopHandler = new Handler();
        stopHandler.postDelayed(this.scanningRunnable, (long)scanningTime * 1000L);
        return true;
    }

    @Override
    public boolean scanNearbyDevices() {
        return this.scanNearbyDevices(8);
    }

    @Override
    public List<BluetoothDeviceAddress> getPairedDevicesList() {
        throw new BluetoothHelper.MethodNotSupportedException();
    }

    @Override
    public void setMtu(int mtu) {
        if (!this.connected || this.gatt == null) {
            throw new BluetoothHelper.BlueToothNotReadyException();
        }
        this.gatt.requestMtu(mtu);
    }

    @Override
    protected void searchForDevice() {
        Log.d((String)"BluetoothAPI", (String)"searchForDevice");
        this.devicePaired = false;
        this.device = null;
        if (this.deviceName == null && this.deviceAddress == null) {
            return;
        }
        Log.d((String)"BluetoothAPI", (String)("Checking for  [" + this.deviceName + "] [" + this.deviceAddress + "]"));
        if (this.bluetoothAdapter == null) {
            return;
        }
        for (ScanResultBluetoothDevice iterator : sharedBleDevices) {
            Log.d((String)"BluetoothAPI", (String)("against [" + iterator.getName() + "] [" + iterator.getAddress() + "]"));
            if (this.deviceName != null) {
                if (!iterator.getName().equals(this.deviceName)) continue;
                this.bt_device = iterator;
                this.devicePaired = true;
                Log.d((String)"BluetoothAPI", (String)"Device found by name");
                break;
            }
            if (!iterator.getAddress().equals(this.deviceAddress)) continue;
            this.bt_device = iterator;
            this.devicePaired = true;
            Log.d((String)"BluetoothAPI", (String)"Device found by address");
            break;
        }
        if (this.devicePaired) {
            this.device = new BluetoothDeviceAddress(this.bt_device.getName(), this.bt_device.getAddress(), this.bt_device.getRssi());
        }
    }

    @Override
    public void connect() {
        if (this.connected) {
            return;
        }
        if (this.isConnecting && this.retries > 0) {
            return;
        }
        if (!this.isConnecting) {
            this.retries = 2;
        }
        if (!this.bluetoothAdapter.isEnabled()) {
            throw new BluetoothHelper.BlueToothNotEnabledException();
        }
        if (!this.devicePaired) {
            throw new BluetoothHelper.BlueToothNotReadyException();
        }
        this.connected = false;
        Log.d((String)"BluetoothAPI", (String)("Connecting " + this.retries));
        this.isConnecting = true;
        this.discoveringServices = false;
        this.gatt = Build.VERSION.SDK_INT < 23 ? this.bt_device.getBluetoothDevice().connectGatt(this.context, false, this.gattCallback) : this.bt_device.getBluetoothDevice().connectGatt(this.context, false, this.gattCallback, 2);
        Handler stopHandler = new Handler();
        stopHandler.postDelayed(this.connectionRunnable, 10000L);
    }

    @Override
    public void disconnect() {
        this.connected = false;
        this.peripheralServices.clear();
        if (this.gatt != null) {
            this.gatt.disconnect();
            this.gatt.close();
            Log.d((String)"BluetoothAPI", (String)"Disconnected");
        }
        if (this.streamManager != null) {
            this.streamManager.setStopThread(true);
        }
        this.gatt = null;
        this.device = null;
        this.bt_device = null;
        this.deviceName = null;
        this.deviceAddress = null;
    }

    @Override
    public ITransceiver getTransceiver() {
        return this.transceiver;
    }

    public BluetoothGatt getGatt() {
        return this.gatt;
    }

    public BluetoothGattCharacteristic getTxCharacteristic() {
        return this.txCharacteristic;
    }

    @Override
    public void subscribe(BluetoothHelperService service) {
        if (!this.connected || this.gatt == null) {
            if (this.services.contains(service)) {
                return;
            }
            this.services.add(service);
        } else {
            this.subscribeBleService(service);
            this.subscribeSingleCharacteristics(this.gatt);
        }
    }

    @Override
    public void subscribe(BluetoothHelperCharacteristic characteristic) {
        BluetoothHelperService s = new BluetoothHelperService(characteristic.getService());
        if (this.services.contains(s)) {
            s = this.services.get(this.services.indexOf(s));
        }
        s.addCharacteristic(characteristic);
        if (this.connected && this.gatt != null) {
            this.subscribeBleService(s);
            this.subscribeSingleCharacteristics(this.gatt);
        } else {
            this.services.add(s);
        }
    }

    @Override
    public void unsubscribe(BluetoothHelperService service) {
        if (!this.connected || this.gatt == null) {
            for (BluetoothHelperCharacteristic c : service.getCharacteristics()) {
                for (BluetoothHelperService s : this.services) {
                    if (!s.getName().equals(c.getService())) continue;
                    s.getCharacteristics().remove(c);
                }
            }
        } else {
            this.unsubscribeBleService(service);
            this.unsubscribeSingleCharacteristics(this.gatt);
        }
    }

    @Override
    public void unsubscribe(BluetoothHelperCharacteristic characteristic) {
        if (!this.connected || this.gatt == null) {
            for (BluetoothHelperService s : this.services) {
                if (!s.getName().equals(characteristic.getService())) continue;
                s.getCharacteristics().remove(characteristic);
            }
        } else {
            BluetoothHelperService s = new BluetoothHelperService(characteristic.getService());
            s.addCharacteristic(characteristic);
            this.unsubscribeBleService(s);
            this.unsubscribeSingleCharacteristics(this.gatt);
        }
    }

    @Override
    public void writeCharacteristic(BluetoothHelperCharacteristic characteristic, byte[] value) {
        if (!this.connected) {
            throw new BluetoothHelper.BlueToothNotConnectedException();
        }
        BluetoothGattService service = this.gatt.getService(BLEBluetoothHelper.GetUUIDFromString(characteristic.getService()));
        if (service == null) {
            throw new BluetoothHelper.ServiceNotFoundException();
        }
        BluetoothGattCharacteristic characteristic1 = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(characteristic.getName()));
        if (characteristic1 == null) {
            throw new BluetoothHelper.CharacteristicNotFoundException();
        }
        characteristic1.setValue(value);
        if (!this.gatt.writeCharacteristic(characteristic1)) {
            Log.d((String)"BluetoothAPI", (String)"Writing failed");
        }
    }

    @Override
    public void readCharacteristic(BluetoothHelperCharacteristic characteristic) {
        if (!this.connected) {
            throw new BluetoothHelper.BlueToothNotConnectedException();
        }
        BluetoothGattService service = this.gatt.getService(BLEBluetoothHelper.GetUUIDFromString(characteristic.getService()));
        if (service == null) {
            throw new BluetoothHelper.ServiceNotFoundException();
        }
        BluetoothGattCharacteristic characteristic1 = service.getCharacteristic(BLEBluetoothHelper.GetUUIDFromString(characteristic.getName()));
        if (characteristic1 == null) {
            throw new BluetoothHelper.CharacteristicNotFoundException();
        }
        Log.d((String)"BluetoothAPI", (String)("Reading characteristic [" + characteristic.getName() + "]"));
        if (!this.gatt.readCharacteristic(characteristic1)) {
            Log.d((String)"BluetoothAPI", (String)"Reading failed");
        }
    }

    private static UUID GetUUIDFromString(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.toLowerCase()).length() == 4) {
            return UUID.fromString("0000" + name + "-0000-1000-8000-00805f9b34fb");
        }
        return UUID.fromString(name);
    }

    @Override
    public void setTxCharacteristic(BluetoothHelperCharacteristic characteristic) {
        this.cTxCharacteristic = characteristic;
    }

    @Override
    public void setRxCharacteristic(BluetoothHelperCharacteristic characteristic) {
        this.cRxCharacteristic = characteristic;
    }

    @Override
    public List<BluetoothHelperService> getGattServices() {
        return this.peripheralServices;
    }

    private boolean isLocationServiceOff() {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        LocationManager lm = (LocationManager)this.context.getSystemService("location");
        boolean gps_enabled = false;
        boolean network_enabled = false;
        try {
            gps_enabled = lm.isProviderEnabled("gps");
            Log.d((String)"BluetoothAPI", (String)("GPS Enabled [" + gps_enabled + "]"));
        }
        catch (Exception ex) {
            Log.e((String)"BluetoothAPI", (String)"error", (Throwable)ex);
        }
        try {
            network_enabled = lm.isProviderEnabled("network");
            Log.d((String)"BluetoothAPI", (String)("Network Enabled [" + network_enabled + "]"));
        }
        catch (Exception ex) {
            Log.e((String)"BluetoothAPI", (String)"error", (Throwable)ex);
        }
        return !gps_enabled && !network_enabled;
    }

    private boolean startCompanionScanning() {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        Log.d((String)"BluetoothAPI", (String)"Starting companion scanning in new activity");
        Intent intent = new Intent(this.context, EmptyActivity.class);
        intent.addFlags(0x4000000);
        intent.putExtra("BluetoothAPI", this.getId());
        this.context.startActivity(intent);
        return true;
    }

    @Override
    public void OnDeviceChosen(BluetoothDevice device) {
        isScanning = false;
        if (device != null && device.getName() != null) {
            ScanResultBluetoothDevice bleScanResult = new ScanResultBluetoothDevice(device, 0);
            Log.d((String)"BluetoothAPI", (String)("got device [" + device.getName() + "][" + device.getAddress() + "]"));
            this.bleDevices.add(bleScanResult);
        }
        sharedBleDevices.clear();
        nearbyDevices.clear();
        sharedBleDevices.addAll(this.bleDevices);
        Log.d((String)"BluetoothAPI", (String)("found " + sharedBleDevices.size() + " devices"));
        for (ScanResultBluetoothDevice d : sharedBleDevices) {
            BluetoothDeviceAddress deviceAddress = new BluetoothDeviceAddress(d.getName(), d.getAddress(), d.getRssi());
            nearbyDevices.add(deviceAddress);
        }
        this.isDevicePaired();
        this.invokeOnScanEnded();
    }

    @Override
    public boolean isBLE() {
        return true;
    }

    public LinkedList<BluetoothHelperService> getServices() {
        return this.services;
    }
}

