/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.utils.BrowserResolver;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.KeepAliveUtitls;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OnlineManager {
    private final String TAG = "OnlineManager";
    private Map<String, Long> mOnlineTimeStamp = new ConcurrentHashMap<String, Long>();
    private static final long CHECK_INTERVAL = 120000L;

    public void updateOnlineTime(LelinkServiceInfo lelinkServiceInfo) {
        this.mOnlineTimeStamp.put(CastUtil.getKey(lelinkServiceInfo), System.currentTimeMillis());
    }

    public void remove(LelinkServiceInfo lelinkServiceInfo) {
        String string = CastUtil.getKey(lelinkServiceInfo);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mOnlineTimeStamp.remove(string);
        }
    }

    public boolean checkOnline(final LelinkServiceInfo lelinkServiceInfo, final OnlineListener onlineListener) {
        try {
            final boolean bl = this.isInBrowseList(lelinkServiceInfo);
            String string = CastUtil.getKey(lelinkServiceInfo);
            if (bl && !TextUtils.isEmpty((CharSequence)string) && this.mOnlineTimeStamp.containsKey(string) && System.currentTimeMillis() - this.mOnlineTimeStamp.get(string) < 120000L) {
                return false;
            }
            AsyncManager.getInstance().exeRunnable(new Runnable(){

                @Override
                public void run() {
                    BrowserInfo browserInfo;
                    BrowserInfo browserInfo2;
                    BrowserInfo browserInfo3 = CastUtil.getBrowserInfo(lelinkServiceInfo, 1);
                    if (browserInfo3 != null) {
                        boolean bl2 = KeepAliveUtitls.tcpCheckTvState(browserInfo3.getName(), browserInfo3.getIp(), browserInfo3.getPort());
                        SourceLog.w("OnlineManager", "checkOnline lelink is online:" + bl2);
                        if (bl2) {
                            if (!bl) {
                                BrowserResolver.updateServiceList(lelinkServiceInfo);
                            }
                            if (onlineListener != null) {
                                onlineListener.OnLineCheckResult(lelinkServiceInfo, true);
                            }
                            return;
                        }
                        browserInfo3.setOnLine(false);
                    }
                    if ((browserInfo2 = CastUtil.getBrowserInfo(lelinkServiceInfo, 3)) != null) {
                        boolean bl3 = KeepAliveUtitls.tcpCheckTvState(browserInfo2.getName(), browserInfo2.getIp(), browserInfo2.getPort());
                        SourceLog.w("OnlineManager", "checkOnline dlna is online:" + bl3);
                        lelinkServiceInfo.setIp(browserInfo2.getIp());
                        lelinkServiceInfo.setPort(browserInfo2.getPort());
                        if (bl3) {
                            SourceLog.w("OnlineManager", "checkOnline remove lelink info");
                            lelinkServiceInfo.getBrowserInfos().remove(1);
                            if (!bl) {
                                BrowserResolver.updateServiceList(lelinkServiceInfo);
                            }
                            if (onlineListener != null) {
                                onlineListener.OnLineCheckResult(lelinkServiceInfo, true);
                            }
                            return;
                        }
                        browserInfo2.setOnLine(false);
                    }
                    if ((browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 4)) != null) {
                        ArrayList<BrowserInfo> arrayList = new ArrayList<BrowserInfo>();
                        arrayList.add(browserInfo);
                        KeepAliveUtitls.httpPostCheckTvState(arrayList);
                        SourceLog.w("OnlineManager", "checkOnline im is online:" + browserInfo.isOnLine());
                        lelinkServiceInfo.setIp(browserInfo.getIp());
                        lelinkServiceInfo.setPort(browserInfo.getPort());
                        if (browserInfo.isOnLine()) {
                            SourceLog.w("OnlineManager", "checkOnline remove lelink info");
                            lelinkServiceInfo.getBrowserInfos().remove(1);
                            SourceLog.w("OnlineManager", "checkOnline remove dlna info");
                            lelinkServiceInfo.getBrowserInfos().remove(3);
                            if (!bl) {
                                BrowserResolver.updateServiceList(lelinkServiceInfo);
                            }
                            if (onlineListener != null) {
                                onlineListener.OnLineCheckResult(lelinkServiceInfo, true);
                            }
                            return;
                        }
                        browserInfo.setOnLine(false);
                    }
                    SourceLog.w("OnlineManager", "checkOnline im is offline:" + lelinkServiceInfo);
                    if (onlineListener != null) {
                        onlineListener.OnLineCheckResult(lelinkServiceInfo, false);
                    }
                }
            }, null);
            return true;
        }
        catch (Exception exception) {
            SourceLog.w("OnlineManager", exception);
            return false;
        }
    }

    private boolean isInBrowseList(LelinkServiceInfo lelinkServiceInfo) {
        List<LelinkServiceInfo> list = LelinkSdkManager.getInstance().getBrowserList();
        if (lelinkServiceInfo == null || list == null) {
            return false;
        }
        try {
            for (LelinkServiceInfo lelinkServiceInfo2 : list) {
                if (!lelinkServiceInfo2.equals(lelinkServiceInfo)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w("OnlineManager", exception);
        }
        SourceLog.w("OnlineManager", "not in browseList, info " + lelinkServiceInfo);
        return false;
    }

    public static interface OnlineListener {
        public void OnLineCheckResult(LelinkServiceInfo var1, boolean var2);
    }
}

