/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.connection;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.protocol.connection.IConnection;
import org.json.JSONObject;

public class IMConnection
extends IConnection {
    private static final String TAG = "IMConnection";
    private ModuleLinker mModuleLinker;
    private boolean isConnectServ = false;
    private static final int CONNECT_FAILED_TIME_OUT = 20000;
    private static final int MSG_CONNECT_FAILED = 501;
    private static final int WAITING_TIME_OUT = 15000;
    private static final int IM_DEFAULT_PLAT = 0;
    private int mConnectState;
    private ProtocolListener mProtocolListener;
    ProtocolListener protocolListener = new ProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            if (100001 == n2) {
                if (TextUtils.equals((CharSequence)stringArray[0], (CharSequence)"successful")) {
                    IMConnection.this.isConnectServ = true;
                    IMConnection.this.wakeup();
                }
            } else if (33556479L == (long)n2) {
                IMConnection.this.connectTvResult(stringArray[0]);
            }
        }
    };

    public IMConnection(ParamsMap paramsMap, ProtocolListener protocolListener) {
        super(paramsMap);
        try {
            this.mProtocolListener = protocolListener;
            this.mModuleLinker = ModuleLinker.getInstance();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    boolean startConnect() {
        if (this.mModuleLinker == null) {
            return false;
        }
        this.isConnectServ = (Boolean)this.mModuleLinker.callMethod("F3F85A52D12C14C7E77AB545D05D65C6", new Object[0]);
        if (!this.isConnectServ) {
            this.mModuleLinker.callMethod("53F3D05946F79A5006A8E5569E344DCC", this.paramsMap);
            this.mModuleLinker.callMethod("AB500121B62061D9EA6941F4E98F1F50", 100001, this.protocolListener);
            this.mModuleLinker.callMethod("1291A75823F08964E4C79417BB7B0C7A", new Object[0]);
            this.waitState(20000L);
        }
        if (this.isConnectServ) {
            this.mModuleLinker.callMethod("AB500121B62061D9EA6941F4E98F1F50", 33556479L, this.protocolListener);
            Object object = this.mModuleLinker.callMethod("1291A75823F08964E4C79417BB7B0C7A", this.paramsMap.getParam("dev_name", ""), null, this.sessionId);
            if (object != null && object.toString().contains("200")) {
                CLog.i(TAG, "   send connect tv msg successful ");
                this.waitState(20000L);
            } else if (object != null && object.toString().contains("403")) {
                CLog.i(TAG, " receiver is offline ");
            }
        }
        if (this.mConnectState == 1) {
            CLog.i(TAG, "   wait connect ");
            this.waitState(15000L);
        }
        CLog.i(TAG, " call im result " + this.mConnectState);
        return this.mConnectState == 2;
    }

    public void connectTvResult(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            int n2 = jSONObject.optInt("st");
            int n3 = jSONObject.optInt("std");
            this.mConnectState = n2;
            this.wakeup();
            if (n2 == 2) {
                CLog.i(TAG, "im connect state allow");
                return;
            }
            if (n2 == 1) {
                CLog.i(TAG, "im connect state waiting");
            } else if (n3 == 1) {
                CLog.i(TAG, "im connect state time out");
            } else if (n3 == 3) {
                CLog.i(TAG, "im connect state black list");
            } else {
                CLog.i(TAG, "im connect state black reject");
            }
            this.mProtocolListener.onResult(4, jSONObject.toString());
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitState(long l2) {
        IMConnection iMConnection = this;
        synchronized (iMConnection) {
            try {
                this.wait(l2);
            }
            catch (InterruptedException interruptedException) {
                CLog.w(TAG, interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        IMConnection iMConnection = this;
        synchronized (iMConnection) {
            try {
                this.notifyAll();
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
    }

    @Override
    boolean checkConnection() {
        return true;
    }
}

