/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass;

import com.hpplay.sdk.source.bean.MediaAssetBean;
import com.hpplay.sdk.source.bean.MicroAppInfoBean;
import com.hpplay.sdk.source.bean.PlayerInfoBean;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.Creator;
import com.hpplay.sdk.source.pass.bean.ConnectBean;
import com.hpplay.sdk.source.pass.bean.DescribeBean;
import com.hpplay.sdk.source.pass.bean.RateQueryBean;
import com.hpplay.sdk.source.pass.bean.ShortVideoListBean;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.transceiver.bean.NotifyMirrorBean;
import com.hpplay.sdk.source.utils.CreateUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class PassSender {
    private static final String TAG = "PassSender";
    private static PassSender sInstance;

    private PassSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PassSender getInstance() {
        Class<PassSender> clazz = PassSender.class;
        synchronized (PassSender.class) {
            if (sInstance == null) {
                sInstance = new PassSender();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void sendConnectMsg(LelinkServiceInfo lelinkServiceInfo) {
        ConnectBean connectBean = new ConnectBean();
        String string = connectBean.toJson();
        this.send(lelinkServiceInfo, "", 4, 7, 2, string);
    }

    public void queryRate() {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        RateQueryBean rateQueryBean = new RateQueryBean();
        String string = rateQueryBean.toJson();
        this.send(lelinkServiceInfo, "", 15, 1, 2, string);
    }

    public void sendPass(int n2, String string, boolean bl) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        switch (n2) {
            case 100: {
                this.send(lelinkServiceInfo, "", 100, 1, bl ? 2 : 1, string);
                break;
            }
            case 10000: {
                this.send(lelinkServiceInfo, "", 10000, 1, bl ? 2 : 1, string);
                break;
            }
            default: {
                SourceLog.w(TAG, "sendPass ignore, never should be here");
            }
        }
    }

    public void sendVIPQuery(String string) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, "", 22, 1, 2, string);
    }

    public void playRate(String string) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, "", 12, 1, 2, string);
    }

    public void syncLogReport(LelinkServiceInfo lelinkServiceInfo, String string) {
        this.send(lelinkServiceInfo, "", 21, 1, 2, string);
    }

    public void sendDanmu(String string) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, "", 6, 1, 2, string);
    }

    public void setDanmuProperty(String string) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, "", 5, 1, 2, string);
    }

    public void sendMirrorState(String string, String string2) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, string2, 26, 1, 2, string);
    }

    public void sendPlayerInfo(PlayerInfoBean playerInfoBean, String string) {
        SourceLog.i(TAG, "sendPlayerInfo");
        try {
            LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
            playerInfoBean.setManifestVer(3);
            this.send(lelinkServiceInfo, string, 1, 3, 2, playerInfoBean.encode().toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void sendMicroAppInfo(MicroAppInfoBean microAppInfoBean, String string) {
        try {
            LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
            microAppInfoBean.setManifestVer(1);
            this.send(lelinkServiceInfo, string, 33, 1, 2, microAppInfoBean.encode().toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void sendMediaAssets(MediaAssetBean mediaAssetBean, String string) {
        SourceLog.i(TAG, "sendMediaAssets");
        try {
            LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
            mediaAssetBean.setManifestVer(String.valueOf(1));
            this.send(lelinkServiceInfo, string, 2, 1, 2, mediaAssetBean.encode().toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void sendSinkKeyRegister(String string, String string2) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, string2, 28, 1, 2, string);
    }

    public void sendSinkTouchEvent(String string, String string2) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, string2, 11, 1, 2, string);
    }

    public void sendShortVideoList(String string) {
        SourceLog.i(TAG, "sendShortVideoList");
        try {
            ShortVideoListBean shortVideoListBean = new ShortVideoListBean();
            shortVideoListBean.manifestVer = 1;
            shortVideoListBean.index = 0;
            shortVideoListBean.videoList = new JSONArray(string);
            LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
            this.send(lelinkServiceInfo, "", 30, 1, 2, ShortVideoListBean.toJSON(shortVideoListBean));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void sendSinkTouchRegister(String string, String string2) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        this.send(lelinkServiceInfo, string2, 31, 1, 2, string);
    }

    public void sendMicroPass(String string, String string2, int n2) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("manifestVer", 1);
            jSONObject.put("type", n2);
            jSONObject.put("appid", lelinkServiceInfo.getAppId());
            jSONObject.put("content", (Object)string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.send(lelinkServiceInfo, string2, 34, 1, 2, jSONObject.toString());
    }

    public void sendStopMicro(String string, int n2) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("manifestVer", 1);
            jSONObject.put("type", n2);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.send(lelinkServiceInfo, string, 35, 1, 2, jSONObject.toString());
    }

    public void sendTempRestrict(String string, boolean bl) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("manifestVer", 1);
            jSONObject.put("enable", bl);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.send(lelinkServiceInfo, string, 36, 1, 2, jSONObject.toString());
    }

    public void sendNotifyMirrorMsg(NotifyMirrorBean notifyMirrorBean) {
        if (notifyMirrorBean == null) {
            SourceLog.w(TAG, "sendNotifyMirrorMsg ignore 1");
            return;
        }
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLelinkServiceInfo(notifyMirrorBean.uid);
        if (lelinkServiceInfo == null) {
            SourceLog.w(TAG, "sendNotifyMirrorMsg ignore 2");
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("manifestVer", 1);
            jSONObject.put("ip", (Object)notifyMirrorBean.ip);
            jSONObject.put("port", notifyMirrorBean.port);
            jSONObject.put("name", (Object)notifyMirrorBean.name);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.send(lelinkServiceInfo, "", 38, 1, 2, jSONObject.toString());
    }

    public void sendNotifyRemoteMsg(String string, int n2, int n3) {
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLelinkServiceInfo(string);
        if (lelinkServiceInfo == null) {
            SourceLog.w(TAG, "sendNotifyMirrorMsg ignore 2");
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("manifestVer", 1);
            jSONObject.put("type", n2);
            jSONObject.put("action", n3);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.send(lelinkServiceInfo, "", 39, 1, 2, jSONObject.toString());
    }

    private void send(LelinkServiceInfo lelinkServiceInfo, String string, int n2, int n3, int n4, String string2) {
        if (lelinkServiceInfo == null) {
            SourceLog.w(TAG, "send ignore");
            return;
        }
        DescribeBean describeBean = Creator.getDescribeBean(string, n2, n3, n4);
        describeBean.id = CreateUtil.createPassMsgID();
        String string3 = describeBean.toJson();
        SourceLog.i(TAG, "send header " + string3);
        ConnectManager.getInstance().sendPassData(lelinkServiceInfo, n2, string3, string2);
    }
}

