/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.EDNSOption;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.base16;

public class GenericEDNSOption
extends EDNSOption {
    private byte[] data;

    GenericEDNSOption(int n2) {
        super(n2);
    }

    public GenericEDNSOption(int n2, byte[] byArray) {
        super(n2);
        this.data = Record.checkByteArrayLength("option data", byArray, 65535);
    }

    @Override
    void optionFromWire(DNSInput dNSInput) {
        this.data = dNSInput.readByteArray();
    }

    @Override
    void optionToWire(DNSOutput dNSOutput) {
        dNSOutput.writeByteArray(this.data);
    }

    @Override
    String optionToString() {
        return "<" + base16.toString(this.data) + ">";
    }
}

