/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.exscreen;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Presentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.Display;
import com.hpplay.sdk.source.log.SourceLog;

@TargetApi(value=17)
public class ExternalScreen
extends Presentation {
    private static final String TAG = "ExternalScreen";
    private IExternalScreenLifecycleListener mExternalScreenLifecycleListener;
    public Activity mActivity;

    public ExternalScreen(Context context, Display display) {
        super(context, display);
        this.mActivity = (Activity)context;
    }

    public ExternalScreen(Context context, Display display, int n2) {
        super(context, display, n2);
        this.mActivity = (Activity)context;
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
    }

    public void setExternalScreenLifecycleListener(IExternalScreenLifecycleListener iExternalScreenLifecycleListener) {
        this.mExternalScreenLifecycleListener = iExternalScreenLifecycleListener;
    }

    public void onDisplayRemoved() {
        super.onDisplayRemoved();
        this.mActivity = null;
        SourceLog.i(TAG, "------- onDisplayRemoved ---- ");
    }

    public void onResume() {
        if (!(this.isShowing() || this.mActivity == null || this.mActivity.isFinishing() || this.mActivity.isDestroyed())) {
            this.show();
        }
        if (Build.VERSION.SDK_INT < 26 && this.mExternalScreenLifecycleListener != null) {
            this.mExternalScreenLifecycleListener.onResume();
        }
    }

    public void onStop() {
        if (Build.VERSION.SDK_INT < 26) {
            if (this.mExternalScreenLifecycleListener != null) {
                this.mExternalScreenLifecycleListener.onStop();
            }
            if (this.isShowing()) {
                this.dismiss();
            }
        }
    }

    public void onDestroy() {
        if (this.isShowing()) {
            this.dismiss();
        }
        if (this.mExternalScreenLifecycleListener != null) {
            this.mExternalScreenLifecycleListener.onDestroy();
        }
    }

    public static interface IExternalScreenLifecycleListener {
        public void onResume();

        public void onStop();

        public void onDestroy();
    }
}

