/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<T, Y> {
    private final LinkedHashMap<T, Y> cache = new LinkedHashMap(100, 0.75f, true);
    private int maxSize;
    private final int initialMaxSize;
    private int currentSize = 0;

    public LruCache(int n2) {
        this.initialMaxSize = n2;
        this.maxSize = n2;
    }

    public void setSizeMultiplier(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Multiplier must be >= 0");
        }
        this.maxSize = Math.round((float)this.initialMaxSize * f2);
        this.evict();
    }

    protected int getSize(Y y) {
        return 1;
    }

    protected void onItemEvicted(T t2, Y y) {
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public boolean contains(T t2) {
        return this.cache.containsKey(t2);
    }

    public Y get(T t2) {
        return this.cache.get(t2);
    }

    public Y put(T t2, Y y) {
        int n2 = this.getSize(y);
        if (n2 >= this.maxSize) {
            this.onItemEvicted(t2, y);
            return null;
        }
        Y y2 = this.cache.put(t2, y);
        if (y != null) {
            this.currentSize += this.getSize(y);
        }
        if (y2 != null) {
            this.currentSize -= this.getSize(y2);
        }
        this.evict();
        return y2;
    }

    public Y remove(T t2) {
        Object v2 = this.cache.remove(t2);
        if (v2 != null) {
            this.currentSize -= this.getSize(v2);
        }
        return (Y)v2;
    }

    public void clearMemory() {
        this.trimToSize(0);
    }

    protected void trimToSize(int n2) {
        while (this.currentSize > n2) {
            Map.Entry<T, Y> entry = this.cache.entrySet().iterator().next();
            Y y = entry.getValue();
            this.currentSize -= this.getSize(y);
            T t2 = entry.getKey();
            this.cache.remove(t2);
            this.onItemEvicted(t2, y);
        }
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }
}

