/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6;

import com.hpplay.component.protocol.srp6.SRP6ClientEvidenceContext;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import com.hpplay.component.protocol.srp6.SRP6Exception;
import com.hpplay.component.protocol.srp6.SRP6ServerEvidenceContext;
import com.hpplay.component.protocol.srp6.SRP6Session;
import com.hpplay.component.protocol.srp6.URoutineContext;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;

public class SRP6ServerSession
extends SRP6Session
implements Serializable {
    private static final long serialVersionUID = -4076520488632450473L;
    private boolean noSuchUserIdentity = false;
    private BigInteger v = null;
    private BigInteger b = null;
    private State state;

    public SRP6ServerSession(SRP6CryptoParams sRP6CryptoParams, int n2) {
        super(n2);
        if (sRP6CryptoParams == null) {
            throw new IllegalArgumentException("The SRP-6a crypto parameters must not be null");
        }
        this.config = sRP6CryptoParams;
        if (sRP6CryptoParams.getMessageDigestInstance() == null) {
            throw new IllegalArgumentException("Unsupported hash algorithm 'H': " + sRP6CryptoParams.H);
        }
        this.state = State.INIT;
        this.updateLastActivityTime();
    }

    public SRP6ServerSession(SRP6CryptoParams sRP6CryptoParams) {
        this(sRP6CryptoParams, 0);
    }

    public BigInteger step1(String string, BigInteger bigInteger, BigInteger bigInteger2) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("The user identity 'I' must not be null or empty");
        }
        this.userID = string;
        if (bigInteger == null) {
            throw new IllegalArgumentException("The salt 's' must not be null");
        }
        this.s = bigInteger;
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("The verifier 'v' must not be null");
        }
        this.v = bigInteger2;
        if (this.state != State.INIT) {
            throw new IllegalStateException("State violation: Session must be in INIT state");
        }
        MessageDigest messageDigest = this.config.getMessageDigestInstance();
        this.k = this.srp6Routines.computeK(messageDigest, this.config.N, this.config.g);
        messageDigest.reset();
        this.b = this.srp6Routines.generatePrivateValue(this.config.N, this.random);
        messageDigest.reset();
        this.B = this.srp6Routines.computePublicServerValue(this.config.N, this.config.g, this.k, bigInteger2, this.b);
        this.state = State.STEP_1;
        this.updateLastActivityTime();
        return this.B;
    }

    public BigInteger mockStep1(String string, BigInteger bigInteger, BigInteger bigInteger2) {
        this.noSuchUserIdentity = true;
        return this.step1(string, bigInteger, bigInteger2);
    }

    public BigInteger step2(BigInteger bigInteger, BigInteger bigInteger2) {
        Object object;
        Object object2;
        if (bigInteger == null) {
            throw new IllegalArgumentException("The client public value 'A' must not be null");
        }
        this.A = bigInteger;
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("The client evidence message 'M1' must not be null");
        }
        this.M1 = bigInteger2;
        if (this.state != State.STEP_1) {
            throw new IllegalStateException("State violation: Session must be in STEP_1 state");
        }
        if (this.hasTimedOut()) {
            throw new SRP6Exception("Session timeout", SRP6Exception.CauseType.TIMEOUT);
        }
        if (!this.srp6Routines.isValidPublicValue(this.config.N, bigInteger)) {
            throw new SRP6Exception("Bad client public value 'A'", SRP6Exception.CauseType.BAD_PUBLIC_VALUE);
        }
        MessageDigest messageDigest = this.config.getMessageDigestInstance();
        if (this.hashedKeysRoutine != null) {
            object2 = new URoutineContext(bigInteger, this.B);
            this.u = this.hashedKeysRoutine.computeU(this.config, (URoutineContext)object2);
        } else {
            this.u = this.srp6Routines.computeU(messageDigest, this.config.N, bigInteger, this.B);
            messageDigest.reset();
        }
        this.S = this.srp6Routines.computeSessionKey(this.config.N, this.v, this.u, bigInteger, this.b);
        if (this.clientEvidenceRoutine != null) {
            object = new SRP6ClientEvidenceContext(this.userID, this.s, bigInteger, this.B, this.S);
            object2 = this.clientEvidenceRoutine.computeClientEvidence(this.config, (SRP6ClientEvidenceContext)object);
        } else {
            object2 = this.srp6Routines.computeClientEvidence(messageDigest, bigInteger, this.B, this.S);
            messageDigest.reset();
        }
        if (this.noSuchUserIdentity || !((BigInteger)object2).equals(bigInteger2)) {
            throw new SRP6Exception("Bad client credentials", SRP6Exception.CauseType.BAD_CREDENTIALS);
        }
        this.state = State.STEP_2;
        if (this.serverEvidenceRoutine != null) {
            object = new SRP6ServerEvidenceContext(bigInteger, bigInteger2, this.S);
            this.M2 = this.serverEvidenceRoutine.computeServerEvidence(this.config, (SRP6ServerEvidenceContext)object);
        } else {
            this.M2 = this.srp6Routines.computeServerEvidence(messageDigest, bigInteger, bigInteger2, this.S);
            messageDigest.reset();
        }
        this.updateLastActivityTime();
        return this.M2;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INIT,
        STEP_1,
        STEP_2;

    }
}

