/*
 * Decompiled with CFR 0.152.
 */
package com.macroyau.blue2serial;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.macroyau.blue2serial.BluetoothDeviceListItemAdapter;
import com.macroyau.blue2serial.BluetoothSerial;
import java.util.Set;

public class BluetoothDeviceListDialog {
    private Context mContext;
    private OnDeviceSelectedListener mListener;
    private Set<BluetoothDevice> mDevices;
    private String[] mNames;
    private String[] mAddresses;
    private String mTitle;
    private boolean mShowAddress = true;
    private boolean mUseDarkTheme = true;

    public BluetoothDeviceListDialog(Context context) {
        this.mContext = context;
    }

    public void setOnDeviceSelectedListener(OnDeviceSelectedListener listener) {
        this.mListener = listener;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setTitle(int resId) {
        this.mTitle = this.mContext.getString(resId);
    }

    public void setDevices(Set<BluetoothDevice> devices) {
        this.mDevices = devices;
        if (devices != null) {
            this.mNames = new String[devices.size()];
            this.mAddresses = new String[devices.size()];
            int i = 0;
            for (BluetoothDevice d : devices) {
                this.mNames[i] = d.getName();
                this.mAddresses[i] = d.getAddress();
                ++i;
            }
        }
    }

    public void showAddress(boolean showAddress) {
        this.mShowAddress = showAddress;
    }

    @Deprecated
    public void useDarkTheme(boolean useDarkTheme) {
        this.mUseDarkTheme = useDarkTheme;
    }

    public void show() {
        final AlertDialog dialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)this.mTitle).setAdapter((ListAdapter)new BluetoothDeviceListItemAdapter(this.mContext, this.mNames, this.mAddresses, this.mShowAddress), null).create();
        ListView listView = dialog.getListView();
        if (listView != null) {
            listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                    BluetoothDeviceListDialog.this.mListener.onBluetoothDeviceSelected(BluetoothSerial.getAdapter(BluetoothDeviceListDialog.this.mContext).getRemoteDevice(BluetoothDeviceListDialog.this.mAddresses[position]));
                    dialog.cancel();
                }
            });
        }
        dialog.show();
    }

    public static interface OnDeviceSelectedListener {
        public void onBluetoothDeviceSelected(BluetoothDevice var1);
    }
}

