/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.bitmap_recycle;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.hpplay.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.hpplay.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.hpplay.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.hpplay.glide.load.engine.bitmap_recycle.Poolable;
import com.hpplay.glide.load.engine.bitmap_recycle.PrettyPrintTreeMap;
import com.hpplay.glide.util.Util;
import java.util.TreeMap;

@TargetApi(value=19)
class SizeStrategy
implements LruPoolStrategy {
    private static final int MAX_SIZE_MULTIPLE = 8;
    private final KeyPool keyPool = new KeyPool();
    private final GroupedLinkedMap<Key, Bitmap> groupedMap = new GroupedLinkedMap();
    private final TreeMap<Integer, Integer> sortedSizes = new PrettyPrintTreeMap<Integer, Integer>();

    SizeStrategy() {
    }

    @Override
    public void put(Bitmap bitmap) {
        int n2 = Util.getBitmapByteSize(bitmap);
        Key key = this.keyPool.get(n2);
        this.groupedMap.put(key, bitmap);
        Integer n3 = this.sortedSizes.get(key.size);
        this.sortedSizes.put(key.size, n3 == null ? 1 : n3 + 1);
    }

    @Override
    public Bitmap get(int n2, int n3, Bitmap.Config config) {
        Bitmap bitmap;
        int n4 = Util.getBitmapByteSize(n2, n3, config);
        Key key = this.keyPool.get(n4);
        Integer n5 = this.sortedSizes.ceilingKey(n4);
        if (n5 != null && n5 != n4 && n5 <= n4 * 8) {
            this.keyPool.offer(key);
            key = this.keyPool.get(n5);
        }
        if ((bitmap = this.groupedMap.get(key)) != null) {
            bitmap.reconfigure(n2, n3, config);
            this.decrementBitmapOfSize(n5);
        }
        return bitmap;
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap = this.groupedMap.removeLast();
        if (bitmap != null) {
            int n2 = Util.getBitmapByteSize(bitmap);
            this.decrementBitmapOfSize(n2);
        }
        return bitmap;
    }

    private void decrementBitmapOfSize(Integer n2) {
        Integer n3 = this.sortedSizes.get(n2);
        if (n3 == 1) {
            this.sortedSizes.remove(n2);
        } else {
            this.sortedSizes.put(n2, n3 - 1);
        }
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        return SizeStrategy.getBitmapString(bitmap);
    }

    @Override
    public String logBitmap(int n2, int n3, Bitmap.Config config) {
        int n4 = Util.getBitmapByteSize(n2, n3, config);
        return SizeStrategy.getBitmapString(n4);
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    public String toString() {
        return "SizeStrategy:\n  " + this.groupedMap + "\n  SortedSizes" + this.sortedSizes;
    }

    private static String getBitmapString(Bitmap bitmap) {
        int n2 = Util.getBitmapByteSize(bitmap);
        return SizeStrategy.getBitmapString(n2);
    }

    private static String getBitmapString(int n2) {
        return "[" + n2 + "]";
    }

    static final class Key
    implements Poolable {
        private final KeyPool pool;
        private int size;

        Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        public void init(int n2) {
            this.size = n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.size == key.size;
            }
            return false;
        }

        public int hashCode() {
            return this.size;
        }

        public String toString() {
            return SizeStrategy.getBitmapString(this.size);
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        public Key get(int n2) {
            Key key = (Key)this.get();
            key.init(n2);
            return key;
        }

        @Override
        protected Key create() {
            return new Key(this);
        }
    }
}

