/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSObject;
import com.hpplay.component.protocol.plist.NSSet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BinaryPropertyListWriter {
    private static final int VERSION_00 = 0;
    private static final int VERSION_10 = 10;
    private static final int VERSION_15 = 15;
    private static final int VERSION_20 = 20;
    private int version = 0;
    private final OutputStream out;
    private long count;
    private final Map<NSObject, Integer> idMap = new LinkedHashMap<NSObject, Integer>();
    private int idSizeInBytes;

    BinaryPropertyListWriter(OutputStream outputStream) {
        this.out = new BufferedOutputStream(outputStream);
    }

    BinaryPropertyListWriter(OutputStream outputStream, int n2) {
        this.version = n2;
        this.out = new BufferedOutputStream(outputStream);
    }

    private static int getMinimumRequiredVersion(NSObject nSObject) {
        int n2;
        block5: {
            block6: {
                block4: {
                    n2 = 0;
                    if (nSObject == null) {
                        n2 = 10;
                    }
                    if (!(nSObject instanceof NSDictionary)) break block4;
                    NSDictionary nSDictionary = (NSDictionary)nSObject;
                    for (NSObject nSObject2 : nSDictionary.getHashMap().values()) {
                        int n3 = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject2);
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                    break block5;
                }
                if (!(nSObject instanceof NSArray)) break block6;
                NSArray nSArray = (NSArray)nSObject;
                for (NSObject nSObject3 : nSArray.getArray()) {
                    int n4 = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject3);
                    if (n4 <= n2) continue;
                    n2 = n4;
                }
                break block5;
            }
            if (!(nSObject instanceof NSSet)) break block5;
            n2 = 10;
            NSSet nSSet = (NSSet)nSObject;
            for (NSObject nSObject4 : nSSet.allObjects()) {
                int n5 = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject4);
                if (n5 <= n2) continue;
                n2 = n5;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, NSObject nSObject) {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            BinaryPropertyListWriter.write(fileOutputStream, nSObject);
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(OutputStream outputStream, NSObject nSObject) {
        int n2 = BinaryPropertyListWriter.getMinimumRequiredVersion(nSObject);
        if (n2 > 0) {
            String string = n2 == 10 ? "v1.0" : (n2 == 15 ? "v1.5" : (n2 == 20 ? "v2.0" : "v0.0"));
            throw new IOException("The given property list structure cannot be saved. The required version of the binary format (" + string + ") is not yet supported.");
        }
        BinaryPropertyListWriter binaryPropertyListWriter = new BinaryPropertyListWriter(outputStream, n2);
        binaryPropertyListWriter.write(nSObject);
    }

    public static byte[] writeToArray(NSObject nSObject) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryPropertyListWriter.write(byteArrayOutputStream, nSObject);
        return byteArrayOutputStream.toByteArray();
    }

    void write(NSObject nSObject) {
        this.write(new byte[]{98, 112, 108, 105, 115, 116});
        switch (this.version) {
            case 0: {
                this.write(new byte[]{48, 48});
                break;
            }
            case 10: {
                this.write(new byte[]{49, 48});
                break;
            }
            case 15: {
                this.write(new byte[]{49, 53});
                break;
            }
            case 20: {
                this.write(new byte[]{50, 48});
                break;
            }
        }
        nSObject.assignIDs(this);
        this.idSizeInBytes = BinaryPropertyListWriter.computeIdSizeInBytes(this.idMap.size());
        long[] lArray = new long[this.idMap.size()];
        for (Map.Entry<NSObject, Integer> entry : this.idMap.entrySet()) {
            NSObject nSObject2 = entry.getKey();
            int n2 = entry.getValue();
            lArray[n2] = this.count;
            if (nSObject2 == null) {
                this.write(0);
                continue;
            }
            nSObject2.toBinary(this);
        }
        long l2 = this.count;
        int n3 = this.computeOffsetSizeInBytes(this.count);
        for (long l3 : lArray) {
            this.writeBytes(l3, n3);
        }
        if (this.version != 15) {
            this.write(new byte[6]);
            this.write(n3);
            this.write(this.idSizeInBytes);
            this.writeLong(this.idMap.size());
            this.writeLong(this.idMap.get(nSObject).intValue());
            this.writeLong(l2);
        }
        this.out.flush();
    }

    void assignID(NSObject nSObject) {
        if (!this.idMap.containsKey(nSObject)) {
            this.idMap.put(nSObject, this.idMap.size());
        }
    }

    int getID(NSObject nSObject) {
        return this.idMap.get(nSObject);
    }

    private static int computeIdSizeInBytes(int n2) {
        if (n2 < 256) {
            return 1;
        }
        if (n2 < 65536) {
            return 2;
        }
        return 4;
    }

    private int computeOffsetSizeInBytes(long l2) {
        if (l2 < 256L) {
            return 1;
        }
        if (l2 < 65536L) {
            return 2;
        }
        if (l2 < 0x100000000L) {
            return 4;
        }
        return 8;
    }

    void writeIntHeader(int n2, int n3) {
        assert (n3 >= 0);
        if (n3 < 15) {
            this.write((n2 << 4) + n3);
        } else if (n3 < 256) {
            this.write((n2 << 4) + 15);
            this.write(16);
            this.writeBytes(n3, 1);
        } else if (n3 < 65536) {
            this.write((n2 << 4) + 15);
            this.write(17);
            this.writeBytes(n3, 2);
        } else {
            this.write((n2 << 4) + 15);
            this.write(18);
            this.writeBytes(n3, 4);
        }
    }

    void write(int n2) {
        this.out.write(n2);
        ++this.count;
    }

    void write(byte[] byArray) {
        this.out.write(byArray);
        this.count += (long)byArray.length;
    }

    void writeBytes(long l2, int n2) {
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.write((int)(l2 >> 8 * i2));
        }
    }

    void writeID(int n2) {
        this.writeBytes(n2, this.idSizeInBytes);
    }

    void writeLong(long l2) {
        this.writeBytes(l2, 8);
    }

    void writeDouble(double d2) {
        this.writeLong(Double.doubleToRawLongBits(d2));
    }
}

