/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Format
implements Parcelable,
Cloneable {
    public int index;
    public int type;
    public List<Descriptor> frameDescriptors;
    public static final Parcelable.Creator<Format> CREATOR = new Parcelable.Creator<Format>(){

        public Format createFromParcel(Parcel in) {
            return new Format(in);
        }

        public Format[] newArray(int size) {
            return new Format[size];
        }
    };

    public Format(int index, int type, List<Descriptor> frameDescriptors) {
        this.index = index;
        this.type = type;
        this.frameDescriptors = frameDescriptors;
    }

    protected Format(Parcel in) {
        this.index = in.readInt();
        this.type = in.readInt();
        this.frameDescriptors = in.createTypedArrayList(Descriptor.CREATOR);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.index);
        dest.writeInt(this.type);
        dest.writeTypedList(this.frameDescriptors);
    }

    public Format clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (format == null) {
            format = new Format(this.index, this.type, new ArrayList<Descriptor>());
        }
        ArrayList<Descriptor> descriptorList = new ArrayList<Descriptor>();
        if (this.frameDescriptors != null) {
            for (Descriptor descriptor : this.frameDescriptors) {
                descriptorList.add(descriptor.clone());
            }
        }
        format.frameDescriptors = descriptorList;
        return format;
    }

    public static class Descriptor
    implements Parcelable,
    Cloneable {
        public int index;
        public int type;
        public int width;
        public int height;
        public int fps;
        public int frameInterval;
        public List<Interval> intervals;
        public static final Parcelable.Creator<Descriptor> CREATOR = new Parcelable.Creator<Descriptor>(){

            public Descriptor createFromParcel(Parcel in) {
                return new Descriptor(in);
            }

            public Descriptor[] newArray(int size) {
                return new Descriptor[size];
            }
        };

        public Descriptor(int _index, int _type, int _width, int _height, int _fps, int _frameInterval, List<Interval> _intervals) {
            this.index = _index;
            this.type = _type;
            this.width = _width;
            this.height = _height;
            this.fps = _fps;
            this.frameInterval = _frameInterval;
            this.intervals = _intervals;
        }

        protected Descriptor(Parcel in) {
            this.index = in.readInt();
            this.type = in.readInt();
            this.width = in.readInt();
            this.height = in.readInt();
            this.fps = in.readInt();
            this.frameInterval = in.readInt();
            this.intervals = in.createTypedArrayList(Interval.CREATOR);
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.index);
            dest.writeInt(this.type);
            dest.writeInt(this.width);
            dest.writeInt(this.height);
            dest.writeInt(this.fps);
            dest.writeInt(this.frameInterval);
            dest.writeTypedList(this.intervals);
        }

        public int describeContents() {
            return 0;
        }

        public String toString() {
            return String.format(Locale.US, "Size(%dx%d@%d,type:%d,index:%d)", this.width, this.height, this.fps, this.type, this.index);
        }

        @NonNull
        public Descriptor clone() {
            Descriptor descriptor = null;
            try {
                descriptor = (Descriptor)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            if (descriptor == null) {
                descriptor = new Descriptor(this.index, this.type, this.width, this.height, this.fps, this.frameInterval, new ArrayList<Interval>());
            }
            ArrayList<Interval> intervalList = new ArrayList<Interval>();
            if (this.intervals != null) {
                for (Interval interval : this.intervals) {
                    intervalList.add(interval.clone());
                }
            }
            descriptor.intervals = intervalList;
            return descriptor;
        }
    }

    public static class Interval
    implements Parcelable,
    Cloneable {
        public int index;
        public int value;
        public int fps;
        public static final Parcelable.Creator<Interval> CREATOR = new Parcelable.Creator<Interval>(){

            public Interval createFromParcel(Parcel in) {
                return new Interval(in);
            }

            public Interval[] newArray(int size) {
                return new Interval[size];
            }
        };

        public Interval(int index, int value, int fps) {
            this.index = index;
            this.value = value;
            this.fps = fps;
        }

        protected Interval(Parcel in) {
            this.index = in.readInt();
            this.value = in.readInt();
            this.fps = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.index);
            dest.writeInt(this.value);
            dest.writeInt(this.fps);
        }

        public int describeContents() {
            return 0;
        }

        public Interval clone() {
            Interval interval = null;
            try {
                interval = (Interval)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            if (interval == null) {
                interval = new Interval(this.index, this.value, this.fps);
            }
            return interval;
        }
    }
}

