/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.http.HTTPResponse;
import com.hpplay.cybergarage.upnp.Action;
import com.hpplay.cybergarage.upnp.ActionList;
import com.hpplay.cybergarage.upnp.Argument;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.ServiceStateTable;
import com.hpplay.cybergarage.upnp.StateVariable;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.upnp.control.ActionListener;
import com.hpplay.cybergarage.upnp.control.QueryListener;
import com.hpplay.cybergarage.upnp.device.InvalidDescriptionException;
import com.hpplay.cybergarage.upnp.device.ST;
import com.hpplay.cybergarage.upnp.event.NotifyRequest;
import com.hpplay.cybergarage.upnp.event.Subscriber;
import com.hpplay.cybergarage.upnp.event.SubscriberList;
import com.hpplay.cybergarage.upnp.ssdp.SSDPNotifyRequest;
import com.hpplay.cybergarage.upnp.ssdp.SSDPNotifySocket;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import com.hpplay.cybergarage.upnp.xml.ServiceData;
import com.hpplay.cybergarage.util.Mutex;
import com.hpplay.cybergarage.util.StringUtil;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.Parser;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class Service {
    private static final String TAG = "Cyber-Service";
    public static final String ELEM_NAME = "service";
    private Node serviceNode;
    public static final String SCPD_ROOTNODE = "scpd";
    public static final String SCPD_ROOTNODE_NS = "urn:schemas-upnp-org:service-1-0";
    public static final String SPEC_VERSION = "specVersion";
    public static final String MAJOR = "major";
    public static final String MAJOR_VALUE = "1";
    public static final String MINOR = "minor";
    public static final String MINOR_VALUE = "0";
    private Mutex mutex = new Mutex();
    private static final String SERVICE_TYPE = "serviceType";
    private static final String SERVICE_ID = "serviceId";
    private static final String CONFIG_ID = "configId";
    private static final String SCPDURL = "SCPDURL";
    private static final String CONTROL_URL = "controlURL";
    private static final String EVENT_SUB_URL = "eventSubURL";
    private String mErrorMsg = "";
    private Object userData = null;

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public Service() {
        this(new Node(ELEM_NAME));
        Node node = new Node(SPEC_VERSION);
        Node node2 = new Node(MAJOR);
        node2.setValue(MAJOR_VALUE);
        node.addNode(node2);
        Node node3 = new Node(MINOR);
        node3.setValue(MINOR_VALUE);
        node.addNode(node3);
        Node node4 = new Node(SCPD_ROOTNODE);
        node4.addAttribute("xmlns", SCPD_ROOTNODE_NS);
        node4.addNode(node);
        this.getServiceData().setSCPDNode(node4);
    }

    public Service(Node node) {
        this.serviceNode = node;
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public static boolean isServiceNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    private Node getDeviceNode() {
        Node node = this.getServiceNode().getParentNode();
        if (node == null) {
            return null;
        }
        return node.getParentNode();
    }

    private Node getRootNode() {
        return this.getServiceNode().getRootNode();
    }

    public Device getDevice() {
        return new Device(this.getRootNode(), this.getDeviceNode());
    }

    public Device getRootDevice() {
        return this.getDevice().getRootDevice();
    }

    public void setServiceType(String string) {
        this.getServiceNode().setNode(SERVICE_TYPE, string);
    }

    public String getServiceType() {
        return this.getServiceNode().getNodeValue(SERVICE_TYPE);
    }

    public void setServiceID(String string) {
        this.getServiceNode().setNode(SERVICE_ID, string);
    }

    public String getServiceID() {
        return this.getServiceNode().getNodeValue(SERVICE_ID);
    }

    public void updateConfigId() {
        Node node = this.getSCPDNode();
        if (node == null) {
            return;
        }
        String string = node.toString();
        int n2 = UPnP.caluculateConfigId(string);
        node.setAttribute(CONFIG_ID, n2);
    }

    public int getConfigId() {
        Node node = this.getSCPDNode();
        if (node == null) {
            return 0;
        }
        return node.getAttributeIntegerValue(CONFIG_ID);
    }

    private boolean isURL(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = string2.equals(string);
        if (bl) {
            return true;
        }
        String string3 = HTTP.toRelativeURL(string, false);
        bl = string2.equals(string3);
        return bl;
    }

    public void setSCPDURL(String string) {
        this.getServiceNode().setNode(SCPDURL, string);
    }

    public String getSCPDURL() {
        return this.getServiceNode().getNodeValue(SCPDURL);
    }

    public boolean isSCPDURL(String string) {
        return this.isURL(this.getSCPDURL(), string);
    }

    public void setControlURL(String string) {
        this.getServiceNode().setNode(CONTROL_URL, string);
    }

    public String getControlURL() {
        return this.getServiceNode().getNodeValue(CONTROL_URL);
    }

    public boolean isControlURL(String string) {
        return this.isURL(this.getControlURL(), string);
    }

    public void setEventSubURL(String string) {
        this.getServiceNode().setNode(EVENT_SUB_URL, string);
    }

    public String getEventSubURL() {
        return this.getServiceNode().getNodeValue(EVENT_SUB_URL);
    }

    public boolean isEventSubURL(String string) {
        return this.isURL(this.getEventSubURL(), string);
    }

    public boolean loadSCPD(String string) {
        try {
            Parser parser = UPnP.getXMLParser();
            Node node = parser.parse(string);
            if (node == null) {
                return false;
            }
            ServiceData serviceData = this.getServiceData();
            serviceData.setSCPDNode(node);
        }
        catch (Exception exception) {
            throw new InvalidDescriptionException(exception);
        }
        return true;
    }

    public boolean loadSCPD(File file) {
        Parser parser = UPnP.getXMLParser();
        Node node = parser.parse(file);
        if (node == null) {
            return false;
        }
        ServiceData serviceData = this.getServiceData();
        serviceData.setSCPDNode(node);
        return true;
    }

    public boolean loadSCPD(InputStream inputStream) {
        Parser parser = UPnP.getXMLParser();
        Node node = parser.parse(inputStream);
        if (node == null) {
            return false;
        }
        ServiceData serviceData = this.getServiceData();
        serviceData.setSCPDNode(node);
        return true;
    }

    public void setDescriptionURL(String string) {
        this.getServiceData().setDescriptionURL(string);
    }

    public String getDescriptionURL() {
        return this.getServiceData().getDescriptionURL();
    }

    private Node getSCPDNode(URL uRL) {
        Parser parser = UPnP.getXMLParser();
        return parser.parse(uRL.toString(), 10000);
    }

    private Node getSCPDNode(File file) {
        Parser parser = UPnP.getXMLParser();
        return parser.parse(file);
    }

    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    private Node getSCPDNode() {
        Object object;
        String string;
        ServiceData serviceData = this.getServiceData();
        Node node = serviceData.getSCPDNode();
        if (node != null) {
            return node;
        }
        Device device = this.getRootDevice();
        if (device == null) {
            this.mErrorMsg = "root dev is null";
            return null;
        }
        this.mErrorMsg = string = this.getSCPDURL();
        String string2 = device.getDescriptionFilePath();
        if (string2 != null && ((File)(object = new File(string2.concat(string)))).exists()) {
            try {
                node = this.getSCPDNode((File)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (node != null) {
                serviceData.setSCPDNode(node);
                return node;
            }
        }
        try {
            object = new URL(device.getAbsoluteURL(string));
            node = this.getSCPDNode((URL)object);
            if (node != null) {
                serviceData.setSCPDNode(node);
                return node;
            }
            this.mErrorMsg = this.mErrorMsg + "get not failed";
        }
        catch (Exception exception) {
            this.mErrorMsg = this.mErrorMsg + " getService failed " + exception.toString();
        }
        object = device.getDescriptionFilePath() + HTTP.toRelativeURL(string);
        try {
            node = this.getSCPDNode(new File((String)object));
            return node;
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return null;
        }
    }

    public byte[] getSCPDData() {
        Node node = this.getSCPDNode();
        if (node == null) {
            return new byte[0];
        }
        String string = new String();
        string = string + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string = string + "\n";
        string = string + node.toString();
        return string.getBytes();
    }

    public ActionList getActionList() {
        ActionList actionList = new ActionList();
        Node node = this.getSCPDNode();
        if (node == null) {
            return actionList;
        }
        Node node2 = node.getNode("actionList");
        if (node2 == null) {
            return actionList;
        }
        int n2 = node2.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node3 = node2.getNode(i2);
            if (!Action.isActionNode(node3)) continue;
            Action action = new Action(this.serviceNode, node3);
            actionList.add(action);
        }
        return actionList;
    }

    public Action getAction(String string) {
        ActionList actionList = this.getActionList();
        int n2 = actionList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Action action = actionList.getAction(i2);
            String string2 = action.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return action;
        }
        return null;
    }

    public void addAction(Action action) {
        Object object2;
        for (Object object2 : action.getArgumentList()) {
            ((Argument)object2).setService(this);
        }
        object2 = this.getSCPDNode();
        Node node = ((Node)object2).getNode("actionList");
        if (node == null) {
            node = new Node("actionList");
            ((Node)object2).addNode(node);
        }
        if (node == null) {
            node.addNode(action.getActionNode());
        }
    }

    public ServiceStateTable getServiceStateTable() {
        ServiceStateTable serviceStateTable = new ServiceStateTable();
        Node node = this.getSCPDNode();
        if (node == null) {
            return serviceStateTable;
        }
        Node node2 = node.getNode("serviceStateTable");
        if (node2 == null) {
            return serviceStateTable;
        }
        Node node3 = this.getServiceNode();
        int n2 = node2.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node4 = node2.getNode(i2);
            if (!StateVariable.isStateVariableNode(node4)) continue;
            StateVariable stateVariable = new StateVariable(node3, node4);
            serviceStateTable.add(stateVariable);
        }
        return serviceStateTable;
    }

    public StateVariable getStateVariable(String string) {
        ServiceStateTable serviceStateTable = this.getServiceStateTable();
        int n2 = serviceStateTable.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            StateVariable stateVariable = serviceStateTable.getStateVariable(i2);
            String string2 = stateVariable.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return stateVariable;
        }
        return null;
    }

    public boolean hasStateVariable(String string) {
        return this.getStateVariable(string) != null;
    }

    public boolean isService(String string) {
        if (string == null) {
            return false;
        }
        if (string.endsWith(this.getServiceType())) {
            return true;
        }
        return string.endsWith(this.getServiceID());
    }

    private ServiceData getServiceData() {
        Node node = this.getServiceNode();
        ServiceData serviceData = (ServiceData)node.getUserData();
        if (serviceData == null) {
            serviceData = new ServiceData();
            node.setUserData(serviceData);
            serviceData.setNode(node);
        }
        return serviceData;
    }

    private String getNotifyServiceTypeNT() {
        return this.getServiceType();
    }

    private String getNotifyServiceTypeUSN() {
        return this.getDevice().getUDN() + "::" + this.getServiceType();
    }

    public void announce(String string) {
        Device device = this.getRootDevice();
        String string2 = device.getLocationURL(string);
        String string3 = this.getNotifyServiceTypeNT();
        String string4 = this.getNotifyServiceTypeUSN();
        Device device2 = this.getDevice();
        SSDPNotifyRequest sSDPNotifyRequest = new SSDPNotifyRequest();
        sSDPNotifyRequest.setServer(UPnP.getServerName());
        sSDPNotifyRequest.setLeaseTime(device2.getLeaseTime());
        sSDPNotifyRequest.setLocation(string2);
        sSDPNotifyRequest.setNTS("ssdp:alive");
        sSDPNotifyRequest.setNT(string3);
        sSDPNotifyRequest.setUSN(string4);
        SSDPNotifySocket sSDPNotifySocket = new SSDPNotifySocket(string);
        Device.notifyWait();
        sSDPNotifySocket.post(sSDPNotifyRequest);
    }

    public void byebye(String string) {
        String string2 = this.getNotifyServiceTypeNT();
        String string3 = this.getNotifyServiceTypeUSN();
        SSDPNotifyRequest sSDPNotifyRequest = new SSDPNotifyRequest();
        sSDPNotifyRequest.setNTS("ssdp:byebye");
        sSDPNotifyRequest.setNT(string2);
        sSDPNotifyRequest.setUSN(string3);
        SSDPNotifySocket sSDPNotifySocket = new SSDPNotifySocket(string);
        Device.notifyWait();
        sSDPNotifySocket.post(sSDPNotifyRequest);
    }

    public boolean serviceSearchResponse(SSDPPacket sSDPPacket) {
        String string;
        String string2 = sSDPPacket.getST();
        if (string2 == null) {
            return false;
        }
        Device device = this.getDevice();
        String string3 = this.getNotifyServiceTypeNT();
        String string4 = this.getNotifyServiceTypeUSN();
        if (ST.isAllDevice(string2)) {
            device.postSearchResponse(sSDPPacket, string3, string4);
        } else if (ST.isURNService(string2) && string2.equals(string = this.getServiceType())) {
            device.postSearchResponse(sSDPPacket, string, string4);
        }
        return true;
    }

    public void setQueryListener(QueryListener queryListener) {
        ServiceStateTable serviceStateTable = this.getServiceStateTable();
        int n2 = serviceStateTable.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            StateVariable stateVariable = serviceStateTable.getStateVariable(i2);
            stateVariable.setQueryListener(queryListener);
        }
    }

    public SubscriberList getSubscriberList() {
        return this.getServiceData().getSubscriberList();
    }

    public void addSubscriber(Subscriber subscriber) {
        this.getSubscriberList().add(subscriber);
    }

    public void removeSubscriber(Subscriber subscriber) {
        this.getSubscriberList().remove(subscriber);
    }

    public Subscriber getSubscriber(String string) {
        SubscriberList subscriberList = this.getSubscriberList();
        int n2 = subscriberList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2;
            Subscriber subscriber = subscriberList.getSubscriber(i2);
            if (subscriber == null || (string2 = subscriber.getSID()) == null || !string2.equals(string)) continue;
            return subscriber;
        }
        return null;
    }

    private boolean notify(Subscriber subscriber, StateVariable stateVariable) {
        String string = stateVariable.getName();
        String string2 = stateVariable.getValue();
        String string3 = subscriber.getDeliveryHost();
        int n2 = subscriber.getDeliveryPort();
        NotifyRequest notifyRequest = new NotifyRequest();
        notifyRequest.setRequest(subscriber, string, string2);
        HTTPResponse hTTPResponse = notifyRequest.post(string3, n2);
        if (!hTTPResponse.isSuccessful()) {
            return false;
        }
        subscriber.incrementNotifyCount();
        return true;
    }

    public void notify(StateVariable stateVariable) {
        Subscriber subscriber;
        int n2;
        SubscriberList subscriberList = this.getSubscriberList();
        int n3 = subscriberList.size();
        Subscriber[] subscriberArray = new Subscriber[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            subscriberArray[n2] = subscriberList.getSubscriber(n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            subscriber = subscriberArray[n2];
            if (subscriber == null || !subscriber.isExpired()) continue;
            this.removeSubscriber(subscriber);
        }
        n3 = subscriberList.size();
        subscriberArray = new Subscriber[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            subscriberArray[n2] = subscriberList.getSubscriber(n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            subscriber = subscriberArray[n2];
            if (subscriber != null && this.notify(subscriber, stateVariable)) continue;
        }
    }

    public void notifyAllStateVariables() {
        ServiceStateTable serviceStateTable = this.getServiceStateTable();
        int n2 = serviceStateTable.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            StateVariable stateVariable = serviceStateTable.getStateVariable(i2);
            if (!stateVariable.isSendEvents()) continue;
            this.notify(stateVariable);
        }
    }

    public String getSID() {
        return this.getServiceData().getSID();
    }

    public void setSID(String string) {
        this.getServiceData().setSID(string);
    }

    public void clearSID() {
        this.setSID("");
        this.setTimeout(0L);
    }

    public boolean hasSID() {
        return StringUtil.hasData(this.getSID());
    }

    public boolean isSubscribed() {
        return this.hasSID();
    }

    public long getTimeout() {
        return this.getServiceData().getTimeout();
    }

    public void setTimeout(long l2) {
        this.getServiceData().setTimeout(l2);
    }

    public void setActionListener(ActionListener actionListener) {
        ActionList actionList = this.getActionList();
        int n2 = actionList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Action action = actionList.getAction(i2);
            action.setActionListener(actionListener);
        }
    }

    public void addStateVariable(StateVariable stateVariable) {
        Node node = this.getSCPDNode();
        Node node2 = null;
        if (node != null) {
            node2 = node.getNode("serviceStateTable");
        }
        if (node2 == null) {
            node2 = new Node("serviceStateTable");
            Node node3 = this.getSCPDNode();
            if (node3 != null) {
                node3.addNode(node2);
            }
        }
        stateVariable.setServiceNode(this.getServiceNode());
        node2.addNode(stateVariable.getStateVariableNode());
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }
}

