/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.screencapture;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.display.VirtualDisplay;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import android.view.View;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.screencupture.IScreenCapture;
import com.hpplay.component.common.screencupture.IScreenCaptureCallbackListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.screencapture.ScreenCaptureService;
import com.hpplay.component.screencapture.b;

public class ScreenCaptureImpl
extends IScreenCapture {
    private static String TAG = "ScreenCaptureImpl";
    private b mController = new b();
    private Context mContext;
    private a serviceConn;
    private ScreenCaptureService mCastService;
    private boolean isBind;
    private Object mNotification;
    private Object mChannel;
    private int mPid;
    private boolean isUseDefaultNotification = false;
    private boolean rotationMonitor = true;
    private IScreenCaptureCallbackListener mCallbackListener;

    @Override
    public void init(Context context, ParamsMap paramsMap) {
        this.mNotification = paramsMap.get("notification");
        if (Build.VERSION.SDK_INT >= 26 && paramsMap.get("notification_channel") != null) {
            this.mChannel = paramsMap.get("notification_channel");
        }
        this.mPid = Integer.parseInt(paramsMap.getParam("notification_pid", 0).toString());
        this.isUseDefaultNotification = Boolean.parseBoolean(paramsMap.getParam("use_default_notification", false).toString());
        this.rotationMonitor = Boolean.parseBoolean(paramsMap.getParam("rotation_monitor", true).toString());
        this.mContext = context;
        if (this.mController == null) {
            this.mController = new b();
            this.mController.setFrameCallbackListener(this.mCallbackListener);
        }
        this.mController.init(context, paramsMap);
    }

    @Override
    public void setFrameInterval(int n2) {
        this.mController.setFrameInterval(n2);
    }

    @Override
    public void setResolution(int n2, int n3, boolean bl) {
        if (this.mController != null) {
            this.mController.setResolution(n2, n3, bl);
        }
    }

    @Override
    public void setBitRate(int n2) {
        if (this.mController != null) {
            this.mController.setBitRate(n2);
        }
    }

    @Override
    public void setAudioSwitch(int n2, int n3, boolean bl, boolean bl2) {
        if (this.mController != null) {
            this.mController.setAudioSwitch(n2, n3, bl, bl2);
        }
    }

    @Override
    public void setFrameRate(int n2) {
        if (this.mController != null) {
            this.mController.setFrameRate(n2);
        }
    }

    @Override
    public void screenShot(String string, int n2) {
        if (this.mController != null) {
            this.mController.screenShot(string, n2);
        }
    }

    @Override
    public void setExpansionScreenInfo(Activity activity, View view) {
        if (this.mController != null) {
            this.mController.setExpansionScreenInfo(activity, view);
        }
    }

    @Override
    public void switchExpansionScreen(boolean bl) {
        if (this.mController != null) {
            this.mController.switchExpansionScreen(bl);
        }
    }

    @Override
    public void setFullScreenMode(boolean bl) {
        if (this.mController != null) {
            this.mController.setFullScreenMode(bl);
        }
    }

    @Override
    public void setMirrorMode(String string) {
        if (this.mController != null) {
            this.mController.setMirrorMode(string);
        }
    }

    @Override
    public void screenRecord(String string) {
        if (this.mController != null) {
            this.mController.screenRecord(string);
        }
    }

    @Override
    public void setFrameCallbackListener(IScreenCaptureCallbackListener iScreenCaptureCallbackListener) {
        this.mCallbackListener = iScreenCaptureCallbackListener;
        if (this.mController != null) {
            this.mController.setFrameCallbackListener(iScreenCaptureCallbackListener);
        }
    }

    @Override
    public void pauseEncoder(boolean bl) {
        if (this.mController != null) {
            this.mController.pauseEncoder(bl);
        }
    }

    @Override
    public boolean isSupportEncodeType(String string) {
        if (this.mController != null) {
            return this.mController.isSupportEncodeType(string);
        }
        return false;
    }

    @Override
    public void setVideoEncodeType(String string) {
        if (TextUtils.isEmpty((CharSequence)string) || this.mController == null) {
            return;
        }
        this.mController.setVideoEncodeType(string);
    }

    @Override
    public void setCaptureSource(int n2) {
        if (this.mController != null && n2 > 0) {
            this.mController.setCaptureSource(n2);
        }
    }

    @Override
    public void setDisplayDpi(int n2) {
        if (this.mController != null && n2 > 0) {
            this.mController.setDisplayDpi(n2);
        }
    }

    @Override
    public void setSampleRate(int n2) {
        if (this.mController != null) {
            this.mController.setSampleRate(n2);
        }
    }

    @Override
    public void setChannelMode(int n2) {
        if (this.mController != null) {
            this.mController.setChannelMode(n2);
        }
    }

    @Override
    public void setEncodeFormat(int n2) {
        if (this.mController != null) {
            this.mController.setEncodeFormat(n2);
        }
    }

    @Override
    public void resumeEncoder() {
        if (this.mController != null) {
            this.mController.resumeEncoder();
        }
    }

    @Override
    public void resetEncoder() {
        if (this.mController != null) {
            this.mController.resetEncoder();
        }
    }

    @Override
    public void resize(int n2) {
        if (this.mController != null) {
            this.mController.resize(n2);
        }
    }

    @Override
    public void resize() {
        if (this.mController != null) {
            this.mController.resize();
        }
    }

    @Override
    public void updatePCMData(int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        if (this.mController != null) {
            this.mController.updatePCMData(n2, n3, n4, byArray, n5, n6);
        }
    }

    @Override
    public void updateVideoData(byte[] byArray, int n2, int n3) {
        if (this.mController != null) {
            this.mController.updateVideoData(byArray, n2, n3);
        }
    }

    @Override
    public boolean startCapture(Intent intent) {
        if (this.mController.a()) {
            return this.mController.startCapture(null);
        }
        Intent intent2 = new Intent(this.mContext, ScreenCaptureService.class);
        this.serviceConn = new a(intent);
        intent2.putExtra("notification_channel", this.isUseDefaultNotification);
        if (Build.VERSION.SDK_INT >= 26 && this.isUseDefaultNotification) {
            this.mContext.startForegroundService(intent2);
        } else {
            this.mContext.startService(intent2);
        }
        this.mContext.bindService(intent2, (ServiceConnection)this.serviceConn, 1);
        return true;
    }

    @Override
    public boolean stopCapture() {
        if (!this.isBind) {
            return false;
        }
        if (this.mCastService != null) {
            this.mCastService.a();
            this.mCastService = null;
        }
        if (this.mController != null) {
            this.mController.stopCapture();
        }
        try {
            if (this.isBind) {
                this.mContext.unbindService((ServiceConnection)this.serviceConn);
            }
            this.isBind = false;
            this.mNotification = null;
            this.mChannel = null;
            this.mPid = 0;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        this.mController = null;
        return true;
    }

    @Override
    public int getFps() {
        if (this.mController != null) {
            return this.mController.getFps();
        }
        return 0;
    }

    @Override
    public int getBitrate() {
        if (this.mController != null) {
            return this.mController.getBitrate();
        }
        return 0;
    }

    @Override
    public String getMirrorMode() {
        if (this.mController != null) {
            return this.mController.getMirrorMode();
        }
        return null;
    }

    @Override
    public String getResolution() {
        if (this.mController != null) {
            return this.mController.getResolution();
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        if (this.mController == null) {
            return false;
        }
        return this.mController.isRunning();
    }

    @Override
    public void setMirrorType(int n2) {
        if (this.mController != null) {
            this.mController.setMirrorType(n2);
        }
    }

    @Override
    public void requestKeyFrame() {
        if (this.mController != null) {
            this.mController.requestKeyFrame();
        }
    }

    @Override
    public void setSecondMirrorView(View view) {
        if (this.mController != null) {
            this.mController.setSecondMirrorView(view);
        }
    }

    @Override
    public void setWatermarkInfo(Bitmap bitmap, Rect rect, float f2, float f3, int n2) {
        if (this.mController != null) {
            this.mController.setWatermarkInfo(bitmap, rect, f2, f3, n2);
        }
    }

    @Override
    public void watermarkInvisible() {
        if (this.mController != null) {
            this.mController.watermarkInvisible();
        }
    }

    @Override
    public void watermarkVisible() {
        if (this.mController != null) {
            this.mController.watermarkVisible();
        }
    }

    @Override
    public void disPlayReuse(boolean bl) {
        if (this.mController != null) {
            this.mController.disPlayReuse(bl);
        }
    }

    @Override
    public void hideMirrorScreen(Bitmap bitmap, Bitmap bitmap2) {
        if (this.mController != null) {
            this.mController.hideMirrorScreen(bitmap, bitmap2);
        }
    }

    @Override
    public void showMirrorScreen() {
        if (this.mController != null) {
            this.mController.showMirrorScreen();
        }
    }

    @Override
    public void setRotation(int n2, boolean bl) {
        if (this.mController != null) {
            this.mController.setRotation(n2, bl);
        }
    }

    @Override
    public VirtualDisplay getVirtualDisplay() {
        if (this.mController != null) {
            return this.mController.getVirtualDisplay();
        }
        return null;
    }

    @Override
    public void setRenderMode(int n2) {
        if (this.mController != null) {
            this.mController.setRenderMode(n2);
        }
    }

    public boolean serviceStart(Intent intent) {
        if (this.mController == null) {
            return false;
        }
        return this.mController.startCapture(intent);
    }

    private class a
    implements ServiceConnection {
        private Intent b;

        public a(Intent intent) {
            this.b = intent;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            CLog.i(TAG, "--------- screen capture ServiceConnected");
            ScreenCaptureImpl.this.mCastService = ((ScreenCaptureService.a)iBinder).a();
            if (null != ScreenCaptureImpl.this.mCastService) {
                ScreenCaptureImpl.this.mCastService.a(ScreenCaptureImpl.this.mNotification, ScreenCaptureImpl.this.mChannel, ScreenCaptureImpl.this.mPid);
                ScreenCaptureImpl.this.mCastService.a(this.b, ScreenCaptureImpl.this.rotationMonitor);
            }
            ScreenCaptureImpl.this.isBind = true;
        }

        public void onServiceDisconnected(ComponentName componentName) {
            CLog.i(TAG, "---------screen capture  onServiceDisconnected");
            ScreenCaptureImpl.this.mCastService = null;
            ScreenCaptureImpl.this.isBind = false;
        }
    }
}

