/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.upnp.ControlPoint;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.upnp.device.USN;
import com.hpplay.cybergarage.upnp.ssdp.LocationCacheHandleTask;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import com.hpplay.cybergarage.util.OnlineCheckUtil;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.Parser;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;

public class SSDPPacketHandleTask
extends Thread {
    private static final String TAG = "SSDPPacketHandleTask";
    private BlockingQueue<SSDPPacket> ssdpPackets = new LinkedBlockingQueue<SSDPPacket>(20);
    private AtomicBoolean isQuit = new AtomicBoolean();
    private ControlPoint mControlPoint;
    private SharedPreferences mPreferences;
    private LocationCacheHandleTask mLocationCacheHandleTask;

    public SSDPPacketHandleTask(ControlPoint controlPoint) {
        this.mControlPoint = controlPoint;
        try {
            this.mPreferences = ModuleLinker.getInstance().getContext().getSharedPreferences("key_dlna_location", 0);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        this.mLocationCacheHandleTask = new LocationCacheHandleTask(this.mControlPoint);
        this.mLocationCacheHandleTask.start();
    }

    public synchronized void updateSSDPPacket(SSDPPacket sSDPPacket) {
        CLog.w(TAG, " updateSSDPPacket " + this.hashCode());
        this.ssdpPackets.offer(sSDPPacket);
    }

    public boolean isQuit() {
        return this.isQuit.get();
    }

    @Override
    public void run() {
        super.run();
        this.isQuit.set(false);
        CLog.w(TAG, " start ssdp packet handle " + this.hashCode());
        while (!this.isQuit.get() && !this.isInterrupted()) {
            try {
                Object object;
                String string;
                SSDPPacket sSDPPacket = this.ssdpPackets.take();
                if (!sSDPPacket.isRootDevice()) continue;
                String string2 = sSDPPacket.getUSN();
                String string3 = USN.getUDN(string2);
                Device device = this.mControlPoint.getDevice(string3);
                if (device != null) {
                    int n2;
                    string = device.getLocation();
                    object = HTTP.getHost(string);
                    if (!OnlineCheckUtil.tcpCheckTvState((String)object, n2 = HTTP.getPort(string))) {
                        this.mControlPoint.removeDevice(string3);
                    } else {
                        device.setSSDPPacket(sSDPPacket);
                        this.mControlPoint.performAddDeviceListener(device);
                        continue;
                    }
                }
                string = sSDPPacket.getLocation();
                try {
                    CLog.w(TAG, " start  load desc" + string.replace(".", "") + "\r\n   " + new String(sSDPPacket.getData()));
                    object = UPnP.getXMLParser();
                    Node node = ((Parser)object).parseUrl(string);
                    Device device2 = this.mControlPoint.getDevice(node);
                    if (device2 == null) continue;
                    device2.setSSDPPacket(sSDPPacket);
                    this.mControlPoint.addDevice(node);
                    this.mControlPoint.performAddDeviceListener(device2);
                    this.saveToLocal(string);
                }
                catch (Exception exception) {
                    CLog.i(TAG, "addDevice parse exception  \r\n" + exception.toString());
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
                break;
            }
        }
        CLog.i(TAG, "  SSDPPacketHandleTask exit");
        this.isQuit.set(true);
    }

    private void saveToLocal(String string) {
        try {
            int n2;
            JSONArray jSONArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = this.mPreferences.getString("key_dlna_location", null);
            CLog.w(TAG, " LocationCacheHandleTasker : " + string.replace(".", ""));
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONArray = new JSONArray(string2);
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    arrayList.add(jSONArray.optString(n2));
                }
            }
            if (!arrayList.contains(string) && this.mPreferences != null) {
                arrayList.add(string);
                jSONArray = new JSONArray();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    jSONArray.put(n2, arrayList.get(n2));
                }
                if (arrayList.size() > 5) {
                    for (n2 = 4; n2 < arrayList.size(); ++n2) {
                        arrayList.remove(0);
                    }
                }
                this.mPreferences.edit().putString("key_dlna_location", jSONArray.toString()).apply();
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void release() {
        CLog.i(TAG, "  SSDPPacketHandleTask release " + this.hashCode());
        this.isQuit.set(true);
        this.interrupt();
        this.mControlPoint = null;
        this.ssdpPackets.clear();
        if (this.mLocationCacheHandleTask != null) {
            this.mLocationCacheHandleTask.release();
            this.mLocationCacheHandleTask = null;
        }
    }
}

