/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp.utils;

import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import com.herohan.uvcapp.utils.WatchdogDiagnostics;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Watchdog
extends Thread {
    static final String TAG = "Watchdog";
    public static final boolean DEBUG = false;
    static final boolean DB = true;
    static final long DEFAULT_TIMEOUT = 10000L;
    static final long CHECK_INTERVAL = 5000L;
    static final int COMPLETED = 0;
    static final int WAITING = 1;
    static final int WAITED_HALF = 2;
    static final int OVERDUE = 3;
    static Watchdog sWatchdog;
    final ArrayList<HandlerChecker> mHandlerCheckers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Watchdog getInstance() {
        if (sWatchdog != null) return sWatchdog;
        Class<Watchdog> clazz = Watchdog.class;
        synchronized (Watchdog.class) {
            if (sWatchdog != null) return sWatchdog;
            sWatchdog = new Watchdog();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sWatchdog;
        }
    }

    private Watchdog() {
        super("watchdog");
    }

    public void addThread(Handler thread) {
        this.addThread(thread, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThread(Handler thread, long timeoutMillis) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            String name = thread.getLooper().getThread().getName();
            this.mHandlerCheckers.add(new HandlerChecker(thread, name, timeoutMillis));
        }
    }

    public void removeThread(Handler thread) {
        for (HandlerChecker hc : this.mHandlerCheckers) {
            if (hc.mHandler != thread) continue;
            this.mHandlerCheckers.remove(hc);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseWatchingCurrentThread(String reason) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            for (HandlerChecker hc : this.mHandlerCheckers) {
                if (!Thread.currentThread().equals(hc.getThread())) continue;
                hc.pauseLocked(reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWatchingCurrentThread(String reason) {
        Watchdog watchdog = this;
        synchronized (watchdog) {
            for (HandlerChecker hc : this.mHandlerCheckers) {
                if (!Thread.currentThread().equals(hc.getThread())) continue;
                hc.resumeLocked(reason);
            }
        }
    }

    private int evaluateCheckerCompletionLocked() {
        int state = 0;
        for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
            HandlerChecker hc = this.mHandlerCheckers.get(i);
            state = Math.max(state, hc.getCompletionStateLocked());
        }
        return state;
    }

    private ArrayList<HandlerChecker> getBlockedCheckersLocked() {
        ArrayList<HandlerChecker> checkers = new ArrayList<HandlerChecker>();
        for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
            HandlerChecker hc = this.mHandlerCheckers.get(i);
            if (!hc.isOverdueLocked()) continue;
            checkers.add(hc);
        }
        return checkers;
    }

    private String describeCheckersLocked(List<HandlerChecker> checkers) {
        StringBuilder builder = new StringBuilder(128);
        for (int i = 0; i < checkers.size(); ++i) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(checkers.get(i).describeBlockedStateLocked());
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean waitedHalf = false;
        while (true) {
            String subject;
            ArrayList<HandlerChecker> blockedCheckers;
            int debuggerWasConnected = 0;
            Watchdog watchdog = this;
            synchronized (watchdog) {
                long timeout = 5000L;
                for (int i = 0; i < this.mHandlerCheckers.size(); ++i) {
                    HandlerChecker hc = this.mHandlerCheckers.get(i);
                    hc.scheduleCheckLocked();
                }
                Log.d((String)TAG, (String)("mHandlerCheckers count:" + this.mHandlerCheckers.size()));
                if (debuggerWasConnected > 0) {
                    --debuggerWasConnected;
                }
                long start = SystemClock.uptimeMillis();
                while (timeout > 0L) {
                    if (Debug.isDebuggerConnected()) {
                        debuggerWasConnected = 2;
                    }
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Log.wtf((String)TAG, (Throwable)e);
                    }
                    if (Debug.isDebuggerConnected()) {
                        debuggerWasConnected = 2;
                    }
                    timeout = 5000L - (SystemClock.uptimeMillis() - start);
                }
                int waitState = this.evaluateCheckerCompletionLocked();
                if (waitState == 0) {
                    waitedHalf = false;
                    continue;
                }
                if (waitState == 1) {
                    continue;
                }
                if (waitState == 2) {
                    if (!waitedHalf) {
                        Log.i((String)TAG, (String)"WAITED_HALF");
                        waitedHalf = true;
                    }
                    continue;
                }
                blockedCheckers = this.getBlockedCheckersLocked();
                subject = this.describeCheckersLocked(blockedCheckers);
            }
            SystemClock.sleep((long)5000L);
            this.doSysRq('w');
            this.doSysRq('l');
            if (Debug.isDebuggerConnected()) {
                debuggerWasConnected = 2;
            }
            if (debuggerWasConnected >= 2) {
                Log.w((String)TAG, (String)"Debugger connected");
            } else if (debuggerWasConnected > 0) {
                Log.w((String)TAG, (String)"Debugger was connected");
            } else {
                Log.w((String)TAG, (String)("*** WATCHDOG DIAGNOSE: " + subject));
                if (WatchdogDiagnostics.diagnoseCheckers(blockedCheckers)) break;
            }
            waitedHalf = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSysRq(char c) {
        FileWriter sysrqTrigger = null;
        try {
            sysrqTrigger = new FileWriter("/proc/sysrq-trigger");
            sysrqTrigger.write(c);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to write to /proc/sysrq-trigger", (Throwable)e);
        }
        finally {
            try {
                if (sysrqTrigger != null) {
                    sysrqTrigger.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public final class HandlerChecker
    implements Runnable {
        private final Handler mHandler;
        private final String mName;
        private final long mWaitMax;
        private final ArrayList<Monitor> mMonitors = new ArrayList();
        private final ArrayList<Monitor> mMonitorQueue = new ArrayList();
        private boolean mCompleted;
        private Monitor mCurrentMonitor;
        private long mStartTime;
        private int mPauseCount;

        HandlerChecker(Handler handler, String name, long waitMaxMillis) {
            this.mHandler = handler;
            this.mName = name;
            this.mWaitMax = waitMaxMillis;
            this.mCompleted = true;
        }

        void addMonitorLocked(Monitor monitor) {
            this.mMonitorQueue.add(monitor);
        }

        public void scheduleCheckLocked() {
            if (this.mCompleted) {
                this.mMonitors.addAll(this.mMonitorQueue);
                this.mMonitorQueue.clear();
            }
            boolean isIdle = false;
            if (Build.VERSION.SDK_INT >= 31) {
                isIdle = this.mHandler.getLooper().getQueue().isIdle();
            }
            if (this.mMonitors.size() == 0 && isIdle || this.mPauseCount > 0) {
                this.mCompleted = true;
                return;
            }
            if (!this.mCompleted) {
                return;
            }
            this.mCompleted = false;
            this.mCurrentMonitor = null;
            this.mStartTime = SystemClock.uptimeMillis();
            if (this.mHandler.getLooper().getThread().isAlive()) {
                this.mHandler.postAtFrontOfQueue((Runnable)this);
            }
        }

        boolean isOverdueLocked() {
            return !this.mCompleted && SystemClock.uptimeMillis() > this.mStartTime + this.mWaitMax;
        }

        public int getCompletionStateLocked() {
            if (this.mCompleted) {
                return 0;
            }
            long latency = SystemClock.uptimeMillis() - this.mStartTime;
            if (latency < this.mWaitMax / 2L) {
                return 1;
            }
            if (latency < this.mWaitMax) {
                return 2;
            }
            return 3;
        }

        public Thread getThread() {
            return this.mHandler.getLooper().getThread();
        }

        public String getName() {
            return this.mName;
        }

        String describeBlockedStateLocked() {
            if (this.mCurrentMonitor == null) {
                return "Blocked in handler on " + this.mName + " (" + this.getThread().getName() + ")";
            }
            return "Blocked in monitor " + this.mCurrentMonitor.getClass().getName() + " on " + this.mName + " (" + this.getThread().getName() + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int size = this.mMonitors.size();
            for (int i = 0; i < size; ++i) {
                Watchdog watchdog = Watchdog.this;
                synchronized (watchdog) {
                    this.mCurrentMonitor = this.mMonitors.get(i);
                }
                this.mCurrentMonitor.monitor();
            }
            Watchdog watchdog = Watchdog.this;
            synchronized (watchdog) {
                this.mCompleted = true;
                this.mCurrentMonitor = null;
            }
        }

        public void pauseLocked(String reason) {
            ++this.mPauseCount;
            this.mCompleted = true;
            Log.i((String)Watchdog.TAG, (String)("Pausing HandlerChecker: " + this.mName + " for reason: " + reason + ". Pause count: " + this.mPauseCount));
        }

        public void resumeLocked(String reason) {
            if (this.mPauseCount > 0) {
                --this.mPauseCount;
                Log.i((String)Watchdog.TAG, (String)("Resuming HandlerChecker: " + this.mName + " for reason: " + reason + ". Pause count: " + this.mPauseCount));
            } else {
                Log.wtf((String)Watchdog.TAG, (String)("Already resumed HandlerChecker: " + this.mName));
            }
        }
    }

    public static interface Monitor {
        public void monitor();
    }
}

