/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol;

import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolCore;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.encrypt.LelinkEncrypt;
import java.io.IOException;
import java.util.ArrayList;

public class LelinkReverseChannel
extends ProtocolCore
implements Runnable {
    private static final String TAG = "LelinkReverseChannel";
    private static final String KEY_HEADER_EVENT = "POST /heart";
    private static final String KEY_HEADER_HARDBET = "POST /event";
    private static final String KEY_HEADER_PHOTO_STATE = "POST /photo";
    public static final String ENCRYPT_FAILED = "encrypt_failed";
    private ProtocolListener mProtocolListener;
    private Thread mReceiveThread;
    private int totalLength = 0;
    private byte[] receveData = null;
    private byte[] mProtocol;
    private boolean isStop = false;
    private LelinkEncrypt mLelinkEncrypt;

    public LelinkReverseChannel() {
    }

    public LelinkReverseChannel(String string, int n2) {
        this.mIP = string;
        this.mPort = n2;
        CLog.d(TAG, "create reverse");
    }

    public LelinkReverseChannel(String string, int n2, String string2) {
        this.mIP = string;
        this.mPort = n2;
        this.mLelinkEncrypt = new LelinkEncrypt(string2);
        this.mLelinkEncrypt.setSrpPassword(null);
        CLog.d(TAG, "create reverse");
    }

    public LelinkReverseChannel(String string, int n2, String string2, String string3) {
        this.mIP = string;
        this.mPort = n2;
        this.mLelinkEncrypt = new LelinkEncrypt(string2);
        this.mLelinkEncrypt.setSrpPassword(string3);
        CLog.d(TAG, "create reverse");
    }

    public void setRecevelistenerAndProtocol(ProtocolListener protocolListener, byte[] byArray) {
        this.mProtocolListener = protocolListener;
        this.mProtocol = byArray;
    }

    public void startReceive() {
        if (this.mReceiveThread == null) {
            CLog.d(TAG, "---------------------->startReceive");
            this.mReceiveThread = new Thread(this);
            this.mReceiveThread.setName("ReverseReceiverThread");
            this.mReceiveThread.start();
        }
    }

    public synchronized void stopReceive() {
        this.isStop = true;
        if (this.mReceiveThread != null) {
            CLog.i(TAG, "---------------------->stopReceive");
            this.mReceiveThread.interrupt();
            this.mReceiveThread = null;
        }
        this.mProtocolListener = null;
        this.closeSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.mSocket == null) {
            try {
                this.connectServer();
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        if (this.mLelinkEncrypt != null) {
            if (!this.checkEncrypt(this.mLelinkEncrypt, TAG)) {
                if (this.mProtocolListener != null) {
                    this.mProtocolListener.onResult(this.mProtocolListener.cmdType, ENCRYPT_FAILED);
                }
                return;
            }
            this.sendEncryptData();
            this.totalLength = 0;
            this.receveData = null;
            this.isStop = false;
            while (!this.isStop) {
                CLog.d(TAG, this.isStop + " start read " + (this.mProtocolListener == null));
                if (!this.readEncryptData()) continue;
            }
            this.closeSocket();
            return;
        }
        if (this.mProtocol != null) {
            this.sendData();
        }
        CLog.d(TAG, this.isStop + "----------sendReverse---------------" + (this.mLocalAutoCloseInputStream == null));
        byte[] byArray = new byte[11];
        int n2 = 0;
        this.isStop = false;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        boolean bl = false;
        while (!this.isStop) {
            int n3;
            if (this.mLocalAutoCloseInputStream == null) continue;
            try {
                n2 = this.mLocalAutoCloseInputStream.read(byArray);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            if (n2 <= 0) continue;
            if (byArray.length == 1) {
                arrayList.add(byArray[0]);
                if (!ProtocolUtils.getProtocolDivide(arrayList)) continue;
                byte[] byArray2 = new byte[arrayList.size()];
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    byArray2[i2] = arrayList.get(i2);
                }
                String string = new String(byArray2);
                CLog.d("header", "" + string);
                if (string.contains(KEY_HEADER_PHOTO_STATE)) {
                    if (this.mProtocolListener != null) {
                        this.mProtocolListener.onResult(this.mProtocolListener.cmdType, string);
                    }
                    byArray = new byte[11];
                    continue;
                }
                try {
                    n3 = ProtocolUtils.getContentLength(string);
                    CLog.d(TAG, "contentLength" + n3 + "");
                    if (n3 > 0 && n3 < 0x200000) {
                        byArray = new byte[n3];
                        arrayList.clear();
                        continue;
                    }
                    byArray = new byte[11];
                    arrayList.clear();
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                    byArray = new byte[11];
                }
                continue;
            }
            if (byArray.length == 11 && !bl) {
                try {
                    arrayList.clear();
                    String string = new String(byArray, 0, byArray.length);
                    if (string.equals(KEY_HEADER_EVENT) || string.equals(KEY_HEADER_HARDBET) || string.equals(KEY_HEADER_PHOTO_STATE)) {
                        for (int i3 = 0; i3 < byArray.length; ++i3) {
                            arrayList.add(byArray[i3]);
                        }
                    }
                    CLog.d(TAG, string);
                    continue;
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                    continue;
                }
                finally {
                    byArray = new byte[1];
                    continue;
                }
            }
            bl = false;
            arrayList.clear();
            try {
                if (n2 < byArray.length) {
                    CLog.d(TAG, "---------------------->" + byArray.length + "  ----------------   " + n2);
                    byte[] byArray3 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray3, 0, n2);
                    arrayList2.add(byArray3);
                    int n4 = byArray.length - n2;
                    byArray = new byte[n4];
                    if (n4 != 11) continue;
                    bl = true;
                    continue;
                }
                int n5 = n2;
                for (int i4 = 0; i4 < arrayList2.size(); ++i4) {
                    n5 += ((byte[])arrayList2.get(i4)).length;
                }
                byte[] byArray4 = new byte[n5];
                n3 = 0;
                for (int i5 = 0; i5 < arrayList2.size(); ++i5) {
                    System.arraycopy(arrayList2.get(i5), 0, byArray4, n3, ((byte[])arrayList2.get(i5)).length);
                    n3 += ((byte[])arrayList2.get(i5)).length;
                }
                System.arraycopy(byArray, 0, byArray4, n3, n2);
                String string = new String(byArray4, 0, n5);
                CLog.d(TAG, string);
                if (this.mProtocolListener != null) {
                    this.mProtocolListener.onResult(this.mProtocolListener.cmdType, string);
                }
                byArray = new byte[11];
                arrayList2.clear();
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
                byArray = new byte[11];
                arrayList2.clear();
            }
        }
        this.closeSocket();
        CLog.d(TAG, "----------exit---------------");
    }

    private void sendData() {
        CLog.i(TAG, "----------->> sendData");
        byte[] byArray = new byte[2048];
        try {
            this.mLocalFileOutputStream.write(this.mProtocol);
            this.mLocalFileOutputStream.flush();
            int n2 = this.mLocalAutoCloseInputStream.read(byArray);
            if (n2 < 0) {
                return;
            }
            String string = new String(byArray, 0, n2);
            if (this.mProtocolListener != null) {
                this.mProtocolListener.onResult(this.mProtocolListener.cmdType, string);
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private void sendEncryptData() {
        try {
            byte[] byArray = this.mLelinkEncrypt.buildEncryptData(new byte[][]{this.mProtocol});
            this.mLocalFileOutputStream.write(byArray);
            this.mLocalFileOutputStream.flush();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public boolean readEncryptData() {
        try {
            byte[] byArray = new byte[4];
            int n2 = this.mLocalAutoCloseInputStream.available();
            if (this.totalLength == 0) {
                int n3 = this.mLocalAutoCloseInputStream.read(byArray, 0, 4);
                if (n3 < 0) {
                    return true;
                }
                int n4 = ProtocolUtils.bytesToInt(byArray);
                if (n4 == 0 || n4 > 0x200000) {
                    return false;
                }
                this.totalLength = 4;
                this.receveData = new byte[n4 + this.totalLength + 16];
                System.arraycopy(byArray, 0, this.receveData, 0, byArray.length);
            } else {
                byte[] byArray2 = new byte[n2];
                if (n2 > this.receveData.length - this.totalLength) {
                    n2 = this.receveData.length - this.totalLength;
                    byArray2 = new byte[n2];
                }
                this.mLocalAutoCloseInputStream.read(byArray2, 0, n2);
                System.arraycopy(byArray2, 0, this.receveData, this.totalLength, byArray2.length);
                this.totalLength += n2;
                if (this.totalLength == this.receveData.length) {
                    this.parseResponse(this.receveData);
                    this.totalLength = 0;
                    this.receveData = null;
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            CLog.d(TAG, " startCapture read " + exception.toString());
            return true;
        }
        return false;
    }

    void parseResponse(byte[] byArray) {
        try {
            byte[] byArray2 = this.mLelinkEncrypt.decryptData(byArray);
            if (byArray2 != null && byArray2.length > 0) {
                byte[] byArray3 = ProtocolUtils.getBody(byArray2);
                String string = byArray3 == null || byArray3.length < 10 ? new String(byArray2, 0, byArray2.length, "utf-8") : new String(byArray3, 0, byArray3.length, "utf-8");
                CLog.i(TAG, string);
                if (this.mProtocolListener != null) {
                    this.mProtocolListener.onResult(this.mProtocolListener.cmdType, string);
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private synchronized void closeSocket() {
        if (this.mLocalAutoCloseInputStream != null) {
            try {
                CLog.d(TAG, "----------->closeSender");
                this.mLocalAutoCloseInputStream.close();
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
            }
        }
        if (this.mLocalFileOutputStream != null) {
            try {
                this.mLocalFileOutputStream.close();
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
            }
        }
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
            }
        }
        this.mSocket = null;
        this.mLocalFileOutputStream = null;
        this.mLocalAutoCloseInputStream = null;
    }
}

