/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.encrypt;

public class ChaCha20 {
    public static final int KEY_SIZE = 32;
    public static final int NONCE_SIZE_REF = 8;
    public static final int NONCE_SIZE_IETF = 12;
    private int[] matrix = new int[16];

    protected static int littleEndianToInt(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    protected static void intToLittleEndian(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[++n3] = (byte)(n2 >>> 8);
        byArray[++n3] = (byte)(n2 >>> 16);
        byArray[++n3] = (byte)(n2 >>> 24);
    }

    protected static int ROTATE(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    protected static void quarterRound(int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = n2;
        nArray[n6] = nArray[n6] + nArray[n3];
        nArray[n5] = ChaCha20.ROTATE(nArray[n5] ^ nArray[n2], 16);
        int n7 = n4;
        nArray[n7] = nArray[n7] + nArray[n5];
        nArray[n3] = ChaCha20.ROTATE(nArray[n3] ^ nArray[n4], 12);
        int n8 = n2;
        nArray[n8] = nArray[n8] + nArray[n3];
        nArray[n5] = ChaCha20.ROTATE(nArray[n5] ^ nArray[n2], 8);
        int n9 = n4;
        nArray[n9] = nArray[n9] + nArray[n5];
        nArray[n3] = ChaCha20.ROTATE(nArray[n3] ^ nArray[n4], 7);
    }

    public ChaCha20(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray.length != 32) {
            throw new WrongKeySizeException();
        }
        this.matrix[0] = 1634760805;
        this.matrix[1] = 857760878;
        this.matrix[2] = 2036477234;
        this.matrix[3] = 1797285236;
        this.matrix[4] = ChaCha20.littleEndianToInt(byArray, 0);
        this.matrix[5] = ChaCha20.littleEndianToInt(byArray, 4);
        this.matrix[6] = ChaCha20.littleEndianToInt(byArray, 8);
        this.matrix[7] = ChaCha20.littleEndianToInt(byArray, 12);
        this.matrix[8] = ChaCha20.littleEndianToInt(byArray, 16);
        this.matrix[9] = ChaCha20.littleEndianToInt(byArray, 20);
        this.matrix[10] = ChaCha20.littleEndianToInt(byArray, 24);
        this.matrix[11] = ChaCha20.littleEndianToInt(byArray, 28);
        if (byArray2.length == 8) {
            this.matrix[12] = 0;
            this.matrix[13] = 0;
            this.matrix[14] = ChaCha20.littleEndianToInt(byArray2, 0);
            this.matrix[15] = ChaCha20.littleEndianToInt(byArray2, 4);
        } else if (byArray2.length == 12) {
            this.matrix[12] = n2;
            this.matrix[13] = ChaCha20.littleEndianToInt(byArray2, 0);
            this.matrix[14] = ChaCha20.littleEndianToInt(byArray2, 4);
            this.matrix[15] = ChaCha20.littleEndianToInt(byArray2, 8);
        } else {
            throw new WrongNonceSizeException();
        }
    }

    public void encrypt(byte[] byArray, byte[] byArray2, int n2) {
        int[] nArray = new int[16];
        byte[] byArray3 = new byte[64];
        int n3 = 0;
        int n4 = 0;
        while (n2 > 0) {
            int n5 = 16;
            while (n5-- > 0) {
                nArray[n5] = this.matrix[n5];
            }
            for (n5 = 20; n5 > 0; n5 -= 2) {
                ChaCha20.quarterRound(nArray, 0, 4, 8, 12);
                ChaCha20.quarterRound(nArray, 1, 5, 9, 13);
                ChaCha20.quarterRound(nArray, 2, 6, 10, 14);
                ChaCha20.quarterRound(nArray, 3, 7, 11, 15);
                ChaCha20.quarterRound(nArray, 0, 5, 10, 15);
                ChaCha20.quarterRound(nArray, 1, 6, 11, 12);
                ChaCha20.quarterRound(nArray, 2, 7, 8, 13);
                ChaCha20.quarterRound(nArray, 3, 4, 9, 14);
            }
            n5 = 16;
            while (n5-- > 0) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + this.matrix[n5];
            }
            n5 = 16;
            while (n5-- > 0) {
                ChaCha20.intToLittleEndian(nArray[n5], byArray3, 4 * n5);
            }
            this.matrix[12] = this.matrix[12] + 1;
            if (this.matrix[12] <= 0) {
                this.matrix[13] = this.matrix[13] + 1;
            }
            if (n2 <= 64) {
                n5 = n2;
                while (n5-- > 0) {
                    byArray[n5 + n3] = (byte)(byArray2[n5 + n4] ^ byArray3[n5]);
                }
                return;
            }
            n5 = 64;
            while (n5-- > 0) {
                byArray[n5 + n3] = (byte)(byArray2[n5 + n4] ^ byArray3[n5]);
            }
            n2 -= 64;
            n4 += 64;
            n3 += 64;
        }
    }

    public void decrypt(byte[] byArray, byte[] byArray2, int n2) {
        this.encrypt(byArray, byArray2, n2);
    }

    public class WrongKeySizeException
    extends Exception {
        private static final long serialVersionUID = -290509589749955895L;
    }

    public class WrongNonceSizeException
    extends Exception {
        private static final long serialVersionUID = 2687731889587117531L;
    }
}

