/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.utils;

import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import com.hpplay.common.log.LeLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtil {
    private static final String TAG = "NetworkUtil";
    public static final int NET_TYPE_UNKNOWN = 0;
    public static final int NET_TYPE_2_4_G = 1;
    public static final int NET_TYPE_5_G = 2;
    public static final int NET_TYPE_CABLE = 3;
    public static final int NET_TYPE_AP = 4;
    public static final int NET_TYPE_OTHER = 5;
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;
    private static boolean enableSSID = true;
    private static boolean enableBSSID = true;

    public static void setSSIDStatus(boolean bl) {
        enableSSID = bl;
    }

    public static void setBSSIDStatus(boolean bl) {
        enableBSSID = bl;
    }

    public static int getNetType(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                String string = networkInfo.getTypeName();
                if (string.equalsIgnoreCase("Ethernet") || string.equalsIgnoreCase("ETH")) {
                    return 3;
                }
                if (string.equalsIgnoreCase("WIFI")) {
                    String string2 = NetworkUtil.getWifiSSID(context);
                    if (!TextUtils.isEmpty((CharSequence)string2) && (string2.contains("unknown") || string2.contains("0x"))) {
                        return 3;
                    }
                    return NetworkUtil.getWifiType(context) == 0 ? 1 : 2;
                }
                String string3 = NetworkUtil.getAPName(context);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    return 4;
                }
                return 3;
            }
            return 0;
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
            return 0;
        }
    }

    public static String getWifiBSSID(Context context) {
        if (!enableBSSID) {
            return "";
        }
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            return wifiInfo.getBSSID();
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
            return "";
        }
    }

    public static String getWifiBSSIDNoneColon(Context context) {
        String string = NetworkUtil.getWifiBSSID(context);
        string = string != null ? string.replace(":", "") : "";
        return string;
    }

    public static String getWifiSSID(Context context) {
        ConnectivityManager connectivityManager;
        NetworkInfo networkInfo;
        if (!enableSSID) {
            return null;
        }
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        if (Build.VERSION.SDK_INT <= 26 || Build.VERSION.SDK_INT >= 28) {
            WifiManager wifiManager = (WifiManager)context2.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (Build.VERSION.SDK_INT < 19) {
                return wifiInfo.getSSID();
            }
            return wifiInfo.getSSID().replace("\"", "");
        }
        if (Build.VERSION.SDK_INT == 27 && (networkInfo = (connectivityManager = (ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo()).isConnected() && networkInfo.getExtraInfo() != null) {
            return networkInfo.getExtraInfo().replace("\"", "");
        }
        return null;
    }

    public static int getWifiType(Context context) {
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                WifiManager wifiManager = (WifiManager)context2.getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                Method method = Class.forName(WifiInfo.class.getName()).getDeclaredMethod("is5GHz", new Class[0]);
                boolean bl = (Boolean)method.invoke((Object)wifiInfo, new Object[0]);
                return bl ? 1 : 0;
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
                return NetworkUtil.getTypeUnder21(context2);
            }
        }
        return NetworkUtil.getTypeUnder21(context2);
    }

    private static int getTypeUnder21(Context context) {
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        try {
            WifiManager wifiManager = (WifiManager)context2.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            String string = wifiInfo.getSSID();
            if (string != null && string.length() > 2) {
                String string2 = string.substring(1, string.length() - 1);
                List list = wifiManager.getScanResults();
                for (ScanResult scanResult : list) {
                    int n2;
                    if (!scanResult.SSID.equals(string2) || (n2 = scanResult.frequency) <= 4900 || n2 >= 5900) continue;
                    return 1;
                }
            }
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        return 0;
    }

    private static String getAPName(Context context) {
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        if (NetworkUtil.isWifiApOpen(context2)) {
            try {
                WifiManager wifiManager = (WifiManager)context2.getSystemService("wifi");
                Method method = wifiManager.getClass().getDeclaredMethod("getWifiApConfiguration", new Class[0]);
                WifiConfiguration wifiConfiguration = (WifiConfiguration)method.invoke((Object)wifiManager, new Object[0]);
                return wifiConfiguration.SSID;
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
            }
        }
        return "";
    }

    private static boolean isWifiApOpen(Context context) {
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        try {
            WifiManager wifiManager = (WifiManager)context2.getSystemService("wifi");
            Method method = wifiManager.getClass().getDeclaredMethod("getWifiApState", new Class[0]);
            int n2 = (Integer)method.invoke((Object)wifiManager, new Object[0]);
            Field field = wifiManager.getClass().getDeclaredField("WIFI_AP_STATE_ENABLED");
            int n3 = (Integer)field.get(wifiManager);
            return n2 == n3;
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
            return false;
        }
    }

    public static boolean isWiFiOpen(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 1;
    }

    public static String getNetWorkName(Context context) {
        String string = "\u6709\u7ebf\u7f51\u7edc";
        String string2 = "\u65e0\u7ebf\u7f51\u7edc";
        String string3 = "\u79fb\u52a8\u7f51\u7edc";
        String string4 = "\u7f51\u7edc\u9519\u8bef";
        return NetworkUtil.getNetWorkName(context, string, string2, string3, string4);
    }

    public static String getNetWorkName(Context context, String string, String string2) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                String string3 = networkInfo.getTypeName();
                if (string3.equalsIgnoreCase("Ethernet") || string3.equalsIgnoreCase("ETH")) {
                    return string;
                }
                if (string3.equalsIgnoreCase("WIFI")) {
                    String string4 = NetworkUtil.getWifiSSID(context);
                    if (string4 != null && (string4.contains("unknown") || string4.contains("0x"))) {
                        string4 = string;
                    }
                    return string4;
                }
                return string;
            }
            String string5 = NetworkUtil.getAPName(context);
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                return string5;
            }
            return string2;
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
            return string2;
        }
    }

    public static String getNetWorkName(Context context, String string, String string2, String string3, String string4) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                String string5 = networkInfo.getTypeName();
                if (string5.equalsIgnoreCase("Ethernet") || string5.equalsIgnoreCase("ETH")) {
                    return string;
                }
                if (string5.equalsIgnoreCase("WIFI")) {
                    String string6 = NetworkUtil.getWifiSSID(context);
                    if (string6 != null && (string6.contains("unknown") || string6.contains("0x"))) {
                        string6 = string2;
                    }
                    return string6;
                }
                if (string5.equalsIgnoreCase("MOBILE")) {
                    return string3;
                }
                return string4;
            }
            String string7 = NetworkUtil.getAPName(context);
            if (!TextUtils.isEmpty((CharSequence)string7)) {
                return string7;
            }
            return string4;
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
            return string4;
        }
    }

    public static String getIPAddress(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 0) {
                try {
                    Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                    while (enumeration.hasMoreElements()) {
                        NetworkInterface networkInterface = enumeration.nextElement();
                        Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            InetAddress inetAddress = enumeration2.nextElement();
                            if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                            return inetAddress.getHostAddress();
                        }
                    }
                }
                catch (Exception exception) {
                    LeLog.w(TAG, exception);
                }
            } else if (networkInfo.getType() == 1) {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                String string = NetworkUtil.intIP2StringIP(wifiInfo.getIpAddress());
                return string;
            }
        }
        return null;
    }

    private static String intIP2StringIP(int n2) {
        return (n2 & 0xFF) + "." + (n2 >> 8 & 0xFF) + "." + (n2 >> 16 & 0xFF) + "." + (n2 >> 24 & 0xFF);
    }

    public static NetworkType getNetworkType(Context context) {
        NetworkType networkType = NetworkType.NETWORK_NO;
        NetworkInfo networkInfo = NetworkUtil.getActiveNetworkInfo(context);
        if (networkInfo != null && networkInfo.isAvailable()) {
            if (networkInfo.getType() == 1) {
                networkType = NetworkType.NETWORK_WIFI;
            } else if (networkInfo.getType() == 0) {
                switch (networkInfo.getSubtype()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        networkType = NetworkType.NETWORK_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        networkType = NetworkType.NETWORK_3G;
                        break;
                    }
                    case 13: 
                    case 18: {
                        networkType = NetworkType.NETWORK_4G;
                        break;
                    }
                    default: {
                        String string = networkInfo.getSubtypeName();
                        if (string.equalsIgnoreCase("TD-SCDMA") || string.equalsIgnoreCase("WCDMA") || string.equalsIgnoreCase("CDMA2000")) {
                            networkType = NetworkType.NETWORK_3G;
                            break;
                        }
                        networkType = NetworkType.NETWORK_UNKNOWN;
                        break;
                    }
                }
            } else {
                networkType = NetworkType.NETWORK_UNKNOWN;
            }
        }
        return networkType;
    }

    private static NetworkInfo getActiveNetworkInfo(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                return null;
            }
            return connectivityManager.getActiveNetworkInfo();
        }
        catch (Exception exception) {
            LeLog.w(TAG, "getActiveNetworkInfo error:" + exception.getMessage());
            return null;
        }
    }

    public static String[] getWifiScanResults(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager != null) {
            List list = wifiManager.getScanResults();
            if (list == null || list.size() == 0) {
                return null;
            }
            if (list != null) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                StringBuilder stringBuilder3 = new StringBuilder();
                StringBuilder stringBuilder4 = new StringBuilder();
                String[] stringArray = new String[4];
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String string;
                    if (i2 == list.size() - 1) {
                        try {
                            string = ((ScanResult)list.get((int)i2)).BSSID.replace(":", "");
                            stringBuilder.append(string.toUpperCase());
                            stringBuilder2.append(((ScanResult)list.get((int)i2)).SSID);
                            stringBuilder3.append(((ScanResult)list.get((int)i2)).level);
                            stringBuilder4.append(System.currentTimeMillis() + "");
                        }
                        catch (Exception exception) {
                            LeLog.w(TAG, exception);
                        }
                        continue;
                    }
                    try {
                        string = ((ScanResult)list.get((int)i2)).BSSID.replace(":", "");
                        stringBuilder.append(string.toUpperCase()).append(",");
                        stringBuilder2.append(((ScanResult)list.get((int)i2)).SSID).append(",");
                        stringBuilder3.append(((ScanResult)list.get((int)i2)).level).append(",");
                        stringBuilder4.append(System.currentTimeMillis() + "").append(",");
                        continue;
                    }
                    catch (Exception exception) {
                        LeLog.w(TAG, exception);
                    }
                }
                stringArray[0] = stringBuilder.toString();
                stringArray[1] = stringBuilder2.toString();
                stringArray[2] = stringBuilder3.toString();
                stringArray[3] = stringBuilder4.toString();
                return stringArray;
            }
        }
        return null;
    }

    public static boolean isWifiConnected(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.getType() == 1) {
                LeLog.i(TAG, "WIFI is connected");
                return true;
            }
            LeLog.i(TAG, "WIFI disconnected");
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static enum NetworkType {
        NETWORK_WIFI,
        NETWORK_4G,
        NETWORK_3G,
        NETWORK_2G,
        NETWORK_UNKNOWN,
        NETWORK_NO;

    }
}

