/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import android.util.Log;
import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.mirror.AutoStrategy;
import com.hpplay.component.protocol.mirror.VideoSender;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class VideoDataSendStrategy
extends Thread {
    private static final String TAG = "VideoDataSender";
    private static final int MAX_DATA_CUMULATION = 60;
    private VideoSender mVideoSender;
    private boolean isQuit;
    private final BlockingQueue<ByteBuffer> mVideoDataQueue = new LinkedBlockingQueue<ByteBuffer>(120);
    private final AutoStrategy mAutoStrategy;
    private final AtomicLong mTimeoutSignTime = new AtomicLong(0L);
    private IMirrorStateListener mStrategyListener;

    public VideoDataSendStrategy(VideoSender videoSender, IMirrorStateListener iMirrorStateListener, int n2) {
        this.setName(TAG);
        this.mVideoSender = videoSender;
        this.mStrategyListener = iMirrorStateListener;
        this.mVideoSender.setMirrorStateListener(iMirrorStateListener);
        this.mAutoStrategy = new AutoStrategy(iMirrorStateListener, n2);
    }

    public void setAutoBitrate(boolean bl) {
        if (this.mAutoStrategy != null) {
            this.mAutoStrategy.setAutoBitrate(bl);
        }
    }

    public void putVideoData(ByteBuffer byteBuffer) {
        try {
            if (!this.isQuit) {
                boolean bl = this.mVideoDataQueue.offer(byteBuffer);
                if (this.mAutoStrategy != null) {
                    this.mAutoStrategy.videoBufferSizeCheck(this.mVideoDataQueue.size(), 60);
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public boolean isWriteTimeout() {
        long l2 = this.mTimeoutSignTime.get();
        if (l2 == 0L) {
            return false;
        }
        long l3 = System.currentTimeMillis() - l2;
        boolean bl = l2 > 0L && l3 > 10000L;
        return bl;
    }

    public int getWritTimeout() {
        if (this.mTimeoutSignTime.get() == 0L) {
            return 0;
        }
        return (int)(System.currentTimeMillis() - this.mTimeoutSignTime.get());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block6: {
            try {
                while (!this.isQuit) {
                    ByteBuffer byteBuffer = this.mVideoDataQueue.take();
                    if (byteBuffer.get(127) == 1) {
                        Log.i((String)"ifprint", (String)"------------- > i frame ---- ");
                    }
                    byteBuffer.rewind();
                    this.mTimeoutSignTime.set(System.currentTimeMillis());
                    this.mVideoSender.sendData(byteBuffer);
                    this.mTimeoutSignTime.set(0L);
                    try {
                        if (this.mAutoStrategy == null || this.mVideoSender.getSendType() != 2) continue;
                        this.mAutoStrategy.writeDelayCheck(this.mVideoDataQueue.size());
                    }
                    catch (Exception exception) {
                        CLog.w(TAG, exception);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
                if (this.mStrategyListener == null || this.isQuit) break block6;
                this.mStrategyListener.onBroken();
            }
        }
        this.stopTask();
    }

    public boolean isQuit() {
        return this.isQuit;
    }

    public void stopTask() {
        this.interrupt();
        this.isQuit = true;
        CLog.i(TAG, "  send data  ------------>  stopTask ");
        this.mStrategyListener = null;
        this.mVideoSender = null;
        this.mVideoDataQueue.clear();
    }
}

