/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device.pincode;

import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.api.IConferenceMirrorListener;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.LelinkServiceInfoCreator;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.device.pincode.CodeParser;
import com.hpplay.sdk.source.device.pincode.IConferenceFuzzyMatchingPinCodeListener;
import com.hpplay.sdk.source.device.pincode.PinCodeInfo;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConferenceCodeParser
implements CodeParser {
    private static final String TAG = "ConferenceCodeParser";
    private IServiceInfoParseListener mListener;
    private IConferenceFuzzyMatchingPinCodeListener mFuzzyMatchingPinCodeListener;
    private LelinkServiceInfo mLelinkServiceInfo;
    private IConferenceMirrorListener mConferenceMirrorListener;
    private static final String PUSH_SETTINGS = "/conference/pushSettings?";
    private int agentPOrt = 30000;
    private static final String NEW_VERSION = "1.1";
    private static final String OLD_VERSION = "1.0";
    private String guestModePincode;

    @Override
    public void setCodeCallback(IServiceInfoParseListener iServiceInfoParseListener) {
        this.mListener = iServiceInfoParseListener;
    }

    @Override
    public void setConferenceFuzzyMatchingPinCodeCallback(IConferenceFuzzyMatchingPinCodeListener iConferenceFuzzyMatchingPinCodeListener) {
        this.mFuzzyMatchingPinCodeListener = iConferenceFuzzyMatchingPinCodeListener;
    }

    @Override
    public void parsePinCode(PinCodeInfo pinCodeInfo) {
        if (TextUtils.isEmpty((CharSequence)pinCodeInfo.pinCode)) {
            SourceLog.i(TAG, "parsePinCode pinCode is empty");
            if (null != this.mListener) {
                this.mListener.onParseResult(0, null);
            }
            return;
        }
        String string = pinCodeInfo.pinCode.trim();
        SourceLog.i(TAG, "parsePinCode trim:" + string + " length:" + string.length());
        if (pinCodeInfo.isFuzzyMatching) {
            this.parseFuzzyMatchingPinCode(pinCodeInfo);
        } else {
            this.parseDigitsOnlyPinCode(pinCodeInfo.pinCode);
        }
    }

    private String createToken(String string, String string2) {
        String string3 = ConferenceCodeParser.codeEncrypt(string + "_" + string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3.toLowerCase();
        }
        return "";
    }

    public static String codeEncrypt(String string) {
        try {
            String string2 = "lebo" + string;
            byte[] byArray = (byte[])ModuleLinker.getInstance().callMethod("A0ACD5D349DDA20884CA63779FD6FE1F", string2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (Integer.toHexString(0xFF & byArray[i2]).length() == 1) {
                    stringBuffer.append("0").append(Integer.toHexString(0xFF & byArray[i2]));
                    continue;
                }
                stringBuffer.append(Integer.toHexString(0xFF & byArray[i2]));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    private void parseDigitsOnlyPinCode(final String string) {
        String string2 = System.currentTimeMillis() + "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("code", string);
        hashMap.put("t", string2);
        hashMap.put("token", this.createToken(string, string2));
        hashMap.put("v", NEW_VERSION);
        String string3 = HapplayUtils.getMapParams(hashMap);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sConferenceCodeAuth, string3);
        asyncHttpParameter.in.requestHeaders = this.getHeaderParam();
        asyncHttpParameter.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                block15: {
                    if (asyncHttpParameter.out.resultType == 2) {
                        SourceLog.w(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode cancel request");
                        return;
                    }
                    SourceLog.debug(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode onRequestResult result:" + asyncHttpParameter.out.result);
                    if (asyncHttpParameter.out.resultType != 0) {
                        SourceLog.i(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode error: resultType not success");
                        if (null != ConferenceCodeParser.this.mListener) {
                            ConferenceCodeParser.this.mListener.onParseResult(5, null);
                        }
                        return;
                    }
                    String string2 = asyncHttpParameter.out.result;
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        SourceLog.i(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode error: response is empty");
                        if (null != ConferenceCodeParser.this.mListener) {
                            ConferenceCodeParser.this.mListener.onParseResult(5, null);
                        }
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject(string2);
                        int n2 = jSONObject.optInt("status");
                        if (n2 != 200) {
                            SourceLog.i(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode error: status not equals 200");
                            if (null != ConferenceCodeParser.this.mListener) {
                                ConferenceCodeParser.this.mListener.onParseResult(5, null);
                            }
                            return;
                        }
                        JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                        if (jSONObject2 == null || jSONObject2.length() <= 0) {
                            SourceLog.i(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode error: data is empty");
                            if (null != ConferenceCodeParser.this.mListener) {
                                ConferenceCodeParser.this.mListener.onParseResult(5, null);
                            }
                            return;
                        }
                        LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.getConferenceInfo(jSONObject2, string);
                        if (lelinkServiceInfo == null) {
                            SourceLog.i(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode error: parse info is null");
                            if (null != ConferenceCodeParser.this.mListener) {
                                ConferenceCodeParser.this.mListener.onParseResult(5, null);
                            }
                        } else if (null != ConferenceCodeParser.this.mListener) {
                            ConferenceCodeParser.this.mListener.onParseResult(1, lelinkServiceInfo);
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.i(ConferenceCodeParser.TAG, "parseDigitsOnlyPinCode error: response not json");
                        if (null == ConferenceCodeParser.this.mListener) break block15;
                        ConferenceCodeParser.this.mListener.onParseResult(5, null);
                    }
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private void parseFuzzyMatchingPinCode(PinCodeInfo pinCodeInfo) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("vals", pinCodeInfo.pinCode);
        hashMap.put("pageNum", String.valueOf(pinCodeInfo.page));
        hashMap.put("pageSize", String.valueOf(pinCodeInfo.cout));
        String string = HapplayUtils.getMapParams(hashMap);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sConferenceLikeEqAuth, string);
        asyncHttpParameter.in.requestHeaders = this.getHeaderParam();
        asyncHttpParameter.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                block17: {
                    if (asyncHttpParameter.out.resultType == 2) {
                        SourceLog.w(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode cancel request");
                        return;
                    }
                    SourceLog.debug(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode onRequestResult result:" + asyncHttpParameter.out.result);
                    if (asyncHttpParameter.out.resultType != 0) {
                        SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode error: resultType not success");
                        if (null != ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener) {
                            ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener.onParseResult(5, null);
                        }
                        return;
                    }
                    String string = asyncHttpParameter.out.result;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode error: response is empty");
                        if (null != ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener) {
                            ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener.onParseResult(5, null);
                        }
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject(string);
                        int n2 = jSONObject.optInt("status");
                        if (n2 != 200) {
                            SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode error: status not equals 200");
                            if (null != ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener) {
                                ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener.onParseResult(5, null);
                            }
                            return;
                        }
                        JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                        if (jSONObject2 == null || jSONObject2.length() <= 0) {
                            SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode error: data is empty");
                            if (null != ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener) {
                                ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener.onParseResult(5, null);
                            }
                            return;
                        }
                        int n3 = jSONObject2.optInt("total");
                        int n4 = jSONObject2.optInt("pageNum");
                        int n5 = jSONObject2.optInt("pageSize");
                        int n6 = jSONObject2.optInt("pages");
                        SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode total:" + n3 + " pageNum:" + n4 + " pageSize:" + n5 + " pages:" + n6);
                        JSONArray jSONArray = jSONObject2.optJSONArray("rows");
                        if (null == jSONArray) {
                            SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode error: rows is empty");
                            if (null != ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener) {
                                ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener.onParseResult(5, null);
                            }
                            return;
                        }
                        ArrayList<LelinkServiceInfo> arrayList = new ArrayList<LelinkServiceInfo>();
                        int n7 = jSONArray.length();
                        for (int i2 = 0; i2 < n7; ++i2) {
                            JSONObject jSONObject3 = jSONArray.optJSONObject(i2);
                            LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.getConferenceFuzzyMatchingInfo(jSONObject3);
                            if (null == lelinkServiceInfo) continue;
                            arrayList.add(lelinkServiceInfo);
                        }
                        if (arrayList.isEmpty()) {
                            SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode error: LelinkServiceInfo infos is empty");
                            if (null != ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener) {
                                ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener.onParseResult(5, null);
                            }
                            return;
                        }
                        if (null != ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener) {
                            ConferenceCodeParser.this.mFuzzyMatchingPinCodeListener.onParseResult(1, arrayList);
                        }
                    }
                    catch (Exception exception) {
                        SourceLog.i(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode error: response not json");
                        if (null == ConferenceCodeParser.this.mListener) break block17;
                        ConferenceCodeParser.this.mListener.onParseResult(5, null);
                    }
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    public void setGuestMode(LelinkServiceInfo lelinkServiceInfo, String string, String string2, IConferenceMirrorListener iConferenceMirrorListener) {
        this.mLelinkServiceInfo = lelinkServiceInfo;
        this.mConferenceMirrorListener = iConferenceMirrorListener;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("username", string);
        hashMap.put("password", string2);
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sConferenceVisitorAuth + "username=" + string + "&password=" + string2, null);
        asyncHttpParameter.in.requestMethod = 0;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.w(ConferenceCodeParser.TAG, "setGuestMode cancel request");
                    return;
                }
                try {
                    SourceLog.debug(ConferenceCodeParser.TAG, "setGuestMode  request" + asyncHttpParameter.out.result);
                    JSONObject jSONObject = new JSONObject(asyncHttpParameter.out.result);
                    if (jSONObject.getInt("status") == 200) {
                        JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                        String string = jSONObject2.getString("token");
                        ConferenceCodeParser.this.startSetGuestMode(string);
                    }
                    return;
                }
                catch (Exception exception) {
                    SourceLog.w(ConferenceCodeParser.TAG, exception);
                    if (ConferenceCodeParser.this.mConferenceMirrorListener != null) {
                        ConferenceCodeParser.this.mConferenceMirrorListener.onInfo(202, 2021);
                    }
                    return;
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    public void startSetGuestMode(String string) {
        String string2 = "ip=" + this.mLelinkServiceInfo.getIp() + "&agentPort=" + this.mLelinkServiceInfo.getAgentPort() + "&token=" + string;
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sConferenceSetGuestMode + string2, null);
        asyncHttpParameter.in.requestMethod = 0;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.w(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode cancel request");
                } else {
                    try {
                        SourceLog.debug(ConferenceCodeParser.TAG, "startSetGuestMode  request" + asyncHttpParameter.out.result);
                        JSONObject jSONObject = new JSONObject(asyncHttpParameter.out.result);
                        if (jSONObject.getInt("status") == 200 && ConferenceCodeParser.this.mConferenceMirrorListener != null) {
                            ConferenceCodeParser.this.mConferenceMirrorListener.onInfo(202, 2020);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        SourceLog.w(ConferenceCodeParser.TAG, exception);
                    }
                }
                if (ConferenceCodeParser.this.mConferenceMirrorListener != null) {
                    ConferenceCodeParser.this.mConferenceMirrorListener.onInfo(202, 2021);
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    public void resetGuestMode(String string, IConferenceMirrorListener iConferenceMirrorListener) {
        block2: {
            try {
                this.guestModePincode = string;
                String string2 = this.getGeustModeIp(Integer.valueOf(string));
                this.mConferenceMirrorListener = iConferenceMirrorListener;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("guestMode", (Object)"close");
                String string3 = "http://" + string2 + ":" + this.agentPOrt + PUSH_SETTINGS + "type=visitorAuth&data=" + jSONObject.toString();
                AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(string3, null);
                asyncHttpParameter.in.requestMethod = 1;
                asyncHttpParameter.in.connectTimeout = 3000;
                asyncHttpParameter.in.readTimeout = 2000;
                asyncHttpParameter.in.tryCount = 1;
                AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

                    @Override
                    public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                        if (asyncHttpParameter.out.resultType == 2) {
                            SourceLog.w(ConferenceCodeParser.TAG, "parseFuzzyMatchingPinCode cancel request");
                        } else {
                            try {
                                SourceLog.debug(ConferenceCodeParser.TAG, "startSetGuestMode  request  " + asyncHttpParameter.out.result);
                                JSONObject jSONObject = new JSONObject(asyncHttpParameter.out.result);
                                if (jSONObject.getInt("status") == 200) {
                                    ConferenceCodeParser.this.agentPOrt = 30000;
                                    if (ConferenceCodeParser.this.mConferenceMirrorListener != null) {
                                        ConferenceCodeParser.this.mConferenceMirrorListener.onInfo(202, 2022);
                                    }
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                SourceLog.w(ConferenceCodeParser.TAG, exception);
                            }
                        }
                        SourceLog.i(ConferenceCodeParser.TAG, "reset guest mode   failed");
                        if (ConferenceCodeParser.this.agentPOrt < 30003) {
                            ++ConferenceCodeParser.this.agentPOrt;
                            ConferenceCodeParser.this.resetGuestMode(ConferenceCodeParser.this.guestModePincode, ConferenceCodeParser.this.mConferenceMirrorListener);
                        } else {
                            ConferenceCodeParser.this.agentPOrt = 30000;
                            if (ConferenceCodeParser.this.mConferenceMirrorListener != null) {
                                ConferenceCodeParser.this.mConferenceMirrorListener.onInfo(202, 2023);
                            }
                        }
                    }
                };
                AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                if (this.mConferenceMirrorListener == null) break block2;
                this.mConferenceMirrorListener.onInfo(202, 2023);
            }
        }
    }

    private Map<String, String> getHeaderParam() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/x-www-form-urlencoded");
        return hashMap;
    }

    public void parseGuestPinCode(String string) {
        block4: {
            try {
                int n2 = Integer.valueOf(string);
                int n3 = n2 / 256 % 51 + 50000;
                String string2 = this.getGeustModeIp(n2);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("ip", (Object)string2);
                    jSONObject.put("linkPort", n3);
                    jSONObject.put("airplay_port", n3);
                    jSONObject.put("name", (Object)"\u8bbf\u5ba2\u6a21\u5f0f\u8bbe\u5907");
                    LelinkServiceInfo lelinkServiceInfo = LelinkServiceInfoCreator.getConferenceInfo(jSONObject, string);
                    if (this.mListener != null) {
                        this.mListener.onParseResult(1, lelinkServiceInfo);
                    }
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                if (this.mListener == null) break block4;
                this.mListener.onParseResult(0, null);
            }
        }
    }

    public String getGeustModeIp(int n2) {
        int n3 = n2 % 256;
        String string = HapplayUtils.getLoaclIp();
        String[] stringArray = string.split("\\.");
        string = stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + "." + n3;
        return string;
    }

    @Override
    public void release() {
    }
}

