/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.net;

import com.hpplay.component.common.utils.CLog;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class HostInterface {
    private static final String TAG = "hpplay-HostInterface";
    public static boolean USE_LOOPBACK_ADDR = false;
    public static boolean USE_ONLY_IPV4_ADDR = true;
    public static boolean USE_ONLY_IPV6_ADDR = false;
    private static String ifAddress = "";
    public static final int IPV4_BITMASK = 1;
    public static final int IPV6_BITMASK = 16;
    public static final int LOCAL_BITMASK = 256;

    public static final void setInterface(String string) {
        ifAddress = string;
    }

    public static final String getInterface() {
        return ifAddress;
    }

    private static final boolean hasAssignedInterface() {
        return 0 < ifAddress.length();
    }

    private static final boolean isUsableAddress(InetAddress inetAddress) {
        if (!USE_LOOPBACK_ADDR && inetAddress.isLoopbackAddress()) {
            return false;
        }
        if (USE_ONLY_IPV4_ADDR && inetAddress instanceof Inet6Address) {
            return false;
        }
        return !USE_ONLY_IPV6_ADDR || !(inetAddress instanceof Inet4Address);
    }

    public static final int getNHostAddresses() {
        if (HostInterface.hasAssignedInterface()) {
            return 1;
        }
        int n2 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!HostInterface.isUsableAddress(inetAddress)) continue;
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
        }
        return n2;
    }

    public static final InetAddress[] getInetAddress(int n2, String[] stringArray) {
        Enumeration<NetworkInterface> enumeration;
        Object object;
        AbstractList abstractList;
        if (stringArray != null) {
            abstractList = new Vector();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    object = NetworkInterface.getByName(stringArray[i2]);
                }
                catch (SocketException socketException) {
                    continue;
                }
                if (object == null) continue;
                ((Vector)abstractList).add(object);
            }
            enumeration = ((Vector)abstractList).elements();
        } else {
            try {
                enumeration = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException socketException) {
                return null;
            }
        }
        abstractList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            object = networkInterface.getInetAddresses();
            while (object.hasMoreElements()) {
                InetAddress inetAddress = (InetAddress)object.nextElement();
                if ((n2 & 0x100) == 0 && inetAddress.isLoopbackAddress()) continue;
                if ((n2 & 1) != 0 && inetAddress instanceof Inet4Address) {
                    ((ArrayList)abstractList).add(inetAddress);
                    continue;
                }
                if ((n2 & 0x10) == 0 || !(inetAddress instanceof InetAddress)) continue;
                ((ArrayList)abstractList).add(inetAddress);
            }
        }
        return ((ArrayList)abstractList).toArray(new InetAddress[0]);
    }

    public static final String getHostAddress(int n2) {
        if (HostInterface.hasAssignedInterface()) {
            return HostInterface.getInterface();
        }
        int n3 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!HostInterface.isUsableAddress(inetAddress)) continue;
                    if (n3 < n2) {
                        ++n3;
                        continue;
                    }
                    String string = inetAddress.getHostAddress();
                    return string;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static final boolean isIPv6Address(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress instanceof Inet6Address;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean isIPv4Address(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress instanceof Inet4Address;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean hasIPv4Addresses() {
        int n2 = HostInterface.getNHostAddresses();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = HostInterface.getHostAddress(i2);
            if (!HostInterface.isIPv4Address(string)) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasIPv6Addresses() {
        int n2 = HostInterface.getNHostAddresses();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = HostInterface.getHostAddress(i2);
            if (!HostInterface.isIPv6Address(string)) continue;
            return true;
        }
        return false;
    }

    public static final String getIPv4Address() {
        int n2 = HostInterface.getNHostAddresses();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = HostInterface.getHostAddress(i2);
            if (!HostInterface.isIPv4Address(string)) continue;
            return string;
        }
        return "";
    }

    public static final String getIPv6Address() {
        int n2 = HostInterface.getNHostAddresses();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = HostInterface.getHostAddress(i2);
            if (!HostInterface.isIPv6Address(string)) continue;
            return string;
        }
        return "";
    }

    public static final String getHostURL(String string, int n2, String string2) {
        String string3 = string;
        if (HostInterface.isIPv6Address(string)) {
            string3 = "[" + string + "]";
        }
        return "http://" + string3 + ":" + Integer.toString(n2) + string2;
    }
}

