/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import com.hpplay.sdk.source.bean.BrowserConfigBean;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import java.util.concurrent.LinkedBlockingQueue;

public class BrowserThread
extends Thread {
    private static final String TAG = "BrowserThread";
    private static final int BROWSER_START = 0;
    private static final int BROWSER_STOP = 1;
    private LinkedBlockingQueue<Integer> browserQeue = new LinkedBlockingQueue(2);
    private BrowserConfigBean configBean;
    private boolean isStart;

    public BrowserThread(BrowserConfigBean browserConfigBean) {
        this.configBean = browserConfigBean;
        this.isStart = true;
    }

    public void setConfigBean(BrowserConfigBean browserConfigBean) {
        this.configBean = browserConfigBean;
    }

    public void startBrowse() {
        try {
            this.browserQeue.add(0);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void stopBrowser() {
        try {
            this.browserQeue.add(1);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void release() {
        this.isStart = false;
        this.interrupt();
    }

    @Override
    public void run() {
        super.run();
        while (this.isStart) {
            try {
                int n2 = this.browserQeue.take();
                SourceLog.i(TAG, "browser flag => " + n2 + " b size " + this.browserQeue.size());
                if (n2 == 0) {
                    LelinkSdkManager.getInstance().stopBrowse();
                    LelinkSdkManager.getInstance().browse(this.configBean);
                    continue;
                }
                LelinkSdkManager.getInstance().stopBrowse();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                break;
            }
        }
    }
}

