/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.hpplay.glide.GenericRequestBuilder;
import com.hpplay.glide.Glide;
import com.hpplay.glide.gifdecoder.GifDecoder;
import com.hpplay.glide.load.Encoder;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.engine.DiskCacheStrategy;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.resource.NullEncoder;
import com.hpplay.glide.load.resource.gif.GifFrameModelLoader;
import com.hpplay.glide.load.resource.gif.GifFrameResourceDecoder;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.target.SimpleTarget;
import java.security.MessageDigest;
import java.util.UUID;

class GifFrameLoader {
    private final FrameCallback callback;
    private final GifDecoder gifDecoder;
    private final Handler handler;
    private boolean isRunning = false;
    private boolean isLoadPending = false;
    private GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> requestBuilder;
    private DelayTarget current;
    private boolean isCleared;

    public GifFrameLoader(Context context, FrameCallback frameCallback, GifDecoder gifDecoder, int n2, int n3) {
        this(frameCallback, gifDecoder, null, GifFrameLoader.getRequestBuilder(context, gifDecoder, n2, n3, Glide.get(context).getBitmapPool()));
    }

    GifFrameLoader(FrameCallback frameCallback, GifDecoder gifDecoder, Handler handler, GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> genericRequestBuilder) {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new FrameLoaderCallback());
        }
        this.callback = frameCallback;
        this.gifDecoder = gifDecoder;
        this.handler = handler;
        this.requestBuilder = genericRequestBuilder;
    }

    public void setFrameTransformation(Transformation<Bitmap> transformation) {
        if (transformation == null) {
            throw new NullPointerException("Transformation must not be null");
        }
        this.requestBuilder = this.requestBuilder.transform(transformation);
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.isCleared = false;
        this.loadNextFrame();
    }

    public void stop() {
        this.isRunning = false;
    }

    public void clear() {
        this.stop();
        if (this.current != null) {
            Glide.clear(this.current);
            this.current = null;
        }
        this.isCleared = true;
    }

    public Bitmap getCurrentFrame() {
        return this.current != null ? this.current.getResource() : null;
    }

    private void loadNextFrame() {
        if (!this.isRunning || this.isLoadPending) {
            return;
        }
        this.isLoadPending = true;
        this.gifDecoder.advance();
        long l2 = SystemClock.uptimeMillis() + (long)this.gifDecoder.getNextDelay();
        DelayTarget delayTarget = new DelayTarget(this.handler, this.gifDecoder.getCurrentFrameIndex(), l2);
        this.requestBuilder.signature(new FrameSignature()).into(delayTarget);
    }

    void onFrameReady(DelayTarget delayTarget) {
        if (this.isCleared) {
            this.handler.obtainMessage(2, (Object)delayTarget).sendToTarget();
            return;
        }
        DelayTarget delayTarget2 = this.current;
        this.current = delayTarget;
        this.callback.onFrameReady(delayTarget.index);
        if (delayTarget2 != null) {
            this.handler.obtainMessage(2, (Object)delayTarget2).sendToTarget();
        }
        this.isLoadPending = false;
        this.loadNextFrame();
    }

    private static GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> getRequestBuilder(Context context, GifDecoder gifDecoder, int n2, int n3, BitmapPool bitmapPool) {
        GifFrameResourceDecoder gifFrameResourceDecoder = new GifFrameResourceDecoder(bitmapPool);
        GifFrameModelLoader gifFrameModelLoader = new GifFrameModelLoader();
        Encoder encoder = NullEncoder.get();
        return Glide.with(context).using(gifFrameModelLoader, GifDecoder.class).load(gifDecoder).as(Bitmap.class).sourceEncoder(encoder).decoder(gifFrameResourceDecoder).skipMemoryCache(true).diskCacheStrategy(DiskCacheStrategy.NONE).override(n2, n3);
    }

    static class FrameSignature
    implements Key {
        private final UUID uuid;

        public FrameSignature() {
            this(UUID.randomUUID());
        }

        FrameSignature(UUID uUID) {
            this.uuid = uUID;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof FrameSignature) {
                FrameSignature frameSignature = (FrameSignature)object;
                return frameSignature.uuid.equals(this.uuid);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.uuid.hashCode();
        }

        @Override
        public void updateDiskCacheKey(MessageDigest messageDigest) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    static class DelayTarget
    extends SimpleTarget<Bitmap> {
        private final Handler handler;
        private final int index;
        private final long targetTime;
        private Bitmap resource;

        public DelayTarget(Handler handler, int n2, long l2) {
            this.handler = handler;
            this.index = n2;
            this.targetTime = l2;
        }

        public Bitmap getResource() {
            return this.resource;
        }

        @Override
        public void onResourceReady(Bitmap bitmap, GlideAnimation<? super Bitmap> glideAnimation) {
            this.resource = bitmap;
            Message message = this.handler.obtainMessage(1, (Object)this);
            this.handler.sendMessageAtTime(message, this.targetTime);
        }
    }

    private class FrameLoaderCallback
    implements Handler.Callback {
        public static final int MSG_DELAY = 1;
        public static final int MSG_CLEAR = 2;

        private FrameLoaderCallback() {
        }

        public boolean handleMessage(Message message) {
            if (message.what == 1) {
                DelayTarget delayTarget = (DelayTarget)message.obj;
                GifFrameLoader.this.onFrameReady(delayTarget);
                return true;
            }
            if (message.what == 2) {
                DelayTarget delayTarget = (DelayTarget)message.obj;
                Glide.clear(delayTarget);
            }
            return false;
        }
    }

    public static interface FrameCallback {
        public void onFrameReady(int var1);
    }
}

