/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.engine.EngineJobListener;
import com.hpplay.glide.load.engine.EngineResource;
import com.hpplay.glide.load.engine.EngineRunnable;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.request.ResourceCallback;
import com.hpplay.glide.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class EngineJob
implements EngineRunnable.EngineRunnableManager {
    private static final EngineResourceFactory DEFAULT_FACTORY = new EngineResourceFactory();
    private static final Handler MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper(), (Handler.Callback)new MainThreadCallback());
    private static final int MSG_COMPLETE = 1;
    private static final int MSG_EXCEPTION = 2;
    private final List<ResourceCallback> cbs = new ArrayList<ResourceCallback>();
    private final EngineResourceFactory engineResourceFactory;
    private final EngineJobListener listener;
    private final Key key;
    private final ExecutorService diskCacheService;
    private final ExecutorService sourceService;
    private final boolean isCacheable;
    private boolean isCancelled;
    private Resource<?> resource;
    private boolean hasResource;
    private Exception exception;
    private boolean hasException;
    private Set<ResourceCallback> ignoredCallbacks;
    private EngineRunnable engineRunnable;
    private EngineResource<?> engineResource;
    private volatile Future<?> future;

    public EngineJob(Key key, ExecutorService executorService, ExecutorService executorService2, boolean bl, EngineJobListener engineJobListener) {
        this(key, executorService, executorService2, bl, engineJobListener, DEFAULT_FACTORY);
    }

    public EngineJob(Key key, ExecutorService executorService, ExecutorService executorService2, boolean bl, EngineJobListener engineJobListener, EngineResourceFactory engineResourceFactory) {
        this.key = key;
        this.diskCacheService = executorService;
        this.sourceService = executorService2;
        this.isCacheable = bl;
        this.listener = engineJobListener;
        this.engineResourceFactory = engineResourceFactory;
    }

    public void start(EngineRunnable engineRunnable) {
        this.engineRunnable = engineRunnable;
        this.future = this.diskCacheService.submit(engineRunnable);
    }

    @Override
    public void submitForSource(EngineRunnable engineRunnable) {
        this.future = this.sourceService.submit(engineRunnable);
    }

    public void addCallback(ResourceCallback resourceCallback) {
        Util.assertMainThread();
        if (this.hasResource) {
            resourceCallback.onResourceReady(this.engineResource);
        } else if (this.hasException) {
            resourceCallback.onException(this.exception);
        } else {
            this.cbs.add(resourceCallback);
        }
    }

    public void removeCallback(ResourceCallback resourceCallback) {
        Util.assertMainThread();
        if (this.hasResource || this.hasException) {
            this.addIgnoredCallback(resourceCallback);
        } else {
            this.cbs.remove(resourceCallback);
            if (this.cbs.isEmpty()) {
                this.cancel();
            }
        }
    }

    private void addIgnoredCallback(ResourceCallback resourceCallback) {
        if (this.ignoredCallbacks == null) {
            this.ignoredCallbacks = new HashSet<ResourceCallback>();
        }
        this.ignoredCallbacks.add(resourceCallback);
    }

    private boolean isInIgnoredCallbacks(ResourceCallback resourceCallback) {
        return this.ignoredCallbacks != null && this.ignoredCallbacks.contains(resourceCallback);
    }

    void cancel() {
        if (this.hasException || this.hasResource || this.isCancelled) {
            return;
        }
        this.engineRunnable.cancel();
        Future<?> future = this.future;
        if (future != null) {
            future.cancel(true);
        }
        this.isCancelled = true;
        this.listener.onEngineJobCancelled(this, this.key);
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void onResourceReady(Resource<?> resource) {
        this.resource = resource;
        MAIN_THREAD_HANDLER.obtainMessage(1, (Object)this).sendToTarget();
    }

    private void handleResultOnMainThread() {
        if (this.isCancelled) {
            this.resource.recycle();
            return;
        }
        if (this.cbs.isEmpty()) {
            throw new IllegalStateException("Received a resource without any callbacks to notify");
        }
        this.engineResource = this.engineResourceFactory.build(this.resource, this.isCacheable);
        this.hasResource = true;
        this.engineResource.acquire();
        this.listener.onEngineJobComplete(this.key, this.engineResource);
        for (ResourceCallback resourceCallback : this.cbs) {
            if (this.isInIgnoredCallbacks(resourceCallback)) continue;
            this.engineResource.acquire();
            resourceCallback.onResourceReady(this.engineResource);
        }
        this.engineResource.release();
    }

    @Override
    public void onException(Exception exception) {
        this.exception = exception;
        MAIN_THREAD_HANDLER.obtainMessage(2, (Object)this).sendToTarget();
    }

    private void handleExceptionOnMainThread() {
        if (this.isCancelled) {
            return;
        }
        if (this.cbs.isEmpty()) {
            throw new IllegalStateException("Received an exception without any callbacks to notify");
        }
        this.hasException = true;
        this.listener.onEngineJobComplete(this.key, null);
        for (ResourceCallback resourceCallback : this.cbs) {
            if (this.isInIgnoredCallbacks(resourceCallback)) continue;
            resourceCallback.onException(this.exception);
        }
    }

    private static class MainThreadCallback
    implements Handler.Callback {
        private MainThreadCallback() {
        }

        public boolean handleMessage(Message message) {
            if (1 == message.what || 2 == message.what) {
                EngineJob engineJob = (EngineJob)message.obj;
                if (1 == message.what) {
                    engineJob.handleResultOnMainThread();
                } else {
                    engineJob.handleExceptionOnMainThread();
                }
                return true;
            }
            return false;
        }
    }

    static class EngineResourceFactory {
        EngineResourceFactory() {
        }

        public <R> EngineResource<R> build(Resource<R> resource, boolean bl) {
            return new EngineResource<R>(resource, bl);
        }
    }
}

