/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolBuilder;
import com.hpplay.component.protocol.encrypt.MirrorFrameEcrypto;
import com.hpplay.component.protocol.mirror.SpsParser;
import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LelinkRtpPacker {
    private static final String TAG = "LelinkRtpPacker";
    private static final int KEY_I_FRAME = 5;
    private static final int KEY_H265_I_FRAME = 19;
    private static final int FRAME_TYPE_INDEX = 127;
    private static final int KEY_SPS_PPS = 7;
    private static final int KEY_SPS = 32;
    private int mWidth = 1920;
    private int mHeight = 1080;
    private boolean isEncrypt = true;
    public byte[] mEncyptData;
    private byte[] byteBuffer = new byte[0x200000];
    private String mEncodeType;

    public void setEncodeType(String string) {
        this.mEncodeType = string;
    }

    public ByteBuffer videoDataPacked(ByteBuffer byteBuffer, MirrorFrameEcrypto mirrorFrameEcrypto, int n2, long l2) {
        if (n2 == 7 || n2 == 32) {
            CLog.i(TAG, "frameFlag ====> " + n2);
            return this.packSpsPpsData(byteBuffer);
        }
        int n3 = byteBuffer.remaining();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(128).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(4);
        byte[] byArray = new byte[n3 - 4];
        byteBuffer.get(byArray, 0, byArray.length);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(n3 + 128).order(ByteOrder.BIG_ENDIAN);
        byteBuffer2.position(0);
        byteBuffer2.putInt(n3);
        byteBuffer2.putShort((short)0);
        byteBuffer2.putShort((short)262);
        this.putTimestamp(byteBuffer2, l2);
        byteBuffer2.putFloat(this.mWidth);
        byteBuffer2.putFloat(this.mHeight);
        byteBuffer2.put(127, (byte)(n2 == 5 || n2 == 19 ? 1 : 0));
        byteBuffer2.position(0);
        byteBuffer2.limit(byteBuffer2.capacity());
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.putInt(byArray.length);
        byteBuffer2.clear();
        if (n2 != 5 && n2 != 19 || !this.isEncrypt) {
            byteBuffer3.put(byArray);
            byteBuffer3.position(0);
        } else {
            if (this.mEncyptData == null) {
                this.mEncyptData = new byte[0x200000];
            }
            System.arraycopy(byArray, 0, this.mEncyptData, 0, byArray.length);
            int n4 = (n3 - 5) / 32 * 16;
            mirrorFrameEcrypto.frameEncrypt(this.mEncyptData, 1, n4, this.mEncyptData, 1);
            byteBuffer3.put(this.mEncyptData, 0, byArray.length);
            byteBuffer3.flip();
        }
        return byteBuffer3;
    }

    public ByteBuffer getHeartbeatData() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(128).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        byteBuffer.putInt(0);
        byteBuffer.put((byte)5);
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)262);
        long l2 = System.nanoTime() / 1000L;
        this.putTimestamp(byteBuffer, l2);
        byteBuffer.putFloat(this.mWidth);
        byteBuffer.putFloat(this.mHeight);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public ByteBuffer packetOldLelinkFrameInfoData(String string) {
        byte[] byArray = BinaryPropertyListWriter.writeToArray(this.createStreamPlist(string));
        String string2 = new ProtocolBuilder().getStreamPortCmd().setContentType("application/octet-stream").setAplleDevid(string).setUserAgent("AirPlay/150.33").setContentLength(byArray.length + "").getString(true);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(string2.length() + byArray.length);
        byteBuffer.put(string2.getBytes());
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        String string3 = new String(byArray, 0, byArray.length);
        CLog.i(TAG, "sarrayOfByte1=" + string3);
        return byteBuffer;
    }

    public void setEncrypt() {
        this.isEncrypt = true;
    }

    private ByteBuffer packSpsPpsData(ByteBuffer byteBuffer) {
        Object object;
        byte[] byArray;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(128).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(0);
        int n2 = byteBuffer.remaining();
        byteBuffer.get(this.byteBuffer, 0, n2);
        byte[] byArray2 = new byte[4];
        if (this.mEncodeType.equals("video/avc")) {
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (i2 <= 0 || this.byteBuffer[i2] != 0 || this.byteBuffer[i2 + 1] != 0 || this.byteBuffer[i2 + 2] != 0 || this.byteBuffer[i2 + 3] != 1) continue;
                n3 = i2;
                break;
            }
            byArray = new byte[n3];
            byArray2 = new byte[n2 - n3];
            System.arraycopy(this.byteBuffer, 0, byArray, 0, byArray.length);
            System.arraycopy(this.byteBuffer, byArray.length, byArray2, 0, byArray2.length);
            try {
                object = SpsParser.getSizeFromSps(byArray);
                this.mWidth = (int)object[0];
                this.mHeight = (int)object[1];
                if (this.mHeight > 1080) {
                    this.mHeight = 1080;
                }
                CLog.i(TAG, "  width " + (int)object[0] + " height " + (int)object[1]);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        } else {
            byArray = new byte[n2];
            System.arraycopy(this.byteBuffer, 0, byArray, 0, byArray.length);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)object).write(1);
            ((DataOutputStream)object).write(byArray[5]);
            ((DataOutputStream)object).write(byArray[6]);
            ((DataOutputStream)object).write(byArray[7]);
            ((DataOutputStream)object).write(255);
            ((DataOutputStream)object).write(225);
            ((DataOutputStream)object).writeShort(-4 + byArray.length);
            ((DataOutputStream)object).write(byArray, 4, -4 + byArray.length);
            ((DataOutputStream)object).write(1);
            ((DataOutputStream)object).writeShort(-4 + byArray2.length);
            ((DataOutputStream)object).write(byArray2, 4, -4 + byArray2.length);
            ((DataOutputStream)object).flush();
            this.addHeaderBits(byteBuffer2);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            byteBuffer2.position(0);
            byteBuffer2.putInt(byArray3.length);
            byteBuffer2.putShort((short)1);
            byteBuffer2.putShort((short)262);
            this.putTimestamp(byteBuffer2, 0L);
            byteBuffer2.putFloat(this.mWidth);
            byteBuffer2.putFloat(this.mHeight);
            byteBuffer2.position(0);
            byteBuffer2.limit(byteBuffer2.capacity());
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(byteBuffer2.remaining() + byArray3.length);
            byteBuffer3.put(byteBuffer2);
            byteBuffer3.put(byArray3);
            byteBuffer3.position(0);
            return byteBuffer3;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
    }

    public void putTimestamp(ByteBuffer byteBuffer, long l2) {
        assert (byteBuffer.position() == 8);
        long l3 = l2 / 1000L / 1000L;
        long l4 = 0xFFFFFFFFFFFFFFFFL & (long)(4294.967296 * (double)(l2 % 1000000L));
        byteBuffer.putInt((int)(l4 |= l3 << 32));
        byteBuffer.putInt((int)l3);
    }

    private NSDictionary createStreamPlist(String string) {
        NSDictionary nSDictionary = new NSDictionary();
        nSDictionary.put("deviceId", (Object)string);
        nSDictionary.put("latencyMs", (Object)90L);
        nSDictionary.put("sessionID", (Object)12345678L);
        nSDictionary.put("version", (Object)"150.33");
        NSObject[] nSObjectArray = new NSObject[]{this.createDictEntry("SubS"), this.createDictEntry("B4En"), this.createDictEntry("EnDp"), this.createDictEntry("IdEn"), this.createDictEntry("IdDp"), this.createDictEntry("EQDp"), this.createDictEntry("QueF"), this.createDictEntry("Sent")};
        nSDictionary.put("fpsInfo", new NSArray(nSObjectArray));
        NSObject[] nSObjectArray2 = new NSObject[]{this.createDictEntry("SubSu"), this.createDictEntry("BePxT"), this.createDictEntry("AfPxT"), this.createDictEntry("BefEn"), this.createDictEntry("EmEnc"), this.createDictEntry("QueFr"), this.createDictEntry("SndFr")};
        nSDictionary.put("timestampInfo", new NSArray(nSObjectArray2));
        return nSDictionary;
    }

    private NSDictionary createDictEntry(String string) {
        NSDictionary nSDictionary = new NSDictionary();
        nSDictionary.put("name", (Object)string);
        return nSDictionary;
    }

    public void addHeaderBits(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        byteBuffer.putInt(0);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)4);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putFloat(this.mWidth);
        byteBuffer.putFloat(this.mHeight);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putFloat(this.mWidth);
        byteBuffer.putFloat(this.mHeight);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
    }
}

