/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.bitmap_recycle;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.Log;
import com.hpplay.glide.load.engine.bitmap_recycle.AttributeStrategy;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.hpplay.glide.load.engine.bitmap_recycle.SizeConfigStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LruBitmapPool
implements BitmapPool {
    private static final String TAG = "LruBitmapPool";
    private static final Bitmap.Config DEFAULT_CONFIG = Bitmap.Config.ARGB_8888;
    private final LruPoolStrategy strategy;
    private final Set<Bitmap.Config> allowedConfigs;
    private final int initialMaxSize;
    private final BitmapTracker tracker;
    private int maxSize;
    private int currentSize;
    private int hits;
    private int misses;
    private int puts;
    private int evictions;

    LruBitmapPool(int n2, LruPoolStrategy lruPoolStrategy, Set<Bitmap.Config> set) {
        this.initialMaxSize = n2;
        this.maxSize = n2;
        this.strategy = lruPoolStrategy;
        this.allowedConfigs = set;
        this.tracker = new NullBitmapTracker();
    }

    public LruBitmapPool(int n2) {
        this(n2, LruBitmapPool.getDefaultStrategy(), LruBitmapPool.getDefaultAllowedConfigs());
    }

    public LruBitmapPool(int n2, Set<Bitmap.Config> set) {
        this(n2, LruBitmapPool.getDefaultStrategy(), set);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public synchronized void setSizeMultiplier(float f2) {
        this.maxSize = Math.round((float)this.initialMaxSize * f2);
        this.evict();
    }

    @Override
    public synchronized boolean put(Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("Bitmap must not be null");
        }
        if (!bitmap.isMutable() || this.strategy.getSize(bitmap) > this.maxSize || !this.allowedConfigs.contains(bitmap.getConfig())) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)("Reject bitmap from pool, bitmap: " + this.strategy.logBitmap(bitmap) + ", is mutable: " + bitmap.isMutable() + ", is allowed config: " + this.allowedConfigs.contains(bitmap.getConfig())));
            }
            return false;
        }
        int n2 = this.strategy.getSize(bitmap);
        this.strategy.put(bitmap);
        this.tracker.add(bitmap);
        ++this.puts;
        this.currentSize += n2;
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Put bitmap in pool=" + this.strategy.logBitmap(bitmap)));
        }
        this.dump();
        this.evict();
        return true;
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }

    @Override
    public synchronized Bitmap get(int n2, int n3, Bitmap.Config config) {
        Bitmap bitmap = this.getDirty(n2, n3, config);
        if (bitmap != null) {
            bitmap.eraseColor(0);
        }
        return bitmap;
    }

    @Override
    @TargetApi(value=12)
    public synchronized Bitmap getDirty(int n2, int n3, Bitmap.Config config) {
        Bitmap bitmap = this.strategy.get(n2, n3, config != null ? config : DEFAULT_CONFIG);
        if (bitmap == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Missing bitmap=" + this.strategy.logBitmap(n2, n3, config)));
            }
            ++this.misses;
        } else {
            ++this.hits;
            this.currentSize -= this.strategy.getSize(bitmap);
            this.tracker.remove(bitmap);
            if (Build.VERSION.SDK_INT >= 12) {
                bitmap.setHasAlpha(true);
            }
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Get bitmap=" + this.strategy.logBitmap(n2, n3, config)));
        }
        this.dump();
        return bitmap;
    }

    @Override
    public void clearMemory() {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"clearMemory");
        }
        this.trimToSize(0);
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int n2) {
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("trimMemory, level=" + n2));
        }
        if (n2 >= 60) {
            this.clearMemory();
        } else if (n2 >= 40) {
            this.trimToSize(this.maxSize / 2);
        }
    }

    private synchronized void trimToSize(int n2) {
        while (this.currentSize > n2) {
            Bitmap bitmap = this.strategy.removeLast();
            if (bitmap == null) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)"Size mismatch, resetting");
                    this.dumpUnchecked();
                }
                this.currentSize = 0;
                return;
            }
            this.tracker.remove(bitmap);
            this.currentSize -= this.strategy.getSize(bitmap);
            bitmap.recycle();
            ++this.evictions;
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Evicting bitmap=" + this.strategy.logBitmap(bitmap)));
            }
            this.dump();
        }
    }

    private void dump() {
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.dumpUnchecked();
        }
    }

    private void dumpUnchecked() {
        Log.v((String)TAG, (String)("Hits=" + this.hits + ", misses=" + this.misses + ", puts=" + this.puts + ", evictions=" + this.evictions + ", currentSize=" + this.currentSize + ", maxSize=" + this.maxSize + "\nStrategy=" + this.strategy));
    }

    private static LruPoolStrategy getDefaultStrategy() {
        LruPoolStrategy lruPoolStrategy = Build.VERSION.SDK_INT >= 19 ? new SizeConfigStrategy() : new AttributeStrategy();
        return lruPoolStrategy;
    }

    private static Set<Bitmap.Config> getDefaultAllowedConfigs() {
        HashSet<Bitmap.Config> hashSet = new HashSet<Bitmap.Config>();
        hashSet.addAll(Arrays.asList(Bitmap.Config.values()));
        if (Build.VERSION.SDK_INT >= 19) {
            hashSet.add(null);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static class NullBitmapTracker
    implements BitmapTracker {
        private NullBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap) {
        }

        @Override
        public void remove(Bitmap bitmap) {
        }
    }

    private static class ThrowingBitmapTracker
    implements BitmapTracker {
        private final Set<Bitmap> bitmaps = Collections.synchronizedSet(new HashSet());

        private ThrowingBitmapTracker() {
        }

        @Override
        public void add(Bitmap bitmap) {
            if (this.bitmaps.contains(bitmap)) {
                throw new IllegalStateException("Can't add already added bitmap: " + bitmap + " [" + bitmap.getWidth() + "x" + bitmap.getHeight() + "]");
            }
            this.bitmaps.add(bitmap);
        }

        @Override
        public void remove(Bitmap bitmap) {
            if (!this.bitmaps.contains(bitmap)) {
                throw new IllegalStateException("Cannot remove bitmap not in tracker");
            }
            this.bitmaps.remove(bitmap);
        }
    }

    private static interface BitmapTracker {
        public void add(Bitmap var1);

        public void remove(Bitmap var1);
    }
}

