/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.log.LeLog;
import com.hpplay.common.utils.FieldUtil;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IPushController;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.PassBean;
import com.hpplay.sdk.source.bean.StopInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.protocol.AbsBridge;
import com.hpplay.sdk.source.protocol.DLNABridge;
import com.hpplay.sdk.source.protocol.LelinkProtocolListener;
import com.hpplay.sdk.source.protocol.connect.AbsConnectBridge;
import com.hpplay.sdk.source.utils.CastUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;

public class LelinkPushBridge
extends AbsBridge {
    protected static String TAG = "LelinkPushBridge";
    private static final int DELAY_UPDATE_POSITION = 1000;
    private static final int DELAY_WHEN_BACKGROUND_UPDATE_POSITION = 10000;
    private static final int DELAY_PLAY = 3000;
    private static final int MSG_DELAY_PLAY = 200;
    private static final int DELAY_UPDATE_STATE = 2000;
    private static final int DELAY_COMPLETE = 4000;
    private static final int ARG_PUSH_ERROR = 0;
    private static final int ARG_PUSH_SUCCESS = 1;
    private static final int ARG_PUSH_SHOW_CAST_CODE = 2;
    private static int DELAY_STOPPED = 2000;
    protected boolean isCallPrepared = false;
    private ModuleLinker mModuleLinker;
    protected IPushController mPushController;
    private int mPositionCount = -1;
    private String mDlnaUUID = null;
    private boolean isReleased = false;
    private static final String DLNA_STATE_PLAYING = "playing";
    private static final String DLNA_STATE_PAUSE = "paused";
    private static final String DLNA_STATE_STOPPED = "stopped";
    protected int mDuration;
    private int mPosition;
    private long mLastPlayPosition = 0L;
    private long mLastPlayDuration = 0L;
    protected boolean isJGTP = false;
    private String mPreDLNAStopUrl = null;
    private String mReportPrepareDramaId = null;
    private boolean isUpdatePosition = false;
    private long mDlnaGetPlayStateTime = 0L;
    private LelinkProtocolListener mPlayerListener = new LelinkProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            if (LelinkPushBridge.this.isReleased) {
                return;
            }
            LelinkPushBridge.this.resolveProtocolInfo(n2, stringArray);
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            try {
                if (message.what == 200) {
                    LelinkPushBridge.this.startPush();
                    return true;
                }
                LelinkPushBridge.this.handleMsg(message);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            return false;
        }
    });
    private final Runnable mPositionRunnable = new Runnable(){

        @Override
        public void run() {
            if (LelinkPushBridge.this.mPushController == null) {
                return;
            }
            LelinkPushBridge.this.mPushController.getPlayInfo();
            if (LelinkPushBridge.this.isAppResume) {
                LelinkPushBridge.this.mHandler.postDelayed((Runnable)this, 1000L);
            } else if (LelinkPushBridge.this.getRemainProgress() > 60) {
                LelinkPushBridge.this.mHandler.postDelayed((Runnable)this, 10000L);
            } else {
                LelinkPushBridge.this.mHandler.postDelayed((Runnable)this, 1000L);
            }
        }
    };
    private String mDlnaPreState = "";
    private final Runnable mDlnaStateRunnable = new Runnable(){

        @Override
        public void run() {
            if (LelinkPushBridge.this.mPushController == null) {
                return;
            }
            LelinkPushBridge.this.mPushController.getStateInfo();
            LelinkPushBridge.this.mHandler.postDelayed((Runnable)this, 2000L);
        }
    };
    AbsConnectBridge.OnPassSendCompleteListener onPassReceivedListener = new AbsConnectBridge.OnPassSendCompleteListener(){

        @Override
        public void onPassReversed(PassBean passBean) {
            LeLog.i(TAG, " >>>> " + passBean.cmd + " passBean  " + passBean.result);
            if (passBean.cmd == 2) {
                LelinkPushBridge.this.mHandler.removeMessages(200);
                LelinkPushBridge.this.startPush();
            }
        }
    };

    public LelinkPushBridge(Context context, OutParameter outParameter) {
        super(context, outParameter);
        this.mPlayInfo = outParameter;
        try {
            if (this.mPushController == null) {
                this.mModuleLinker = ModuleLinker.getNewInstance();
                this.mPushController = (IPushController)this.mModuleLinker.loadModule("3B5B9CF21B1389F9929454313D455A51");
                this.mPushController.setProtocolListener(this.mPlayerListener);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void play(String string) {
        if (this.mPushController == null) {
            SourceLog.w(TAG, "play ignore");
            return;
        }
        if (ConnectManager.getInstance().getLastConnectBridge() != null) {
            this.mPushController.setConnector(ConnectManager.getInstance().getLastConnectBridge().getConnector());
            ConnectManager.getInstance().getLastConnectBridge().addOnPassSendCompleteListener(this, this.onPassReceivedListener);
        }
        if (CastUtil.isSupportLelinkV2(this.mPlayInfo.serviceInfo)) {
            if (this.mPlayInfo.playerInfoBean != null && !this.mPlayInfo.playerInfoBean.isEmpty()) {
                this.mPlayInfo.playerInfoBean.setUri(this.mPlayInfo.urlID);
                PassSender.getInstance().sendPlayerInfo(this.mPlayInfo.playerInfoBean, this.mPlayInfo.session);
            }
            if (this.mPlayInfo.mediaAssetBean != null && !this.mPlayInfo.mediaAssetBean.isEmpty()) {
                this.mPlayInfo.mediaAssetBean.setUri(this.mPlayInfo.urlID);
                this.mHandler.sendEmptyMessageDelayed(200, 3000L);
                PassSender.getInstance().sendMediaAssets(this.mPlayInfo.mediaAssetBean, this.mPlayInfo.session);
                return;
            }
        }
        this.startPush();
    }

    void startPush() {
        BrowserInfo browserInfo = this.mPlayInfo.currentBrowserInfo;
        if (browserInfo == null) {
            SourceLog.w(TAG, "play ignore, invalid browser info");
            return;
        }
        this.isCallPrepared = false;
        this.mDuration = this.mPlayInfo.duration;
        String string = "";
        if (this.mPlayInfo.serviceInfo != null) {
            string = this.mPlayInfo.serviceInfo.getName();
        }
        SourceLog.i(TAG, "play " + this.mPlayInfo.getPlayUrl() + " to " + string + "/" + this);
        ParamsMap paramsMap = ParamsMap.create();
        paramsMap.putParam("uid", Session.getInstance().getUID());
        paramsMap.putParam("hid", Session.getInstance().getHID());
        String string2 = FieldUtil.getString(FieldUtil.m);
        Session.getInstance();
        paramsMap.putParam(string2, "02:00:00:00:00:00");
        paramsMap.putParam("imei", "");
        paramsMap.putParam("sink_name", string);
        paramsMap.putParam("sessionId", this.mPlayInfo.session);
        paramsMap.putParam("sessionId", this.mPlayInfo.session);
        paramsMap.putParam("connectSessionId", this.mPlayInfo.connectSession);
        paramsMap.putParam("start_postion", this.mPlayInfo.startPosition);
        paramsMap.putParam("uri", this.mPlayInfo.urlID);
        paramsMap.putParam("mediatype", this.mPlayInfo.mimeType + "");
        paramsMap.putParam("protocol_type", this.mPlayInfo.protocol);
        if (!TextUtils.isEmpty((CharSequence)this.mPlayInfo.password)) {
            paramsMap.putParam("screencode", this.mPlayInfo.password);
        }
        try {
            if (CastUtil.isSupportLelinkV2(browserInfo)) {
                paramsMap.putParam("protocol_type", 5);
                paramsMap.putParam("vv", "2");
                paramsMap.putParam("lelink_port", browserInfo.getExtras().get("lelinkport") + "");
            } else {
                paramsMap.putParam("lelink_port", browserInfo.getExtras().get("airplay") + "");
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        paramsMap.putParam("ip", browserInfo.getIp());
        SourceLog.debug(TAG, "play " + paramsMap.toString());
        try {
            if (this.mPlayInfo.urls != null && this.mPlayInfo.urls.length > 0) {
                SourceLog.i(TAG, "setPlayList");
                this.setPlayListParams(paramsMap, this.mPlayInfo.urls, this.mPlayInfo.period, this.mPlayInfo.headLength, this.mPlayInfo.tailLength);
                this.mPushController.setPlayList(paramsMap);
            } else {
                SourceLog.debug(TAG, "play ");
                this.mPushController.push(this.mPlayInfo.getPlayUrl(), paramsMap);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void setPlayListParams(ParamsMap paramsMap, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        try {
            paramsMap.putParam("period", n2);
            paramsMap.putParam("curplayid", this.mPlayInfo.dramaID);
            paramsMap.putParam("headduration", n3);
            paramsMap.putParam("tailduration", n4);
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            int n5 = 0;
            for (int i2 = 0; i2 < dramaInfoBeanArray.length; ++i2) {
                DramaInfoBean.UrlBean[] urlBeanArray;
                DramaInfoBean dramaInfoBean = dramaInfoBeanArray[i2];
                if (dramaInfoBean == null || (urlBeanArray = dramaInfoBean.urls) == null) continue;
                JSONObject jSONObject2 = new JSONObject();
                if (!TextUtils.isEmpty((CharSequence)dramaInfoBean.name)) {
                    try {
                        dramaInfoBean.name = URLEncoder.encode(dramaInfoBean.name, "utf-8");
                    }
                    catch (Exception exception) {
                        SourceLog.w(TAG, "setPlayListParams :" + exception);
                    }
                }
                jSONObject2.put("name", (Object)dramaInfoBean.name);
                JSONArray jSONArray2 = new JSONArray();
                int n6 = 0;
                for (int i3 = 0; i3 < urlBeanArray.length; ++i3) {
                    DramaInfoBean.UrlBean urlBean = urlBeanArray[i3];
                    if (urlBean == null) continue;
                    JSONObject jSONObject3 = new JSONObject();
                    jSONObject3.put("height", urlBean.height);
                    jSONObject3.put("width", urlBean.width);
                    jSONObject3.put("playid", (Object)urlBean.id);
                    if (!TextUtils.isEmpty((CharSequence)urlBean.url)) {
                        try {
                            urlBean.url = URLEncoder.encode(urlBean.url, "utf-8");
                        }
                        catch (Exception exception) {
                            SourceLog.w(TAG, "setPlayListParams :" + exception);
                        }
                    }
                    jSONObject3.put("url", (Object)urlBean.url);
                    jSONObject3.put("category", (Object)urlBean.category);
                    jSONArray2.put(n6++, (Object)jSONObject3);
                }
                jSONObject2.put("urls", (Object)jSONArray2);
                jSONArray.put(n5++, (Object)jSONObject2);
            }
            jSONObject.put("playlist", (Object)jSONArray);
            paramsMap.putParam("playlist", jSONObject);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "getPlayListParams error:" + exception.getMessage());
        }
    }

    @Override
    public void resume(String string) {
        if (this.mPushController == null) {
            SourceLog.w(TAG, "resume ignore");
            return;
        }
        this.mPushController.resume();
    }

    @Override
    public void pause(String string) {
        if (this.mPushController == null) {
            SourceLog.w(TAG, "pause ignore");
            return;
        }
        this.mPushController.pause();
    }

    @Override
    public void playDrama(String string, String string2) {
        SourceLog.i(TAG, "playDrama :" + string2);
        if (this.mPushController == null) {
            SourceLog.w(TAG, "playDrama ignore");
            return;
        }
        ParamsMap paramsMap = new ParamsMap();
        paramsMap.putParam("curplayid", string2);
        paramsMap.putParam("width", 0);
        paramsMap.putParam("height", 0);
        this.mPushController.selectPlay(paramsMap);
    }

    @Override
    public void playNextDrama(String string) {
        SourceLog.i(TAG, "playNextDrama");
        if (this.mPushController == null) {
            SourceLog.w(TAG, "playNextDrama ignore");
            return;
        }
        this.mPushController.playNext();
    }

    @Override
    public void playPreDrama(String string) {
        SourceLog.i(TAG, "playPreDrama");
        if (this.mPushController == null) {
            SourceLog.w(TAG, "playPreDrama ignore");
            return;
        }
        this.mPushController.playPrevious();
    }

    @Override
    public void appendPlayList(String string, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        SourceLog.i(TAG, "appendPlayList");
        if (this.mPushController == null) {
            SourceLog.w(TAG, "appendPlayList ignore");
            return;
        }
        if (dramaInfoBeanArray == null || dramaInfoBeanArray.length <= 0) {
            SourceLog.w(TAG, "appendPlayList ignore list invalid");
            return;
        }
        try {
            ParamsMap paramsMap = new ParamsMap();
            this.setPlayListParams(paramsMap, dramaInfoBeanArray, n2, n3, n4);
            this.mPushController.addPlayList(paramsMap);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "appendPlayList error:" + exception.getMessage());
        }
    }

    @Override
    public void clearPlayList(String string) {
        SourceLog.i(TAG, "clearPlayList");
        if (this.mPushController == null) {
            SourceLog.w(TAG, "clearPlayList ignore");
            return;
        }
        this.mPushController.clearPlayList();
    }

    @Override
    public void seekTo(int n2) {
        if (this.mPushController == null) {
            SourceLog.w(TAG, "seekTo ignore");
            return;
        }
        SourceLog.i(TAG, "seekTo: second := " + n2);
        this.mPushController.seekTo(n2);
    }

    @Override
    public void addVolume() {
        super.addVolume();
        if (this.mPushController == null) {
            SourceLog.w(TAG, "addVolume ignore");
            return;
        }
        SourceLog.i(TAG, "addVolume");
        this.mPushController.increaseVolume();
    }

    @Override
    public void subVolume() {
        super.subVolume();
        if (this.mPushController == null) {
            SourceLog.w(TAG, "subVolume ignore");
            return;
        }
        SourceLog.i(TAG, "subVolume");
        this.mPushController.decreaseVolume();
    }

    @Override
    public void setVolume(int n2) {
        super.setVolume(n2);
    }

    @Override
    public void selectAudiotrack(int n2) {
        if (this.mPushController == null) {
            SourceLog.w(TAG, "selectAudiotrack ignore");
            return;
        }
        SourceLog.i(TAG, "selectAudiotrack index = " + n2);
        this.mPushController.selectAudiotrack(n2);
    }

    @Override
    public void stop(String string) {
        if (this.mPushController == null) {
            SourceLog.w(TAG, "stop ignore");
            return;
        }
        this.mPushController.setConnector(null);
        this.mPushController.stopPlay();
        this.cancelPositionUpdate();
        this.cancelStateUpdate();
        this.mLastPlayPosition = 0L;
        this.mLastPlayDuration = 0L;
        ConnectManager.getInstance().getLastConnectBridge().removeOnPassSendCompleteListener(this);
    }

    private void resolveProtocolInfo(int n2, String ... stringArray) {
        SourceLog.i(TAG, "====resolveProtocolInfo cmd " + n2 + "," + Arrays.toString(stringArray));
        switch (n2) {
            case 1: {
                this.printResult("CMD_PUSH ", stringArray);
                this.mHandler.removeMessages(16);
                if (stringArray.length < 1) {
                    SourceLog.i(TAG, "push error");
                    this.mHandler.obtainMessage(1, 0, 0).sendToTarget();
                    break;
                }
                SourceLog.i(TAG, "push " + stringArray[0]);
                if ("successful".equals(stringArray[0])) {
                    this.mHandler.sendMessage(Message.obtain(null, (int)1, (int)1, (int)0, (Object)stringArray[1]));
                    this.updatePosition();
                    break;
                }
                if ("603".equals(stringArray[0])) {
                    SourceLog.w(TAG, "CMD_PUSH need cast code");
                    this.mHandler.obtainMessage(1, 2, -1).sendToTarget();
                    break;
                }
                this.mHandler.sendMessage(Message.obtain(null, (int)1, (int)0, (int)0, (Object)stringArray[1]));
                break;
            }
            case 2: {
                this.mHandler.sendEmptyMessage(15);
                break;
            }
            case 3: {
                this.updatePosition();
                break;
            }
            case 4: {
                this.updatePosition();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.mHandler.sendEmptyMessage(16);
                this.cancelPositionUpdate();
                break;
            }
            case 8: {
                this.updateDramaIdOnCallback(n2, stringArray);
                this.notifyPosition(stringArray);
                break;
            }
            case 17: {
                this.notifyPosition(stringArray);
                break;
            }
            case 9: {
                if (stringArray.length < 1) {
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)stringArray[0])) {
                    return;
                }
                String string = stringArray[0];
                if (DLNA_STATE_PLAYING.equals(string) && this.mHandler.hasMessages(16)) {
                    SourceLog.w(TAG, "CMD_GET_STATEINFO there has a stop msg,remove it");
                    this.mHandler.removeMessages(16);
                }
                if (TextUtils.equals((CharSequence)this.mDlnaPreState, (CharSequence)string)) break;
                this.callbackDlnaStateChanged(string);
                this.mDlnaPreState = string;
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                this.printResult("CMD_CONNECT ", stringArray);
                break;
            }
            case 26: {
                this.printResult("EPISODE_STOPED", stringArray);
                this.updateDramaIdOnCallback(n2, stringArray);
                this.mHandler.removeMessages(26);
                this.mHandler.sendEmptyMessage(26);
                this.cancelPositionUpdate();
                break;
            }
            case 12: {
                this.printResult("CMD_ON_COMPLETION", stringArray);
                this.updateDramaIdOnCallback(n2, stringArray);
                this.mHandler.removeMessages(12);
                this.mHandler.sendEmptyMessage(12);
                this.cancelPositionUpdate();
                break;
            }
            case 13: {
                this.printResult("CMD_ON_START_PLAY", stringArray);
                this.updateDramaIdOnCallback(n2, stringArray);
                String string = null;
                String string2 = null;
                try {
                    if (this.mPlayInfo.protocol == 3) {
                        if (stringArray.length > 0) {
                            string = stringArray[0];
                        }
                        if (stringArray.length > 1) {
                            string2 = stringArray[1];
                        }
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                if (!TextUtils.isEmpty(string) && !this.isSameUrl(string, this.mPlayInfo.getPlayUrl())) {
                    SourceLog.w(TAG, "CMD_ON_START_PLAY ignore");
                    if (TextUtils.equals((CharSequence)string, (CharSequence)this.mPreDLNAStopUrl)) {
                        SourceLog.w(TAG, "CMD_ON_START_PLAY not current url, callback stop");
                        this.mHandler.removeMessages(16);
                        this.mHandler.sendEmptyMessage(16);
                    }
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)this.mDlnaUUID)) {
                    this.mDlnaUUID = string2;
                }
                if (this.mHandler.hasMessages(16) && (this.isSameUrl(this.mPlayInfo.getPlayUrl(), string) || TextUtils.equals((CharSequence)this.mDlnaUUID, (CharSequence)string2))) {
                    SourceLog.w(TAG, "there has a stop msg,remove it ");
                    this.mHandler.removeMessages(16);
                }
                this.mHandler.sendEmptyMessage(13);
                this.updatePosition();
                break;
            }
            case 14: {
                this.printResult("CMD_ON_LOADING", stringArray);
                this.updateDramaIdOnCallback(n2, stringArray);
                break;
            }
            case 15: {
                this.printResult("CMD_ON_PAUSE", stringArray);
                this.updateDramaIdOnCallback(n2, stringArray);
                this.mHandler.sendEmptyMessage(15);
                this.cancelPositionUpdate();
                break;
            }
            case 16: 
            case 28: {
                this.printResult("CMD_ON_STOPED", stringArray);
                if (this.mPlayInfo.protocol == 3 ? !this.isSameDlna(stringArray) : !this.isSameLelink(stringArray)) {
                    return;
                }
                this.updateDramaIdOnCallback(n2, stringArray);
                int n3 = 1;
                if (n2 == 28) {
                    n3 = 4;
                }
                this.notifyStopped(n3);
            }
        }
    }

    private void updateDramaIdOnCallback(int n2, String ... stringArray) {
        OutParameter outParameter;
        String string = "";
        if (n2 == 8) {
            if (stringArray != null && stringArray.length >= 4) {
                string = stringArray[3];
            }
        } else if (stringArray != null && stringArray.length >= 2) {
            string = stringArray[1];
        }
        if (!TextUtils.isEmpty((CharSequence)string) && (outParameter = BusinessEntity.getInstance().getCurrentPlayInfo()) != null) {
            outParameter.dramaID = string;
        }
    }

    private boolean isSameDlna(String ... stringArray) {
        try {
            String string = null;
            String string2 = null;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            if (!(TextUtils.isEmpty(string2) || TextUtils.isEmpty((CharSequence)this.mDlnaUUID) || TextUtils.equals((CharSequence)string2, (CharSequence)this.mDlnaUUID))) {
                SourceLog.w(TAG, "isSameDlna unEqual uri, " + string2 + " / " + this.mDlnaUUID);
                return false;
            }
            if (!TextUtils.isEmpty((CharSequence)string) && !this.isSameUrl(string, this.mPlayInfo.getPlayUrl())) {
                SourceLog.w(TAG, "isSameDlna unEqual url, " + string + " / " + this.mPlayInfo.getPlayUrl());
                this.mPreDLNAStopUrl = string;
                return false;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return true;
    }

    private boolean isSameUrl(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)string2)) {
            return true;
        }
        try {
            if (TextUtils.equals((CharSequence)URLDecoder.decode(string), (CharSequence)string2)) {
                return true;
            }
            if (TextUtils.equals((CharSequence)URLDecoder.decode(string2), (CharSequence)string)) {
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }

    private boolean isSameLelink(String ... stringArray) {
        try {
            String string = null;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (!TextUtils.isEmpty(string) && !this.isSameUrl(string, this.mPlayInfo.urlID)) {
                SourceLog.w(TAG, "isSameLelink unEqual uri, " + string + "/" + this.mPlayInfo.urlID);
                return false;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return true;
    }

    private void notifyPosition(String ... stringArray) {
        try {
            if (stringArray.length < 2) {
                return;
            }
            if (stringArray[0].contains("readyToPlay")) {
                return;
            }
            int n2 = (int)Math.ceil(Float.parseFloat(stringArray[0]));
            int n3 = (int)Math.ceil(Float.parseFloat(stringArray[1]));
            if (this instanceof DLNABridge) {
                String string = null;
                try {
                    string = stringArray[2];
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            if (n2 > 0) {
                this.mDuration = n2;
            }
            if (n3 >= 0) {
                this.mPosition = n3;
            }
            if (++this.mPositionCount % 30 == 0) {
                this.printResult("notifyPosition ", "mDuration := " + this.mDuration + " mPosition := " + this.mPosition, "mInfoListener := " + this.mInfoListener);
            }
            if (this.mPosition > 0) {
                this.mLastPlayPosition = this.mPosition;
            }
            if (this.mDuration > 0) {
                this.mLastPlayDuration = this.mDuration;
            }
            if (this.mInfoListener != null) {
                this.mInfoListener.onInfo(null, 100, this.mDuration, this.mPosition);
            }
            if (this.isJGTP && this.mLastPlayDuration - this.mLastPlayPosition < 2L && this.mLastPlayDuration - this.mLastPlayPosition >= 0L && this.mLastPlayDuration > 3L && this.mDuration > 0 && this.mPosition > 0) {
                if (this.mHandler.hasMessages(12)) {
                    return;
                }
                SourceLog.i(TAG, "notifyPosition send CMD_ON_COMPLETION delay 4000");
                this.mHandler.removeMessages(12);
                this.mHandler.sendEmptyMessageDelayed(12, 4000L);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private int getRemainProgress() {
        int n2 = this.mDuration - this.mPosition;
        SourceLog.i(TAG, "remain progress " + n2);
        return n2;
    }

    private void notifyStopped(int n2) {
        if (this.mHandler.hasMessages(16)) {
            SourceLog.w(TAG, "notifyStopped ignore");
            return;
        }
        SourceLog.i(TAG, "notifyStopped delay " + DELAY_STOPPED + " / stopType:" + n2);
        Message message = Message.obtain();
        message.what = 16;
        message.arg1 = n2;
        this.mHandler.sendMessageDelayed(message, (long)DELAY_STOPPED);
    }

    private void handleMsg(Message message) {
        SourceLog.i(TAG, "handleMsg " + message.what);
        switch (message.what) {
            case 1: {
                if (message.arg1 == 2) {
                    if (this.mErrorListener == null) break;
                    this.mErrorListener.onError(null, 210010, 211026, null);
                    break;
                }
                if (message.arg1 == 1) {
                    if (this.mLoadingListener != null) {
                        this.mLoadingListener.onLoading(null, message.obj + "");
                    }
                    if (this.mPlayInfo.protocol != 3) break;
                    this.mDlnaGetPlayStateTime = System.currentTimeMillis();
                    this.mHandler.postDelayed(this.mDlnaStateRunnable, 2000L);
                    break;
                }
                if (this.mErrorListener == null) break;
                this.mErrorListener.onError(null, 210010, 210011, message.obj + "");
                break;
            }
            case 13: {
                this.callbackStart();
                if (this.mPlayInfo.protocol != 3) break;
                SourceLog.i(TAG, "CMD_ON_START_PLAY ");
                this.mHandler.removeCallbacks(this.mDlnaStateRunnable);
                this.mHandler.post(this.mDlnaStateRunnable);
                break;
            }
            case 15: {
                if (this.mStateChangeListener == null) break;
                this.mStateChangeListener.onStateChanged(null, 4);
                break;
            }
            case 12: 
            case 16: 
            case 26: {
                if (System.currentTimeMillis() - this.mDlnaGetPlayStateTime < 4000L) {
                    return;
                }
                this.cancelPositionUpdate();
                this.cancelStateUpdate();
                this.isCallPrepared = false;
                if (message.what != 26) {
                    this.release();
                }
                if (message.what == 12) {
                    if (this.mCompletionListener == null) break;
                    this.mCompletionListener.onComplete(null);
                    break;
                }
                if (this instanceof DLNABridge && this.mLastPlayDuration - this.mLastPlayPosition <= 5L && this.mLastPlayDuration - this.mLastPlayPosition >= 0L && this.mLastPlayDuration > 0L) {
                    if (this.mCompletionListener == null) break;
                    this.mCompletionListener.onComplete(null);
                    break;
                }
                if (this.mStopListener == null) break;
                StopInfo stopInfo = new StopInfo();
                stopInfo.type = message.what == 26 ? 3 : message.arg1;
                this.mStopListener.onStop(null, stopInfo);
            }
        }
    }

    public void updatePosition() {
        if (this.mPlayInfo.mimeType == 103) {
            return;
        }
        this.isUpdatePosition = true;
        this.mHandler.removeCallbacks(this.mPositionRunnable);
        this.mHandler.post(this.mPositionRunnable);
    }

    public void cancelPositionUpdate() {
        this.isUpdatePosition = false;
        this.mHandler.removeCallbacks(this.mPositionRunnable);
    }

    public void cancelStateUpdate() {
        SourceLog.i(TAG, "cancelStateUpdate... ");
        this.mHandler.removeCallbacks(this.mDlnaStateRunnable);
    }

    private void printResult(String string, String ... stringArray) {
        String string2 = "";
        for (String string3 : stringArray) {
            string2 = string2 + string3 + "  ";
        }
        SourceLog.i(TAG, "cmd: " + string + "   result:" + string2);
    }

    private void callbackDlnaStateChanged(String string) {
        SourceLog.i(TAG, "CMD_GET_STATEINFO callbackDlnaStateChanged " + string);
        if (DLNA_STATE_PLAYING.equals(string)) {
            this.callbackStart();
        } else if (DLNA_STATE_PAUSE.equals(string)) {
            if (this.mStateChangeListener != null) {
                this.mStateChangeListener.onStateChanged(null, 4);
            }
        } else if (DLNA_STATE_STOPPED.equals(string)) {
            SourceLog.i(TAG, " callbackDlnaStateChanged delayStop   " + (System.currentTimeMillis() - this.mDlnaGetPlayStateTime < 2000L) + this.mDlnaGetPlayStateTime);
            if (System.currentTimeMillis() - this.mDlnaGetPlayStateTime < 4000L) {
                DELAY_STOPPED = 10000;
            }
            this.notifyStopped(1);
        }
    }

    private void callbackStart() {
        if (this.mPlayInfo != null && this.mPlayInfo.urls != null) {
            if (this.mReportPrepareDramaId == null || !this.mReportPrepareDramaId.equals(this.mPlayInfo.dramaID)) {
                this.mReportPrepareDramaId = this.mPlayInfo.dramaID;
                if (this.mPreparedListener != null) {
                    this.mPreparedListener.onPrepared(null);
                }
            } else if (this.mStateChangeListener != null) {
                this.mStateChangeListener.onStateChanged(null, 3);
            }
        } else if (!this.isCallPrepared) {
            this.isCallPrepared = true;
            if (this.mPreparedListener != null) {
                this.mPreparedListener.onPrepared(null);
            }
        } else if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onStateChanged(null, 3);
        }
    }

    @Override
    public void onAppPause() {
        super.onAppPause();
        if (this.mPushController != null) {
            this.mPushController.onAppPause();
        }
    }

    @Override
    public void onAppResume() {
        super.onAppResume();
        if (this.mPushController != null) {
            this.mPushController.onAppResume();
        }
        if (this.isUpdatePosition) {
            this.updatePosition();
        }
    }

    @Override
    public synchronized void release() {
        if (this.mPushController == null) {
            return;
        }
        if (this.isReleased) {
            SourceLog.w(TAG, "release ignore");
            return;
        }
        SourceLog.i(TAG, "release " + this);
        this.isReleased = true;
        this.mPushController.setProtocolListener(null);
        this.mPushController.disConnect();
        this.mHandler.removeMessages(16);
        this.mHandler.removeMessages(12);
        ConnectManager.getInstance().getLastConnectBridge().removeOnPassSendCompleteListener(this);
        if (this.mModuleLinker != null) {
            this.mModuleLinker.removeObjOfMemory("3B5B9CF21B1389F9929454313D455A51");
            this.mModuleLinker = null;
        }
        this.mPushController = null;
    }
}

