/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.OPTRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.SIGRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Section;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIG;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIGRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Type;
import com.hpplay.sdk.source.mdns.xbill.dns.Update;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class Message
implements Cloneable {
    public static final int MAXLENGTH = 65535;
    private Header header;
    private List[] sections;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord querytsig;
    private int tsigerror;
    int tsigstart;
    int tsigState;
    int sig0start;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static Record[] emptyRecordArray = new Record[0];
    private static RRset[] emptyRRsetArray = new RRset[0];

    private Message(Header header) {
        this.sections = new List[4];
        this.header = header;
    }

    public Message(int n2) {
        this(new Header(n2));
    }

    public Message() {
        this(new Header());
    }

    public static Message newQuery(Record record) {
        Message message = new Message();
        message.header.setOpcode(0);
        message.header.setFlag(7);
        message.addRecord(record, 0);
        return message;
    }

    public static Message newUpdate(Name name) {
        return new Update(name);
    }

    Message(DNSInput dNSInput) {
        block6: {
            this(new Header(dNSInput));
            boolean bl = this.header.getOpcode() == 5;
            boolean bl2 = this.header.getFlag(6);
            try {
                for (int i2 = 0; i2 < 4; ++i2) {
                    int n2 = this.header.getCount(i2);
                    if (n2 > 0) {
                        this.sections[i2] = new ArrayList(n2);
                    }
                    for (int i3 = 0; i3 < n2; ++i3) {
                        SIGRecord sIGRecord;
                        int n3 = dNSInput.current();
                        Record record = Record.fromWire(dNSInput, i2, bl);
                        this.sections[i2].add(record);
                        if (i2 != 3) continue;
                        if (record.getType() == 250) {
                            this.tsigstart = n3;
                        }
                        if (record.getType() != 24 || (sIGRecord = (SIGRecord)record).getTypeCovered() != 0) continue;
                        this.sig0start = n3;
                    }
                }
            }
            catch (Exception exception) {
                if (bl2) break block6;
                throw exception;
            }
        }
        this.size = dNSInput.current();
    }

    public Message(byte[] byArray) {
        this(new DNSInput(byArray));
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record record, int n2) {
        if (this.sections[n2] == null) {
            this.sections[n2] = new LinkedList();
        }
        this.header.incCount(n2);
        this.sections[n2].add(record);
    }

    public boolean removeRecord(Record record, int n2) {
        if (this.sections[n2] != null && this.sections[n2].remove(record)) {
            this.header.decCount(n2);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int n2) {
        this.sections[n2] = null;
        this.header.setCount(n2, 0);
    }

    public boolean findRecord(Record record, int n2) {
        return this.sections[n2] != null && this.sections[n2].contains(record);
    }

    public boolean findRecord(Record record) {
        for (int i2 = 1; i2 <= 3; ++i2) {
            if (this.sections[i2] == null || !this.sections[i2].contains(record)) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int n2, int n3) {
        if (this.sections[n3] == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.sections[n3].size(); ++i2) {
            Record record = (Record)this.sections[n3].get(i2);
            if (record.getType() != n2 || !name.equals(record.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int n2) {
        return this.findRRset(name, n2, 1) || this.findRRset(name, n2, 2) || this.findRRset(name, n2, 3);
    }

    public Record getQuestion() {
        List list = this.sections[0];
        if (list == null || list.size() == 0) {
            return null;
        }
        return (Record)list.get(0);
    }

    public TSIGRecord getTSIG() {
        int n2 = this.header.getCount(3);
        if (n2 == 0) {
            return null;
        }
        List list = this.sections[3];
        Record record = (Record)list.get(n2 - 1);
        if (record.type != 250) {
            return null;
        }
        return (TSIGRecord)record;
    }

    public boolean isSigned() {
        return this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public OPTRecord getOPT() {
        Record[] recordArray = this.getSectionArray(3);
        for (int i2 = 0; i2 < recordArray.length; ++i2) {
            if (!(recordArray[i2] instanceof OPTRecord)) continue;
            return (OPTRecord)recordArray[i2];
        }
        return null;
    }

    public int getRcode() {
        int n2 = this.header.getRcode();
        OPTRecord oPTRecord = this.getOPT();
        if (oPTRecord != null) {
            n2 += oPTRecord.getExtendedRcode() << 4;
        }
        return n2;
    }

    public Record[] getSectionArray(int n2) {
        if (this.sections[n2] == null) {
            return emptyRecordArray;
        }
        List list = this.sections[n2];
        return list.toArray(new Record[list.size()]);
    }

    private static boolean sameSet(Record record, Record record2) {
        return record.getRRsetType() == record2.getRRsetType() && record.getDClass() == record2.getDClass() && record.getName().equals(record2.getName());
    }

    public RRset[] getSectionRRsets(int n2) {
        if (this.sections[n2] == null) {
            return emptyRRsetArray;
        }
        LinkedList<RRset> linkedList = new LinkedList<RRset>();
        Record[] recordArray = this.getSectionArray(n2);
        HashSet<Name> hashSet = new HashSet<Name>();
        for (int i2 = 0; i2 < recordArray.length; ++i2) {
            Name name = recordArray[i2].getName();
            boolean bl = true;
            if (hashSet.contains(name)) {
                for (int i3 = linkedList.size() - 1; i3 >= 0; --i3) {
                    RRset rRset = (RRset)linkedList.get(i3);
                    if (rRset.getType() != recordArray[i2].getRRsetType() || rRset.getDClass() != recordArray[i2].getDClass() || !rRset.getName().equals(name)) continue;
                    rRset.addRR(recordArray[i2]);
                    bl = false;
                    break;
                }
            }
            if (!bl) continue;
            RRset rRset = new RRset(recordArray[i2]);
            linkedList.add(rRset);
            hashSet.add(name);
        }
        return linkedList.toArray(new RRset[linkedList.size()]);
    }

    void toWire(DNSOutput dNSOutput) {
        this.header.toWire(dNSOutput);
        Compression compression = new Compression();
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.sections[i2] == null) continue;
            for (int i3 = 0; i3 < this.sections[i2].size(); ++i3) {
                Record record = (Record)this.sections[i2].get(i3);
                record.toWire(dNSOutput, i2, compression);
            }
        }
    }

    private int sectionToWire(DNSOutput dNSOutput, int n2, Compression compression, int n3) {
        int n4 = this.sections[n2].size();
        int n5 = dNSOutput.current();
        int n6 = 0;
        int n7 = 0;
        Record record = null;
        for (int i2 = 0; i2 < n4; ++i2) {
            Record record2 = (Record)this.sections[n2].get(i2);
            if (n2 == 3 && record2 instanceof OPTRecord) {
                ++n7;
                continue;
            }
            if (record != null && !Message.sameSet(record2, record)) {
                n5 = dNSOutput.current();
                n6 = i2;
            }
            record = record2;
            record2.toWire(dNSOutput, n2, compression);
            if (dNSOutput.current() <= n3) continue;
            dNSOutput.jump(n5);
            return n4 - n6 + n7;
        }
        return n7;
    }

    private boolean toWire(DNSOutput dNSOutput, int n2) {
        if (n2 < 12) {
            return false;
        }
        Object var3_3 = null;
        int n3 = n2;
        if (this.tsigkey != null) {
            n3 -= this.tsigkey.recordLength();
        }
        OPTRecord oPTRecord = this.getOPT();
        byte[] byArray = null;
        if (oPTRecord != null) {
            byArray = oPTRecord.toWire(3);
            n3 -= byArray.length;
        }
        int n4 = dNSOutput.current();
        this.header.toWire(dNSOutput);
        Compression compression = new Compression();
        int n5 = this.header.getFlagsByte();
        int n6 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.sections[i2] == null) continue;
            int n7 = this.sectionToWire(dNSOutput, i2, compression, n3);
            if (n7 != 0 && i2 != 3) {
                n5 = Header.setFlag(n5, 6, true);
                dNSOutput.writeU16At(this.header.getCount(i2) - n7, n4 + 4 + 2 * i2);
                for (int i3 = i2 + 1; i3 < 3; ++i3) {
                    dNSOutput.writeU16At(0, n4 + 4 + 2 * i3);
                }
                break;
            }
            if (i2 != 3) continue;
            n6 = this.header.getCount(i2) - n7;
        }
        if (byArray != null) {
            dNSOutput.writeByteArray(byArray);
            ++n6;
        }
        if (n5 != this.header.getFlagsByte()) {
            dNSOutput.writeU16At(n5, n4 + 2);
        }
        if (n6 != this.header.getCount(3)) {
            dNSOutput.writeU16At(n6, n4 + 10);
        }
        if (this.tsigkey != null) {
            TSIGRecord tSIGRecord = this.tsigkey.generate(this, dNSOutput.toByteArray(), this.tsigerror, this.querytsig);
            tSIGRecord.toWire(dNSOutput, 3, compression);
            dNSOutput.writeU16At(n6 + 1, n4 + 10);
        }
        return true;
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput);
        this.size = dNSOutput.current();
        return dNSOutput.toByteArray();
    }

    public byte[] toWire(int n2) {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, n2);
        this.size = dNSOutput.current();
        return dNSOutput.toByteArray();
    }

    public void setTSIG(TSIG tSIG, int n2, TSIGRecord tSIGRecord) {
        this.tsigkey = tSIG;
        this.tsigerror = n2;
        this.querytsig = tSIGRecord;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int n2) {
        if (n2 > 3) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Record[] recordArray = this.getSectionArray(n2);
        for (int i2 = 0; i2 < recordArray.length; ++i2) {
            Record record = recordArray[i2];
            if (n2 == 0) {
                stringBuffer.append(";;\t" + record.name);
                stringBuffer.append(", type = " + Type.string(record.type));
                stringBuffer.append(", class = " + DClass.string(record.dclass));
            } else {
                stringBuffer.append(record);
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        OPTRecord oPTRecord = this.getOPT();
        if (oPTRecord != null) {
            stringBuffer.append(this.header.toStringWithRcode(this.getRcode()) + "\n");
        } else {
            stringBuffer.append(this.header + "\n");
        }
        if (this.isSigned()) {
            stringBuffer.append(";; TSIG ");
            if (this.isVerified()) {
                stringBuffer.append("ok");
            } else {
                stringBuffer.append("invalid");
            }
            stringBuffer.append('\n');
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.header.getOpcode() != 5) {
                stringBuffer.append(";; " + Section.longString(i2) + ":\n");
            } else {
                stringBuffer.append(";; " + Section.updString(i2) + ":\n");
            }
            stringBuffer.append(this.sectionToString(i2) + "\n");
        }
        stringBuffer.append(";; Message size: " + this.numBytes() + " bytes");
        return stringBuffer.toString();
    }

    public Object clone() {
        Message message = new Message();
        for (int i2 = 0; i2 < this.sections.length; ++i2) {
            if (this.sections[i2] == null) continue;
            message.sections[i2] = new LinkedList(this.sections[i2]);
        }
        message.header = (Header)this.header.clone();
        message.size = this.size;
        return message;
    }
}

