/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.module;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import com.hpplay.glide.module.GlideModule;
import java.util.ArrayList;
import java.util.List;

public final class ManifestParser {
    private static final String TAG = "ManifestParser";
    private static final String GLIDE_MODULE_VALUE = "GlideModule";
    private final Context context;

    public ManifestParser(Context context) {
        this.context = context;
    }

    public List<GlideModule> parse() {
        ArrayList<GlideModule> arrayList = new ArrayList<GlideModule>();
        try {
            ApplicationInfo applicationInfo = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                for (String string : applicationInfo.metaData.keySet()) {
                    GlideModule glideModule;
                    if (!GLIDE_MODULE_VALUE.equals(applicationInfo.metaData.get(string)) || (glideModule = ManifestParser.parseModule(string)) == null) continue;
                    arrayList.add(glideModule);
                }
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
        }
        return arrayList;
    }

    private static GlideModule parseModule(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (!(obj instanceof GlideModule)) {
                return null;
            }
            return (GlideModule)obj;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (Throwable)exception);
            return null;
        }
    }
}

