/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.app.Application;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.herohan.uvcapp.CameraConnectionService;
import com.herohan.uvcapp.CameraException;
import com.herohan.uvcapp.CameraPreviewConfig;
import com.herohan.uvcapp.ICameraConnection;
import com.herohan.uvcapp.ICameraHelper;
import com.herohan.uvcapp.IImageCapture;
import com.herohan.uvcapp.ImageCaptureConfig;
import com.herohan.uvcapp.VideoCapture;
import com.herohan.uvcapp.VideoCaptureConfig;
import com.serenegiant.usb.Format;
import com.serenegiant.usb.IButtonCallback;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.UVCControl;
import com.serenegiant.usb.UVCParam;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.uvccamera.BuildConfig;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.WeakHashMap;

public class CameraHelper
implements ICameraHelper {
    private static final boolean DEBUG = BuildConfig.DEBUG;
    private static final String TAG = CameraHelper.class.getSimpleName();
    protected final WeakReference<Context> mWeakContext;
    private HandlerThread mAsyncHandlerThread;
    private Handler mAsyncHandler;
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    protected ICameraConnection mService;
    protected ICameraHelper.StateCallback mCallbackWrapper;
    private UsbDevice mUsbDevice;
    private final WeakHashMap<UsbDevice, Object> mDetachedDeviceMap = new WeakHashMap();
    private CameraPreviewConfig mCameraPreviewConfig = new CameraPreviewConfig();
    private ImageCaptureConfig mImageCaptureConfig = new ImageCaptureConfig();
    private VideoCaptureConfig mVideoCaptureConfig = new VideoCaptureConfig();

    public CameraHelper() {
        if (DEBUG) {
            Log.d((String)TAG, (String)"Constructor:");
        }
        this.mWeakContext = new WeakReference<Application>(UVCUtils.getApplication());
        this.mAsyncHandlerThread = new HandlerThread(TAG);
        this.mAsyncHandlerThread.start();
        this.mAsyncHandler = new Handler(this.mAsyncHandlerThread.getLooper());
        this.mService = CameraConnectionService.getInstance().newConnection();
    }

    @Override
    public void setStateCallback(ICameraHelper.StateCallback callback) {
        if (callback != null) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"11 setStateCallback:");
            }
            this.mCallbackWrapper = new StateCallbackWrapper(callback);
            if (DEBUG) {
                Log.d((String)TAG, (String)"22 setStateCallback:");
            }
            this.registerCallback();
            if (DEBUG) {
                Log.d((String)TAG, (String)"33 setStateCallback:");
            }
        } else {
            this.unregisterCallback();
            this.mCallbackWrapper = null;
        }
    }

    @Override
    public List<UsbDevice> getDeviceList() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"getDeviceList:");
            }
            if (this.mService != null) {
                try {
                    return this.mService.getDeviceList();
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"getDeviceList:", (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean isDetached(UsbDevice usbDevice) {
        return this.mDetachedDeviceMap.containsKey(usbDevice);
    }

    @Override
    public void selectDevice(UsbDevice device) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("selectDevice:device=" + (device != null ? device.getDeviceName() : null) + " " + this));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.mService != null && !this.isDetached(device)) {
                    this.mUsbDevice = device;
                    try {
                        this.mService.selectDevice(device);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"selectDevice:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public List<Format> getSupportedFormatList() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"getSupportedFormatList:");
            }
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    return this.mService.getSupportedFormatList(this.mUsbDevice);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"getSupportedFormatList:", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public List<Size> getSupportedSizeList() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"getSupportedSizeList:");
            }
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    return this.mService.getSupportedSizeList(this.mUsbDevice);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"getSupportedSizeList:", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public Size getPreviewSize() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"getPreviewSize:");
            }
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    return this.mService.getPreviewSize(this.mUsbDevice);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"getPreviewSize:", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public void setPreviewSize(Size size) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("setPreviewSize:" + size));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.setPreviewSize(this.mUsbDevice, size);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"setPreviewSize:", (Throwable)e);
                    }
                }
            }
        });
    }

    private Object fetchSurface(Object surface) {
        Object sur;
        if (surface instanceof SurfaceView) {
            SurfaceView surfaceView = (SurfaceView)surface;
            sur = surfaceView.getHolder().getSurface();
        } else if (surface instanceof SurfaceHolder) {
            SurfaceHolder holder = (SurfaceHolder)surface;
            sur = holder.getSurface();
        } else if (surface instanceof Surface || surface instanceof SurfaceTexture) {
            sur = surface;
        } else {
            throw new UnsupportedOperationException("addSurface() can only be called with an instance of Surface, SurfaceView, SurfaceTexture or SurfaceHolder at the moment.");
        }
        if (sur == null) {
            throw new UnsupportedOperationException("surface is null.");
        }
        return sur;
    }

    @Override
    public void addSurface(Object surface, boolean isRecordable) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("addSurface:surface=" + surface + ",isRecordable=" + isRecordable));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                Object sur = this.fetchSurface(surface);
                if (sur != null && this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.addSurface(this.mUsbDevice, sur, isRecordable);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"addSurface:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void removeSurface(Object surface) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("removeSurface:surface=" + surface));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                Object sur = this.fetchSurface(surface);
                if (sur != null && this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.removeSurface(this.mUsbDevice, sur);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"handleRemoveSurface:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void setButtonCallback(IButtonCallback callback) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("setButtonCallback:" + callback));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.setButtonCallback(this.mUsbDevice, callback);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"setButtonCallback:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void setFrameCallback(IFrameCallback callback, int pixelFormat) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("setFrameCallback:" + pixelFormat));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.setFrameCallback(this.mUsbDevice, callback, pixelFormat);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"setFrameCallback:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void openCamera() {
        this.openCamera(new UVCParam());
    }

    @Override
    public void openCamera(Size size) {
        this.openCamera(new UVCParam(size, 0));
    }

    @Override
    public void openCamera(UVCParam param) {
        if (DEBUG) {
            Log.d((String)TAG, (String)("openCamera: " + this));
        }
        this.mAsyncHandler.post(() -> {
            block4: {
                if (this.mService != null && this.mUsbDevice != null && !this.isDetached(this.mUsbDevice)) {
                    try {
                        if (!this.mService.isCameraOpened(this.mUsbDevice)) {
                            this.mService.openCamera(this.mUsbDevice, param, this.mCameraPreviewConfig, this.mImageCaptureConfig, this.mVideoCaptureConfig);
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block4;
                        Log.e((String)TAG, (String)"openCamera:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void closeCamera() {
        if (DEBUG) {
            Log.d((String)TAG, (String)("closeCamera: " + this));
        }
        this.mAsyncHandler.post(() -> {
            block4: {
                if (this.mService != null && this.mUsbDevice != null) {
                    try {
                        if (this.mService.isCameraOpened(this.mUsbDevice)) {
                            this.mService.closeCamera(this.mUsbDevice);
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block4;
                        Log.e((String)TAG, (String)"closeCamera:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void startPreview() {
        if (DEBUG) {
            Log.d((String)TAG, (String)("startPreview: " + this));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.startPreview(this.mUsbDevice);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"startPreview:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void stopPreview() {
        if (DEBUG) {
            Log.d((String)TAG, (String)("stopPreview: " + this));
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.stopPreview(this.mUsbDevice);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"stopPreview:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public UVCControl getUVCControl() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"getUVCControl:");
            }
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    return this.mService.getUVCControl(this.mUsbDevice);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"getUVCControl:", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public void takePicture(IImageCapture.OutputFileOptions options, IImageCapture.OnImageCaptureCallback callback) {
        if (DEBUG) {
            Log.d((String)TAG, (String)"takePicture");
        }
        this.mAsyncHandler.post(() -> {
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    this.mService.takePicture(this.mUsbDevice, options, callback);
                }
                catch (Exception e) {
                    String message;
                    if (DEBUG) {
                        Log.e((String)TAG, (String)"takePicture", (Throwable)e);
                    }
                    if ((message = e.getMessage()) == null) {
                        message = "takePicture failed with an unknown exception";
                    }
                    callback.onError(0, message, e);
                }
            } else {
                String message = "Camera is released";
                callback.onError(3, message, new IllegalStateException(message));
            }
        });
    }

    @Override
    public boolean isRecording() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"isRecording:");
            }
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    return this.mService.isRecording(this.mUsbDevice);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"isRecording:", (Throwable)e);
                }
            }
        }
        return false;
    }

    @Override
    public void startRecording(VideoCapture.OutputFileOptions options, VideoCapture.OnVideoCaptureCallback callback) {
        if (DEBUG) {
            Log.d((String)TAG, (String)"startRecording");
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.startRecording(this.mUsbDevice, options, callback);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"startRecording", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public void stopRecording() {
        if (DEBUG) {
            Log.d((String)TAG, (String)"stopRecording:");
        }
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.isRecording() && this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.stopRecording(this.mUsbDevice);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"stopRecording:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public boolean isCameraOpened() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"isCameraOpened:");
            }
            if (this.mService != null && this.mUsbDevice != null) {
                try {
                    return this.mService.isCameraOpened(this.mUsbDevice);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"isCameraOpened:", (Throwable)e);
                }
            }
        }
        return false;
    }

    @Override
    public void release() {
        if (DEBUG) {
            Log.d((String)TAG, (String)("release: " + this));
        }
        this.mAsyncHandler.post(() -> {
            if (this.mService != null) {
                block4: {
                    try {
                        if (this.mUsbDevice != null) {
                            this.mService.releaseCamera(this.mUsbDevice);
                        }
                        this.mService.release();
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block4;
                        Log.e((String)TAG, (String)"release:", (Throwable)e);
                    }
                }
                this.mCallbackWrapper = null;
                this.mService = null;
            }
            this.mUsbDevice = null;
            this.mAsyncHandlerThread.quitSafely();
            this.mDetachedDeviceMap.clear();
        });
    }

    @Override
    public void releaseAll() {
        if (DEBUG) {
            Log.d((String)TAG, (String)("releaseAll: " + this));
        }
        this.mAsyncHandler.post(() -> {
            if (this.mService != null) {
                block3: {
                    try {
                        this.mService.releaseAllCamera();
                        this.mService.release();
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"release:", (Throwable)e);
                    }
                }
                this.mCallbackWrapper = null;
                this.mService = null;
            }
            this.mUsbDevice = null;
            this.mAsyncHandlerThread.quitSafely();
            this.mDetachedDeviceMap.clear();
        });
    }

    @Override
    public CameraPreviewConfig getPreviewConfig() {
        return this.mCameraPreviewConfig;
    }

    @Override
    public void setPreviewConfig(CameraPreviewConfig config) {
        if (DEBUG) {
            Log.d((String)TAG, (String)"setCameraPreviewConfig:");
        }
        this.mCameraPreviewConfig = config;
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.isCameraOpened() && this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.setPreviewConfig(this.mUsbDevice, this.mCameraPreviewConfig);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"setCameraPreviewConfig:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public ImageCaptureConfig getImageCaptureConfig() {
        return this.mImageCaptureConfig;
    }

    @Override
    public void setImageCaptureConfig(ImageCaptureConfig config) {
        if (DEBUG) {
            Log.d((String)TAG, (String)"setImageCaptureConfig:");
        }
        this.mImageCaptureConfig = config;
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.isCameraOpened() && this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.setImageCaptureConfig(this.mUsbDevice, this.mImageCaptureConfig);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"setImageCaptureConfig:", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public VideoCaptureConfig getVideoCaptureConfig() {
        return this.mVideoCaptureConfig;
    }

    @Override
    public void setVideoCaptureConfig(VideoCaptureConfig config) {
        if (DEBUG) {
            Log.d((String)TAG, (String)"setVideoCaptureConfig:");
        }
        this.mVideoCaptureConfig = config;
        this.mAsyncHandler.post(() -> {
            block3: {
                if (this.isCameraOpened() && this.mService != null && this.mUsbDevice != null) {
                    try {
                        this.mService.setVideoCaptureConfig(this.mUsbDevice, this.mVideoCaptureConfig);
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block3;
                        Log.e((String)TAG, (String)"setVideoCaptureConfig:", (Throwable)e);
                    }
                }
            }
        });
    }

    public void registerCallback() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"registerCallback:");
            }
            if (this.mService != null) {
                try {
                    this.mService.register(this.mCallbackWrapper);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"registerCallback:", (Throwable)e);
                }
            }
        }
    }

    public void unregisterCallback() {
        block4: {
            if (DEBUG) {
                Log.d((String)TAG, (String)"unregisterCallback:");
            }
            if (this.mService != null) {
                try {
                    this.mService.unregister(this.mCallbackWrapper);
                }
                catch (Exception e) {
                    if (!DEBUG) break block4;
                    Log.e((String)TAG, (String)"unregisterCallback:", (Throwable)e);
                }
            }
        }
    }

    final class StateCallbackWrapper
    implements ICameraHelper.StateCallback {
        private ICameraHelper.StateCallback mCallback;

        StateCallbackWrapper(ICameraHelper.StateCallback callback) {
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAttach(UsbDevice device) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onAttach:");
            }
            WeakHashMap weakHashMap = CameraHelper.this.mDetachedDeviceMap;
            synchronized (weakHashMap) {
                CameraHelper.this.mDetachedDeviceMap.remove(device);
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onAttach(device));
        }

        @Override
        public void onDeviceOpen(UsbDevice device, boolean isFirstOpen) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onDeviceOpen:");
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onDeviceOpen(device, isFirstOpen));
        }

        @Override
        public void onCameraOpen(UsbDevice device) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onCameraOpen:");
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onCameraOpen(device));
        }

        @Override
        public void onCameraClose(UsbDevice device) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onCameraClose:");
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onCameraClose(device));
        }

        @Override
        public void onDeviceClose(UsbDevice device) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onDeviceClose:");
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onDeviceClose(device));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetach(UsbDevice device) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onDetach:");
            }
            WeakHashMap weakHashMap = CameraHelper.this.mDetachedDeviceMap;
            synchronized (weakHashMap) {
                CameraHelper.this.mDetachedDeviceMap.put(device, null);
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onDetach(device));
        }

        @Override
        public void onCancel(UsbDevice device) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onCancel:");
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onCancel(device));
        }

        @Override
        public void onError(UsbDevice device, CameraException e) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"onError:");
            }
            CameraHelper.this.mMainHandler.post(() -> this.mCallback.onError(device, e));
        }
    }
}

