/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.browser.p2p;

import android.net.wifi.p2p.WifiP2pDevice;
import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.wifidirect.IWDirectController;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.BrowserResolver;
import java.util.ArrayList;

public class P2PProxy {
    private static String TAG = "";
    private IWDirectController mWifiP2pController;
    private ArrayList<WifiP2pDevice> wifiP2pDevices;

    private void wifiP2PInit() {
        if (!a.h()) {
            return;
        }
        SourceLog.i(TAG, "wifpP2pInit ");
        try {
            this.mWifiP2pController = (IWDirectController)ModuleLinker.getInstance().loadModule("BCA7021EAABA524C12943A60454342A8");
            this.mWifiP2pController.init(false);
            this.mWifiP2pController.setWDirectStateListener(new ProtocolListener(){

                @Override
                public void onResult(int n2, String ... stringArray) {
                    if (1 == n2) {
                        SourceLog.i(TAG, "wifi2p connect time ");
                    } else if (9 == n2) {
                        SourceLog.i(TAG, "wifi2p connect failed ");
                    }
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo.getUid().contains("100")) {
            if (this.wifiP2pDevices != null && this.wifiP2pDevices.size() > 0) {
                for (int i2 = 0; i2 < this.wifiP2pDevices.size(); ++i2) {
                    if (!this.wifiP2pDevices.get((int)i2).deviceAddress.equals(lelinkServiceInfo.getIp())) continue;
                    this.mWifiP2pController.connect(this.wifiP2pDevices.get(i2));
                    break;
                }
            }
            return;
        }
    }

    public void disconnect(LelinkServiceInfo lelinkServiceInfo) {
        this.mWifiP2pController.stopDirect();
    }

    private void discoverWifiP2pDevices() {
        SourceLog.e(TAG, "start wifiP2p browse ---- ");
        if (this.mWifiP2pController == null) {
            return;
        }
        this.mWifiP2pController.setBrowseResultListener(new IBrowseResultListener(){

            @Override
            public void onBrowseResultCallback(int n2, Object object) {
                if (4 == n2) {
                    ArrayList<LelinkServiceInfo> arrayList = new ArrayList<LelinkServiceInfo>();
                    P2PProxy.this.wifiP2pDevices = (ArrayList)object;
                    if (P2PProxy.this.wifiP2pDevices.size() > 0) {
                        for (int i2 = 0; i2 < P2PProxy.this.wifiP2pDevices.size(); ++i2) {
                            SourceLog.e(TAG, "start onBrowseResultCallback ---- " + ((WifiP2pDevice)((P2PProxy)P2PProxy.this).wifiP2pDevices.get((int)i2)).deviceName);
                            LelinkServiceInfo lelinkServiceInfo = new LelinkServiceInfo();
                            lelinkServiceInfo.setName("direct " + ((WifiP2pDevice)((P2PProxy)P2PProxy.this).wifiP2pDevices.get((int)i2)).deviceName);
                            lelinkServiceInfo.setIp(((WifiP2pDevice)((P2PProxy)P2PProxy.this).wifiP2pDevices.get((int)i2)).deviceAddress);
                            lelinkServiceInfo.setUid("100 " + P2PProxy.getDeviceStatus(((WifiP2pDevice)((P2PProxy)P2PProxy.this).wifiP2pDevices.get((int)i2)).status) + ((WifiP2pDevice)((P2PProxy)P2PProxy.this).wifiP2pDevices.get((int)i2)).deviceAddress);
                            arrayList.add(lelinkServiceInfo);
                        }
                    }
                    BrowserResolver.updateServiceList(arrayList);
                }
            }
        });
        this.mWifiP2pController.discover();
    }

    public static String getDeviceStatus(int n2) {
        switch (n2) {
            case 3: {
                return "\u53ef\u7528\u7684";
            }
            case 1: {
                return "\u9080\u8bf7\u4e2d";
            }
            case 0: {
                return "\u5df2\u8fde\u63a5";
            }
            case 2: {
                return "\u5931\u8d25\u7684";
            }
            case 4: {
                return "\u4e0d\u53ef\u7528\u7684";
            }
        }
        return "\u672a\u77e5";
    }
}

