/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.log;

import android.text.TextUtils;
import com.hpplay.common.utils.ContextPath;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.FileUtils;
import java.io.File;

public class LogCache {
    private static final String TAG = "LogCache";
    private static final long MIN_LOG_CACHE_SIZE = 0x1E00000L;

    public static String getLogDir() {
        long l2;
        Preference preference = Preference.getInstance();
        String string = preference.get("key_log_dir");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i(TAG, "getLogDir cache " + string);
            return string;
        }
        if (FileUtils.isExternalStorageAvailable() && (l2 = FileUtils.getSDAvailableSize()) > 0x3C00000L) {
            String string2 = Session.getInstance().getContextPath().getPath("sdcard_file");
            string = ContextPath.jointPath(string2, "source/a/log");
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            SourceLog.i(TAG, "getLogDir cache sdcard " + string);
            preference.put("key_log_dir", string);
            return string;
        }
        String string3 = Session.getInstance().getContextPath().getPath("data_file");
        string = ContextPath.jointPath(string3, "source/a/log");
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        preference.put("key_log_dir", string);
        SourceLog.i(TAG, "getLogDir cache data " + string);
        return string;
    }

    public static String getLogOutputFilePath() {
        long l2;
        if (FileUtils.isExternalStorageAvailable() && (l2 = FileUtils.getSDAvailableSize()) > 0x1E00000L) {
            String string = Session.getInstance().getContextPath().getPath("sdcard_file");
            String string2 = ContextPath.jointPath(string, "source/a/log.zip");
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            SourceLog.i(TAG, "getLogOutputFilePath sdcard");
            return string2;
        }
        String string = Session.getInstance().getContextPath().getPath("data_file");
        String string3 = ContextPath.jointPath(string, "source/a/log.zip");
        File file = new File(string3);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SourceLog.i(TAG, "getLogOutputFilePath data");
        return string3;
    }
}

