/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business.cloud;

import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.bean.SDKConfigBean;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.utils.CastUtil;
import java.util.HashMap;

public class SDKConfig {
    private static final String TAG = "SDKConfig";
    private static SDKConfig sInstance;
    private SDKConfigBean mConfigBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SDKConfig getInstance() {
        Class<SDKConfig> clazz = SDKConfig.class;
        synchronized (SDKConfig.class) {
            if (sInstance == null) {
                sInstance = new SDKConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private SDKConfig() {
        this.readCacheData();
    }

    public void requestConfig() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", Session.getInstance().getUID());
        hashMap.put("appid", Session.getInstance().appKey);
        hashMap.put("token", a.a());
        hashMap.put("prot_ver", "1.0");
        hashMap.put("sdk_ver", CastUtil.getVersion());
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sConfig, HapplayUtils.getMapParams(hashMap));
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                if (asyncHttpParameter == null || asyncHttpParameter.out == null || TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result)) {
                    return;
                }
                String string = asyncHttpParameter.out.result;
                SDKConfigBean sDKConfigBean = SDKConfigBean.formJSON(string);
                if (sDKConfigBean != null) {
                    SDKConfig.this.mConfigBean = sDKConfigBean;
                }
                Preference.getInstance().put("key_sdk_config", string);
            }
        });
    }

    private void readCacheData() {
        String string = Preference.getInstance().get("key_sdk_config");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        SDKConfigBean sDKConfigBean = SDKConfigBean.formJSON(string);
        if (sDKConfigBean != null) {
            this.mConfigBean = sDKConfigBean;
        }
    }

    public int getSearchEnable() {
        if (this.mConfigBean == null || this.mConfigBean.data == null || this.mConfigBean.data.data_search == null) {
            return 1;
        }
        return this.mConfigBean.data.data_search.enable;
    }

    public int getSearchOutTime() {
        if (this.mConfigBean == null || this.mConfigBean.data == null || this.mConfigBean.data.data_search == null) {
            return 30;
        }
        if (this.mConfigBean.data.data_search.searchtime <= 0) {
            return 30;
        }
        return this.mConfigBean.data.data_search.searchtime;
    }

    public int getTransferEnable() {
        if (this.mConfigBean == null || this.mConfigBean.data == null || this.mConfigBean.data.data_transfer == null) {
            return 1;
        }
        return this.mConfigBean.data.data_transfer.enable;
    }

    public int getQualityInterval() {
        if (this.mConfigBean == null || this.mConfigBean.data == null || this.mConfigBean.data.data_transfer == null) {
            return 5000;
        }
        if (this.mConfigBean.data.data_transfer.videoquality_time <= 0) {
            return 5000;
        }
        return this.mConfigBean.data.data_transfer.videoquality_time * 1000;
    }
}

