/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.gifencoder;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.util.Log;
import com.hpplay.glide.gifencoder.LZWEncoder;
import com.hpplay.glide.gifencoder.NeuQuant;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AnimatedGifEncoder {
    private static final String TAG = "AnimatedGifEncoder";
    private static final double MIN_TRANSPARENT_PERCENTAGE = 4.0;
    private int width;
    private int height;
    private Integer transparent = null;
    private int transIndex;
    private int repeat = -1;
    private int delay = 0;
    private boolean started = false;
    private OutputStream out;
    private Bitmap image;
    private byte[] pixels;
    private byte[] indexedPixels;
    private int colorDepth;
    private byte[] colorTab;
    private boolean[] usedEntry = new boolean[256];
    private int palSize = 7;
    private int dispose = -1;
    private boolean closeStream = false;
    private boolean firstFrame = true;
    private boolean sizeSet = false;
    private int sample = 10;
    private boolean hasTransparentPixels;

    public void setDelay(int n2) {
        this.delay = Math.round((float)n2 / 10.0f);
    }

    public void setDispose(int n2) {
        if (n2 >= 0) {
            this.dispose = n2;
        }
    }

    public void setRepeat(int n2) {
        if (n2 >= 0) {
            this.repeat = n2;
        }
    }

    public void setTransparent(int n2) {
        this.transparent = n2;
    }

    public boolean addFrame(Bitmap bitmap) {
        if (bitmap == null || !this.started) {
            return false;
        }
        boolean bl = true;
        try {
            if (!this.sizeSet) {
                this.setSize(bitmap.getWidth(), bitmap.getHeight());
            }
            this.image = bitmap;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean bl = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return bl;
    }

    public void setFrameRate(float f2) {
        if (f2 != 0.0f) {
            this.delay = Math.round(100.0f / f2);
        }
    }

    public void setQuality(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.sample = n2;
    }

    public void setSize(int n2, int n3) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = n2;
        this.height = n3;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public boolean start(OutputStream outputStream) {
        if (outputStream == null) {
            return false;
        }
        boolean bl = true;
        this.closeStream = false;
        this.out = outputStream;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    public boolean start(String string) {
        boolean bl = true;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(string));
            bl = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    private void analyzePixels() {
        int n2;
        int n3;
        int n4 = this.pixels.length;
        int n5 = n4 / 3;
        this.indexedPixels = new byte[n5];
        NeuQuant neuQuant = new NeuQuant(this.pixels, n4, this.sample);
        this.colorTab = neuQuant.process();
        for (n3 = 0; n3 < this.colorTab.length; n3 += 3) {
            n2 = this.colorTab[n3];
            this.colorTab[n3] = this.colorTab[n3 + 2];
            this.colorTab[n3 + 2] = n2;
            this.usedEntry[n3 / 3] = false;
        }
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n6 = neuQuant.map(this.pixels[n3++] & 0xFF, this.pixels[n3++] & 0xFF, this.pixels[n3++] & 0xFF);
            this.usedEntry[n6] = true;
            this.indexedPixels[n2] = (byte)n6;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            this.transIndex = this.findClosest(this.transparent);
        } else if (this.hasTransparentPixels) {
            this.transIndex = this.findClosest(0);
        }
    }

    private int findClosest(int n2) {
        if (this.colorTab == null) {
            return -1;
        }
        int n3 = Color.red((int)n2);
        int n4 = Color.green((int)n2);
        int n5 = Color.blue((int)n2);
        int n6 = 0;
        int n7 = 0x1000000;
        int n8 = this.colorTab.length;
        for (int i2 = 0; i2 < n8; ++i2) {
            int n9 = n3 - (this.colorTab[i2++] & 0xFF);
            int n10 = n4 - (this.colorTab[i2++] & 0xFF);
            int n11 = n5 - (this.colorTab[i2] & 0xFF);
            int n12 = n9 * n9 + n10 * n10 + n11 * n11;
            int n13 = i2 / 3;
            if (!this.usedEntry[n13] || n12 >= n7) continue;
            n7 = n12;
            n6 = n13;
        }
        return n6;
    }

    private void getImagePixels() {
        Object object;
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        if (n2 != this.width || n3 != this.height) {
            object = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(object);
            canvas.drawBitmap(object, 0.0f, 0.0f, null);
            this.image = object;
        }
        object = new int[n2 * n3];
        this.image.getPixels((int[])object, 0, n2, 0, 0, n2, n3);
        this.pixels = new byte[((Bitmap)object).length * 3];
        int n4 = 0;
        this.hasTransparentPixels = false;
        int n5 = 0;
        for (Bitmap bitmap : object) {
            if (bitmap == false) {
                ++n5;
            }
            this.pixels[n4++] = (byte)(bitmap & 0xFF);
            this.pixels[n4++] = (byte)(bitmap >> 8 & 0xFF);
            this.pixels[n4++] = (byte)(bitmap >> 16 & 0xFF);
        }
        double d2 = (double)(100 * n5) / (double)((Bitmap)object).length;
        boolean bl = this.hasTransparentPixels = d2 > 4.0;
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("got pixels for frame with " + d2 + "% transparent pixels"));
        }
    }

    private void writeGraphicCtrlExt() {
        int n2;
        int n3;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null && !this.hasTransparentPixels) {
            n3 = 0;
            n2 = 0;
        } else {
            n3 = 1;
            n2 = 2;
        }
        if (this.dispose >= 0) {
            n2 = this.dispose & 7;
        }
        this.out.write(0 | (n2 <<= 2) | 0 | n3);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    private void writeImageDesc() {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    private void writeLSD() {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeNetscapeExt() {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    private void writePalette() {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n2 = 768 - this.colorTab.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.out.write(0);
        }
    }

    private void writePixels() {
        LZWEncoder lZWEncoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        lZWEncoder.encode(this.out);
    }

    private void writeShort(int n2) {
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
    }

    private void writeString(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.out.write((byte)string.charAt(i2));
        }
    }
}

