/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import com.hpplay.glide.DrawableRequestBuilder;
import com.hpplay.glide.DrawableTypeRequest;
import com.hpplay.glide.GenericRequestBuilder;
import com.hpplay.glide.GenericTranscodeRequest;
import com.hpplay.glide.Glide;
import com.hpplay.glide.load.engine.DiskCacheStrategy;
import com.hpplay.glide.load.model.ModelLoader;
import com.hpplay.glide.load.model.file_descriptor.FileDescriptorModelLoader;
import com.hpplay.glide.load.model.stream.MediaStoreStreamLoader;
import com.hpplay.glide.load.model.stream.StreamByteArrayLoader;
import com.hpplay.glide.load.model.stream.StreamModelLoader;
import com.hpplay.glide.manager.ConnectivityMonitor;
import com.hpplay.glide.manager.ConnectivityMonitorFactory;
import com.hpplay.glide.manager.Lifecycle;
import com.hpplay.glide.manager.LifecycleListener;
import com.hpplay.glide.manager.RequestManagerTreeNode;
import com.hpplay.glide.manager.RequestTracker;
import com.hpplay.glide.signature.ApplicationVersionSignature;
import com.hpplay.glide.signature.MediaStoreSignature;
import com.hpplay.glide.signature.StringSignature;
import com.hpplay.glide.util.Util;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;

public class RequestManager
implements LifecycleListener {
    private final Context context;
    private final Lifecycle lifecycle;
    private final RequestManagerTreeNode treeNode;
    private final RequestTracker requestTracker;
    private final Glide glide;
    private final OptionsApplier optionsApplier;
    private DefaultOptions options;

    public RequestManager(Context context, Lifecycle lifecycle, RequestManagerTreeNode requestManagerTreeNode) {
        this(context, lifecycle, requestManagerTreeNode, new RequestTracker(), new ConnectivityMonitorFactory());
    }

    RequestManager(Context context, final Lifecycle lifecycle, RequestManagerTreeNode requestManagerTreeNode, RequestTracker requestTracker, ConnectivityMonitorFactory connectivityMonitorFactory) {
        this.context = context.getApplicationContext();
        this.lifecycle = lifecycle;
        this.treeNode = requestManagerTreeNode;
        this.requestTracker = requestTracker;
        this.glide = Glide.get(context);
        this.optionsApplier = new OptionsApplier();
        ConnectivityMonitor connectivityMonitor = connectivityMonitorFactory.build(context, new RequestManagerConnectivityListener(requestTracker));
        if (Util.isOnBackgroundThread()) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    lifecycle.addListener(RequestManager.this);
                }
            });
        } else {
            lifecycle.addListener(this);
        }
        lifecycle.addListener(connectivityMonitor);
    }

    public void onTrimMemory(int n2) {
        this.glide.trimMemory(n2);
    }

    public void onLowMemory() {
        this.glide.clearMemory();
    }

    public void setDefaultOptions(DefaultOptions defaultOptions) {
        this.options = defaultOptions;
    }

    public boolean isPaused() {
        Util.assertMainThread();
        return this.requestTracker.isPaused();
    }

    public void pauseRequests() {
        Util.assertMainThread();
        this.requestTracker.pauseRequests();
    }

    public void pauseRequestsRecursive() {
        Util.assertMainThread();
        this.pauseRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.pauseRequests();
        }
    }

    public void resumeRequests() {
        Util.assertMainThread();
        this.requestTracker.resumeRequests();
    }

    public void resumeRequestsRecursive() {
        Util.assertMainThread();
        this.resumeRequests();
        for (RequestManager requestManager : this.treeNode.getDescendants()) {
            requestManager.resumeRequests();
        }
    }

    @Override
    public void onStart() {
        this.resumeRequests();
    }

    @Override
    public void onStop() {
        this.pauseRequests();
    }

    @Override
    public void onDestroy() {
        this.requestTracker.clearRequests();
    }

    public <A, T> GenericModelRequest<A, T> using(ModelLoader<A, T> modelLoader, Class<T> clazz) {
        return new GenericModelRequest<A, T>(modelLoader, clazz);
    }

    public <T> ImageModelRequest<T> using(StreamModelLoader<T> streamModelLoader) {
        return new ImageModelRequest(streamModelLoader);
    }

    public ImageModelRequest<byte[]> using(StreamByteArrayLoader streamByteArrayLoader) {
        return new ImageModelRequest<byte[]>(streamByteArrayLoader);
    }

    public <T> VideoModelRequest<T> using(FileDescriptorModelLoader<T> fileDescriptorModelLoader) {
        return new VideoModelRequest(fileDescriptorModelLoader);
    }

    public DrawableTypeRequest<String> load(String string) {
        return (DrawableTypeRequest)this.fromString().load((Object)string);
    }

    public DrawableTypeRequest<String> fromString() {
        return this.loadGeneric(String.class);
    }

    public DrawableTypeRequest<Uri> load(Uri uri) {
        return (DrawableTypeRequest)this.fromUri().load((Object)uri);
    }

    public DrawableTypeRequest<Uri> fromUri() {
        return this.loadGeneric(Uri.class);
    }

    @Deprecated
    public DrawableTypeRequest<Uri> loadFromMediaStore(Uri uri, String string, long l2, int n2) {
        MediaStoreSignature mediaStoreSignature = new MediaStoreSignature(string, l2, n2);
        return (DrawableTypeRequest)this.loadFromMediaStore(uri).signature(mediaStoreSignature);
    }

    public DrawableTypeRequest<Uri> loadFromMediaStore(Uri uri) {
        return (DrawableTypeRequest)this.fromMediaStore().load((Object)uri);
    }

    public DrawableTypeRequest<Uri> fromMediaStore() {
        ModelLoader<Class<Uri>, InputStream> modelLoader = Glide.buildStreamModelLoader(Uri.class, this.context);
        MediaStoreStreamLoader mediaStoreStreamLoader = new MediaStoreStreamLoader(this.context, modelLoader);
        ModelLoader<Class<Uri>, ParcelFileDescriptor> modelLoader2 = Glide.buildFileDescriptorModelLoader(Uri.class, this.context);
        return this.optionsApplier.apply(new DrawableTypeRequest<Class<Uri>>(Uri.class, mediaStoreStreamLoader, modelLoader2, this.context, this.glide, this.requestTracker, this.lifecycle, this.optionsApplier));
    }

    public DrawableTypeRequest<File> load(File file) {
        return (DrawableTypeRequest)this.fromFile().load((Object)file);
    }

    public DrawableTypeRequest<File> fromFile() {
        return this.loadGeneric(File.class);
    }

    public DrawableTypeRequest<Integer> load(Integer n2) {
        return (DrawableTypeRequest)this.fromResource().load((Object)n2);
    }

    public DrawableTypeRequest<Integer> fromResource() {
        return (DrawableTypeRequest)this.loadGeneric(Integer.class).signature(ApplicationVersionSignature.obtain(this.context));
    }

    @Deprecated
    public DrawableTypeRequest<URL> load(URL uRL) {
        return (DrawableTypeRequest)this.fromUrl().load((Object)uRL);
    }

    @Deprecated
    public DrawableTypeRequest<URL> fromUrl() {
        return this.loadGeneric(URL.class);
    }

    @Deprecated
    public DrawableTypeRequest<byte[]> load(byte[] byArray, String string) {
        return (DrawableTypeRequest)this.load((Object)byArray).signature(new StringSignature(string));
    }

    public DrawableTypeRequest<byte[]> load(byte[] byArray) {
        return (DrawableTypeRequest)this.fromBytes().load((Object)byArray);
    }

    public DrawableTypeRequest<byte[]> fromBytes() {
        return (DrawableTypeRequest)((DrawableRequestBuilder)((DrawableRequestBuilder)this.loadGeneric(byte[].class).signature(new StringSignature(UUID.randomUUID().toString()))).diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true);
    }

    public <T> DrawableTypeRequest<T> load(T t2) {
        return (DrawableTypeRequest)this.loadGeneric(RequestManager.getSafeClass(t2)).load((Object)t2);
    }

    public <T> DrawableTypeRequest<T> from(Class<T> clazz) {
        return this.loadGeneric(clazz);
    }

    private <T> DrawableTypeRequest<T> loadGeneric(Class<T> clazz) {
        ModelLoader<Class<T>, InputStream> modelLoader = Glide.buildStreamModelLoader(clazz, this.context);
        ModelLoader<Class<T>, ParcelFileDescriptor> modelLoader2 = Glide.buildFileDescriptorModelLoader(clazz, this.context);
        if (clazz != null && modelLoader == null && modelLoader2 == null) {
            throw new IllegalArgumentException("Unknown type " + clazz + ". You must provide a Model of a type for which there is a registered ModelLoader, if you are using a custom model, you must first call Glide#register with a ModelLoaderFactory for your custom model class");
        }
        return this.optionsApplier.apply(new DrawableTypeRequest<Class<T>>(clazz, modelLoader, modelLoader2, this.context, this.glide, this.requestTracker, this.lifecycle, this.optionsApplier));
    }

    private static <T> Class<T> getSafeClass(T t2) {
        return t2 != null ? t2.getClass() : null;
    }

    private static class RequestManagerConnectivityListener
    implements ConnectivityMonitor.ConnectivityListener {
        private final RequestTracker requestTracker;

        public RequestManagerConnectivityListener(RequestTracker requestTracker) {
            this.requestTracker = requestTracker;
        }

        @Override
        public void onConnectivityChanged(boolean bl) {
            if (bl) {
                this.requestTracker.restartRequests();
            }
        }
    }

    class OptionsApplier {
        OptionsApplier() {
        }

        public <A, X extends GenericRequestBuilder<A, ?, ?, ?>> X apply(X x) {
            if (RequestManager.this.options != null) {
                RequestManager.this.options.apply(x);
            }
            return x;
        }
    }

    public final class GenericModelRequest<A, T> {
        private final ModelLoader<A, T> modelLoader;
        private final Class<T> dataClass;

        GenericModelRequest(ModelLoader<A, T> modelLoader, Class<T> clazz) {
            this.modelLoader = modelLoader;
            this.dataClass = clazz;
        }

        public GenericTypeRequest from(Class<A> clazz) {
            return new GenericTypeRequest(clazz);
        }

        public GenericTypeRequest load(A a2) {
            return new GenericTypeRequest(a2);
        }

        public final class GenericTypeRequest {
            private final A model;
            private final Class<A> modelClass;
            private final boolean providedModel;

            GenericTypeRequest(A a2) {
                this.providedModel = true;
                this.model = a2;
                this.modelClass = RequestManager.getSafeClass(a2);
            }

            GenericTypeRequest(Class<A> clazz) {
                this.providedModel = false;
                this.model = null;
                this.modelClass = clazz;
            }

            public <Z> GenericTranscodeRequest<A, T, Z> as(Class<Z> clazz) {
                GenericTranscodeRequest genericTranscodeRequest = RequestManager.this.optionsApplier.apply(new GenericTranscodeRequest(RequestManager.this.context, RequestManager.this.glide, this.modelClass, GenericModelRequest.this.modelLoader, GenericModelRequest.this.dataClass, clazz, RequestManager.this.requestTracker, RequestManager.this.lifecycle, RequestManager.this.optionsApplier));
                if (this.providedModel) {
                    genericTranscodeRequest.load(this.model);
                }
                return genericTranscodeRequest;
            }
        }
    }

    public final class ImageModelRequest<T> {
        private final ModelLoader<T, InputStream> loader;

        ImageModelRequest(ModelLoader<T, InputStream> modelLoader) {
            this.loader = modelLoader;
        }

        public DrawableTypeRequest<T> from(Class<T> clazz) {
            return RequestManager.this.optionsApplier.apply(new DrawableTypeRequest<T>(clazz, this.loader, null, RequestManager.this.context, RequestManager.this.glide, RequestManager.this.requestTracker, RequestManager.this.lifecycle, RequestManager.this.optionsApplier));
        }

        public DrawableTypeRequest<T> load(T t2) {
            return (DrawableTypeRequest)this.from(RequestManager.getSafeClass(t2)).load((Object)t2);
        }
    }

    public final class VideoModelRequest<T> {
        private final ModelLoader<T, ParcelFileDescriptor> loader;

        VideoModelRequest(ModelLoader<T, ParcelFileDescriptor> modelLoader) {
            this.loader = modelLoader;
        }

        public DrawableTypeRequest<T> load(T t2) {
            return (DrawableTypeRequest)RequestManager.this.optionsApplier.apply(new DrawableTypeRequest<T>(RequestManager.getSafeClass(t2), null, this.loader, RequestManager.this.context, RequestManager.this.glide, RequestManager.this.requestTracker, RequestManager.this.lifecycle, RequestManager.this.optionsApplier)).load((Object)t2);
        }
    }

    public static interface DefaultOptions {
        public <T> void apply(GenericRequestBuilder<T, ?, ?, ?> var1);
    }
}

