/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.upnp.device.SearchListener;
import com.hpplay.cybergarage.upnp.ssdp.HTTPMUSocket;
import com.hpplay.cybergarage.upnp.ssdp.SSDP;
import com.hpplay.cybergarage.upnp.ssdp.SSDPPacket;
import com.hpplay.cybergarage.util.ListenerList;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public class SSDPSearchSocket
extends HTTPMUSocket
implements Runnable {
    private boolean useIPv6Address;
    private ListenerList deviceSearchListenerList = new ListenerList();
    private Thread deviceSearchThread = null;

    public SSDPSearchSocket(String string, int n2, String string2) {
        this.open(string, string2);
    }

    public SSDPSearchSocket(InetAddress inetAddress) {
        if (inetAddress.getAddress().length != 4) {
            this.open((Inet6Address)inetAddress);
        } else {
            this.open((Inet4Address)inetAddress);
        }
    }

    public boolean open(Inet4Address inet4Address) {
        this.useIPv6Address = false;
        return this.open("239.255.255.250", 1900, inet4Address);
    }

    public boolean open(Inet6Address inet6Address) {
        this.useIPv6Address = true;
        return this.open(SSDP.getIPv6Address(), 1900, inet6Address);
    }

    public boolean open(String string, String string2) {
        if (HostInterface.isIPv6Address(string) && HostInterface.isIPv6Address(string2)) {
            this.useIPv6Address = true;
        } else if (HostInterface.isIPv4Address(string) && HostInterface.isIPv4Address(string2)) {
            this.useIPv6Address = false;
        } else {
            throw new IllegalArgumentException("Cannot open a UDP Socket for IPv6 address on IPv4 interface or viceversa");
        }
        return this.open(string2, 1900, string);
    }

    public boolean open(String string) {
        String string2 = "239.255.255.250";
        this.useIPv6Address = false;
        if (HostInterface.isIPv6Address(string)) {
            string2 = SSDP.getIPv6Address();
            this.useIPv6Address = true;
        }
        return this.open(string2, 1900, string);
    }

    public void addSearchListener(SearchListener searchListener) {
        this.deviceSearchListenerList.add(searchListener);
    }

    public void removeSearchListener(SearchListener searchListener) {
        this.deviceSearchListenerList.remove(searchListener);
    }

    public void performSearchListener(SSDPPacket sSDPPacket) {
        int n2 = this.deviceSearchListenerList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SearchListener searchListener = (SearchListener)this.deviceSearchListenerList.get(i2);
            searchListener.deviceSearchReceived(sSDPPacket);
        }
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.deviceSearchThread == thread) {
            Thread.yield();
            SSDPPacket sSDPPacket = null;
            try {
                sSDPPacket = this.receive();
            }
            catch (Exception exception) {
                break;
            }
            if (sSDPPacket == null || !sSDPPacket.isDiscover()) continue;
            this.performSearchListener(sSDPPacket);
        }
    }

    public void start() {
        StringBuffer stringBuffer = new StringBuffer("Cyber.SSDPSearchSocket/");
        String string = this.getLocalAddress();
        if (string != null && 0 < string.length()) {
            stringBuffer.append(this.getLocalAddress()).append(':');
            stringBuffer.append(this.getLocalPort()).append(" -> ");
            stringBuffer.append(this.getMulticastAddress()).append(':');
            stringBuffer.append(this.getMulticastPort());
        }
        this.deviceSearchThread = new Thread((Runnable)this, stringBuffer.toString());
        this.deviceSearchThread.start();
    }

    public void stop() {
        this.close();
        this.deviceSearchThread = null;
    }
}

