/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.BinaryPropertyListParser;
import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class NSDate
extends NSObject {
    private Date date;
    private static final long EPOCH = 978307200000L;
    private static final SimpleDateFormat sdfDefault = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat sdfGnuStep = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public NSDate(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public NSDate(byte[] byArray, int n2, int n3) {
        this.date = new Date(978307200000L + (long)(1000.0 * BinaryPropertyListParser.parseDouble(byArray, n2, n3)));
    }

    public NSDate(String string) {
        this.date = NSDate.parseDateString(string);
    }

    public NSDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        this.date = date;
    }

    private static synchronized Date parseDateString(String string) {
        try {
            return sdfDefault.parse(string);
        }
        catch (ParseException parseException) {
            return sdfGnuStep.parse(string);
        }
    }

    private static synchronized String makeDateString(Date date) {
        return sdfDefault.format(date);
    }

    private static synchronized String makeDateStringGnuStep(Date date) {
        return sdfGnuStep.format(date);
    }

    public Date getDate() {
        return this.date;
    }

    public boolean equals(Object object) {
        return object.getClass().equals(this.getClass()) && this.date.equals(((NSDate)object).getDate());
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    @Override
    public NSDate clone() {
        return new NSDate((Date)this.getDate().clone());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("<date>");
        stringBuilder.append(NSDate.makeDateString(this.date));
        stringBuilder.append("</date>");
    }

    @Override
    public void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) {
        binaryPropertyListWriter.write(51);
        binaryPropertyListWriter.writeDouble((double)(this.date.getTime() - 978307200000L) / 1000.0);
    }

    public String toString() {
        return this.date.toString();
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append('\"');
        stringBuilder.append(NSDate.makeDateString(this.date));
        stringBuilder.append('\"');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("<*D");
        stringBuilder.append(NSDate.makeDateStringGnuStep(this.date));
        stringBuilder.append('>');
    }

    static {
        sdfDefault.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdfGnuStep.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

