/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.net.HostInterface;
import com.hpplay.cybergarage.upnp.device.SearchListener;
import com.hpplay.cybergarage.upnp.ssdp.SSDP;
import com.hpplay.cybergarage.upnp.ssdp.SSDPSearchSocket;
import java.net.InetAddress;
import java.util.Vector;

public class SSDPSearchSocketList
extends Vector {
    private static final String TAG = "SSDPSearchSocketList";
    private InetAddress[] binds = null;
    private String multicastIPv4 = "239.255.255.250";
    private String multicastIPv6 = SSDP.getIPv6Address();
    private int port = 1900;

    public SSDPSearchSocketList() {
    }

    public SSDPSearchSocketList(InetAddress[] inetAddressArray) {
        this.binds = inetAddressArray;
    }

    public SSDPSearchSocketList(InetAddress[] inetAddressArray, int n2, String string, String string2) {
        this.binds = inetAddressArray;
        this.port = n2;
        this.multicastIPv4 = string;
        this.multicastIPv6 = string2;
    }

    public SSDPSearchSocket getSSDPSearchSocket(int n2) {
        return (SSDPSearchSocket)this.get(n2);
    }

    public void addSearchListener(SearchListener searchListener) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchSocket sSDPSearchSocket = this.getSSDPSearchSocket(i2);
            sSDPSearchSocket.addSearchListener(searchListener);
        }
    }

    public boolean open() {
        int n2;
        String[] stringArray;
        InetAddress[] inetAddressArray = this.binds;
        if (inetAddressArray != null) {
            stringArray = new String[inetAddressArray.length];
            for (n2 = 0; n2 < inetAddressArray.length; ++n2) {
                stringArray[n2] = inetAddressArray[n2].getHostAddress();
            }
        } else {
            n2 = HostInterface.getNHostAddresses();
            stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = HostInterface.getHostAddress(i2);
            }
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) continue;
            SSDPSearchSocket sSDPSearchSocket = HostInterface.isIPv6Address(stringArray[n2]) ? new SSDPSearchSocket(stringArray[n2], this.port, this.multicastIPv6) : new SSDPSearchSocket(stringArray[n2], this.port, this.multicastIPv4);
            this.add(sSDPSearchSocket);
        }
        return true;
    }

    public void close() {
        int n2 = this.size();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                SSDPSearchSocket sSDPSearchSocket = this.getSSDPSearchSocket(i2);
                sSDPSearchSocket.close();
            }
            this.clear();
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void start() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchSocket sSDPSearchSocket = this.getSSDPSearchSocket(i2);
            sSDPSearchSocket.start();
        }
    }

    public void stop() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SSDPSearchSocket sSDPSearchSocket = this.getSSDPSearchSocket(i2);
            sSDPSearchSocket.stop();
        }
    }
}

