/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSData;
import com.hpplay.component.protocol.plist.NSDate;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSNumber;
import com.hpplay.component.protocol.plist.NSSet;
import com.hpplay.component.protocol.plist.NSString;
import com.hpplay.component.protocol.plist.UID;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class NSObject
implements Cloneable {
    static final String NEWLINE = System.getProperty("line.separator");
    static final int ASCII_LINE_LENGTH = 80;
    private static final String INDENT = "\t";

    public abstract NSObject clone();

    abstract void toXML(StringBuilder var1, int var2);

    void assignIDs(BinaryPropertyListWriter binaryPropertyListWriter) {
        binaryPropertyListWriter.assignID(this);
    }

    abstract void toBinary(BinaryPropertyListWriter var1);

    public String toXMLPropertyList() {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(NEWLINE).append("<!DOCTYPE plist PUBLIC \"-//Lebo//DTD PLIST 1.0//EN\" \"https://www.lebo.cn/DTDs/PropertyList-1.0.dtd\">").append(NEWLINE).append("<plist version=\"1.0\">").append(NEWLINE);
        this.toXML(stringBuilder, 0);
        stringBuilder.append(NEWLINE).append("</plist>");
        return stringBuilder.toString();
    }

    protected abstract void toASCII(StringBuilder var1, int var2);

    protected abstract void toASCIIGnuStep(StringBuilder var1, int var2);

    void indent(StringBuilder stringBuilder, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(INDENT);
        }
    }

    public Object toJavaObject() {
        if (this instanceof NSArray) {
            return this.deserializeArray();
        }
        if (this instanceof NSDictionary) {
            return this.deserializeMap();
        }
        if (this instanceof NSSet) {
            return this.deserializeSet();
        }
        if (this instanceof NSNumber) {
            return this.deserializeNumber();
        }
        if (this instanceof NSString) {
            return ((NSString)this).getContent();
        }
        if (this instanceof NSData) {
            return ((NSData)this).bytes();
        }
        if (this instanceof NSDate) {
            return ((NSDate)this).getDate();
        }
        if (this instanceof UID) {
            return ((UID)this).getBytes();
        }
        return this;
    }

    public <T> T toJavaObject(Class<T> clazz) {
        return (T)this.toJavaObject(this, clazz, null);
    }

    public static NSObject fromJavaObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof NSObject) {
            return (NSObject)object;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return NSObject.fromArray(object, clazz);
        }
        if (NSObject.isSimple(clazz)) {
            return NSObject.fromSimple(object, clazz);
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return NSObject.fromSet((Set)object);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return NSObject.fromMap((Map)object);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return NSObject.fromCollection((Collection)object);
        }
        return NSObject.fromPojo(object, clazz);
    }

    private static boolean isSimple(Class<?> clazz) {
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || clazz == String.class || Date.class.isAssignableFrom(clazz);
    }

    private static Object getInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate class " + clazz.getSimpleName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not instantiate class " + clazz.getSimpleName());
        }
    }

    private static Class<?> getClassForName(String string) {
        int n2 = string.indexOf(32);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        if ("double".equals(string)) {
            return Double.TYPE;
        }
        if ("float".equals(string)) {
            return Float.TYPE;
        }
        if ("int".equals(string)) {
            return Integer.TYPE;
        }
        if ("long".equals(string)) {
            return Long.TYPE;
        }
        if ("short".equals(string)) {
            return Short.TYPE;
        }
        if ("boolean".equals(string)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(string)) {
            return Byte.TYPE;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not load class " + string, classNotFoundException);
        }
    }

    private static String makeFirstCharLowercase(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    private Object toJavaObject(NSObject nSObject, Class<?> clazz, Type[] typeArray) {
        if (clazz.isArray()) {
            return this.deserializeArray(nSObject, clazz);
        }
        if (NSObject.isSimple(clazz)) {
            return NSObject.deserializeSimple(nSObject, clazz);
        }
        if (clazz == Object.class && !(nSObject instanceof NSSet) && !(nSObject instanceof NSArray)) {
            return NSObject.deserializeSimple(nSObject, clazz);
        }
        if (nSObject instanceof NSSet && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(nSObject, clazz, typeArray);
        }
        if (nSObject instanceof NSArray && Collection.class.isAssignableFrom(clazz)) {
            return this.deserializeCollection(nSObject, clazz, typeArray);
        }
        if (nSObject instanceof NSDictionary) {
            return this.deserializeObject((NSDictionary)nSObject, clazz, typeArray);
        }
        throw new IllegalArgumentException("Cannot process " + clazz.getSimpleName());
    }

    private Object deserializeObject(NSDictionary nSDictionary, Class<?> clazz, Type[] typeArray) {
        Object object;
        HashMap<String, NSObject> hashMap = nSDictionary.getHashMap();
        if (Map.class.isAssignableFrom(clazz)) {
            return this.deserializeMap(clazz, typeArray, hashMap);
        }
        Object object2 = NSObject.getInstance(clazz);
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        HashMap<String, Method> hashMap3 = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            object = method.getName();
            if (((String)object).startsWith("get")) {
                hashMap2.put(NSObject.makeFirstCharLowercase(((String)object).substring(3)), method);
                continue;
            }
            if (((String)object).startsWith("set")) {
                hashMap3.put(NSObject.makeFirstCharLowercase(((String)object).substring(3)), method);
                continue;
            }
            if (!((String)object).startsWith("is")) continue;
            hashMap2.put(NSObject.makeFirstCharLowercase(((String)object).substring(2)), method);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Method method;
            Method method2 = (Method)hashMap3.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            method = (Method)hashMap2.get(NSObject.makeFirstCharLowercase((String)entry.getKey()));
            if (method2 == null || method == null) continue;
            object = method.getReturnType();
            Type[] typeArray2 = null;
            Type type = method.getGenericReturnType();
            if (type instanceof ParameterizedType) {
                typeArray2 = ((ParameterizedType)type).getActualTypeArguments();
            }
            try {
                method2.invoke(object2, this.toJavaObject((NSObject)entry.getValue(), (Class<?>)object, typeArray2));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Could not access setter " + method2);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException("Could not invoke setter " + method2);
            }
        }
        return object2;
    }

    private HashMap<String, Object> deserializeMap() {
        HashMap<String, NSObject> hashMap = ((NSDictionary)this).getHashMap();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(hashMap.size());
        for (String string : hashMap.keySet()) {
            hashMap2.put(string, hashMap.get(string).toJavaObject());
        }
        return hashMap2;
    }

    private Object deserializeMap(Class<?> clazz, Type[] typeArray, Map<String, NSObject> map) {
        Class<?> clazz2;
        Object object;
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            object = new HashMap();
        } else {
            clazz2 = (Map)NSObject.getInstance(clazz);
            object = clazz2;
        }
        clazz2 = Object.class;
        Type[] typeArray2 = null;
        if (typeArray != null && typeArray.length > 1) {
            Type type = typeArray[1];
            if (type instanceof ParameterizedType) {
                clazz2 = NSObject.getClassForName(((ParameterizedType)type).getRawType().toString());
                typeArray2 = ((ParameterizedType)type).getActualTypeArguments();
            } else {
                clazz2 = NSObject.getClassForName(type.toString());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            object.put(entry.getKey(), this.toJavaObject((NSObject)entry.getValue(), clazz2, typeArray2));
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object deserializeCollection(NSObject nSObject, Class<?> clazz, Type[] typeArray) {
        Class<?> clazz2;
        Collection<Object> collection;
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            if (List.class.isAssignableFrom(clazz)) {
                collection = new ArrayList();
            } else {
                if (!Set.class.isAssignableFrom(clazz)) throw new IllegalArgumentException("Could not find a proper implementation for " + clazz.getSimpleName());
                collection = new HashSet();
            }
        } else {
            clazz2 = (Collection)NSObject.getInstance(clazz);
            collection = clazz2;
        }
        clazz2 = Object.class;
        Type[] typeArray2 = null;
        if (typeArray != null && typeArray.length > 0) {
            if (typeArray[0] instanceof ParameterizedType) {
                clazz2 = NSObject.getClassForName(((ParameterizedType)typeArray[0]).getRawType().toString());
                typeArray2 = ((ParameterizedType)typeArray[0]).getActualTypeArguments();
            } else {
                clazz2 = NSObject.getClassForName(typeArray[0].toString());
            }
        }
        if (nSObject instanceof NSArray) {
            for (NSObject nSObject2 : ((NSArray)nSObject).getArray()) {
                collection.add(this.toJavaObject(nSObject2, clazz2, typeArray2));
            }
            return collection;
        }
        if (!(nSObject instanceof NSSet)) throw new IllegalArgumentException("Unknown NS* type " + nSObject.getClass().getSimpleName());
        for (NSObject nSObject3 : ((NSSet)nSObject).getSet()) {
            collection.add(this.toJavaObject(nSObject3, clazz2, typeArray2));
        }
        return collection;
    }

    private Object[] deserializeArray() {
        NSObject[] nSObjectArray = ((NSArray)this).getArray();
        Object[] objectArray = new Object[nSObjectArray.length];
        for (int i2 = 0; i2 < nSObjectArray.length; ++i2) {
            objectArray[i2] = nSObjectArray[i2].toJavaObject();
        }
        return objectArray;
    }

    private Object deserializeArray(NSObject nSObject, Class<?> clazz) {
        Class<?> clazz2 = NSObject.getClassForName(clazz.getComponentType().getName());
        if (nSObject instanceof NSArray) {
            NSObject[] nSObjectArray = ((NSArray)nSObject).getArray();
            Object object = Array.newInstance(clazz2, nSObjectArray.length);
            for (int i2 = 0; i2 < nSObjectArray.length; ++i2) {
                Array.set(object, i2, this.toJavaObject(nSObjectArray[i2], clazz2, null));
            }
            return object;
        }
        if (nSObject instanceof NSSet) {
            Set<NSObject> set = ((NSSet)nSObject).getSet();
            Object object = Array.newInstance(clazz2, set.size());
            int n2 = 0;
            for (NSObject nSObject2 : set) {
                Array.set(object, n2, this.toJavaObject(nSObject2, clazz2, null));
                ++n2;
            }
            return object;
        }
        if (nSObject instanceof NSData) {
            return NSObject.deserializeData((NSData)nSObject, clazz2);
        }
        throw new IllegalArgumentException("Unable to map " + nSObject.getClass().getSimpleName() + " to " + clazz.getName());
    }

    private Set<Object> deserializeSet() {
        Set<NSObject> set = ((NSSet)this).getSet();
        AbstractSet abstractSet = set instanceof LinkedHashSet ? new LinkedHashSet(set.size()) : new TreeSet();
        for (NSObject nSObject : set) {
            abstractSet.add((Object)nSObject.toJavaObject());
        }
        return abstractSet;
    }

    private static Object deserializeData(NSData nSData, Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return nSData.bytes();
        }
        if (clazz == Byte.class) {
            byte[] byArray = nSData.bytes();
            Object object = Array.newInstance(clazz, byArray.length);
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                Array.set(object, i2, byArray[i2]);
            }
            return object;
        }
        throw new IllegalArgumentException("NSData can only be mapped to byte[] or Byte[].");
    }

    private static Object deserializeSimple(NSObject nSObject, Class<?> clazz) {
        if (nSObject instanceof NSNumber) {
            return NSObject.deserializeNumber((NSNumber)nSObject, clazz);
        }
        if (nSObject instanceof NSDate) {
            return NSObject.deserializeDate((NSDate)nSObject, clazz);
        }
        if (nSObject instanceof NSString) {
            return ((NSString)nSObject).getContent();
        }
        throw new IllegalArgumentException("Cannot map " + nSObject.getClass().getSimpleName() + " to " + clazz.getSimpleName());
    }

    private static Date deserializeDate(NSDate nSDate, Class<?> clazz) {
        if (clazz == Date.class) {
            return nSDate.getDate();
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return nSDate.getDate();
        }
        Date date = (Date)NSObject.getInstance(clazz);
        date.setTime(nSDate.getDate().getTime());
        return date;
    }

    private Object deserializeNumber() {
        NSNumber nSNumber = (NSNumber)this;
        switch (nSNumber.type()) {
            case 0: {
                long l2 = nSNumber.longValue();
                if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                    return l2;
                }
                return nSNumber.intValue();
            }
            case 1: {
                return nSNumber.doubleValue();
            }
            case 2: {
                return nSNumber.boolValue();
            }
        }
        return nSNumber.doubleValue();
    }

    private static Object deserializeNumber(NSNumber nSNumber, Class<?> clazz) {
        if (nSNumber.isInteger()) {
            if (clazz == Long.TYPE || clazz == Long.class) {
                return nSNumber.longValue();
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return nSNumber.intValue();
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)nSNumber.intValue();
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)nSNumber.intValue();
            }
        }
        if (nSNumber.isInteger() || nSNumber.isReal()) {
            if (clazz == Double.TYPE || clazz == Double.class) {
                return nSNumber.doubleValue();
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(nSNumber.floatValue());
            }
        }
        if (nSNumber.isBoolean() && (clazz == Boolean.TYPE || clazz == Boolean.class)) {
            return nSNumber.boolValue();
        }
        throw new IllegalArgumentException("Cannot map NSNumber to " + clazz.getSimpleName());
    }

    private static NSObject fromSimple(Object object, Class<?> clazz) {
        if (object instanceof Long || clazz == Long.TYPE) {
            return new NSNumber((Long)object);
        }
        if (object instanceof Integer || clazz == Integer.TYPE) {
            return new NSNumber((Integer)object);
        }
        if (object instanceof Short || clazz == Short.TYPE) {
            return new NSNumber(((Short)object).shortValue());
        }
        if (object instanceof Byte || clazz == Byte.TYPE) {
            return new NSNumber(((Byte)object).byteValue());
        }
        if (object instanceof Double || clazz == Double.TYPE) {
            return new NSNumber((Double)object);
        }
        if (object instanceof Float || clazz == Float.TYPE) {
            return new NSNumber(((Float)object).floatValue());
        }
        if (object instanceof Boolean || clazz == Boolean.TYPE) {
            return new NSNumber((Boolean)object);
        }
        if (object instanceof Date) {
            return new NSDate((Date)object);
        }
        if (clazz == String.class) {
            return new NSString((String)object);
        }
        throw new IllegalArgumentException("Cannot map " + clazz.getSimpleName() + " as a simple type.");
    }

    private static NSDictionary fromPojo(Object object, Class<?> clazz) {
        NSDictionary nSDictionary = new NSDictionary();
        for (Method accessibleObject : clazz.getMethods()) {
            if (Modifier.isNative(accessibleObject.getModifiers()) || Modifier.isStatic(accessibleObject.getModifiers()) || accessibleObject.getParameterTypes().length != 0) continue;
            String string = accessibleObject.getName();
            if (string.startsWith("get")) {
                string = NSObject.makeFirstCharLowercase(string.substring(3));
            } else {
                if (!string.startsWith("is")) continue;
                string = NSObject.makeFirstCharLowercase(string.substring(2));
            }
            try {
                nSDictionary.put(string, NSObject.fromJavaObject(accessibleObject.invoke(object, new Object[0])));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Could not access getter " + accessibleObject.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException("Could not invoke getter " + accessibleObject.getName());
            }
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            try {
                nSDictionary.put(((Field)accessibleObject).getName(), NSObject.fromJavaObject(((Field)accessibleObject).get(object)));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Could not access field " + ((Field)accessibleObject).getName());
            }
        }
        return nSDictionary;
    }

    private static NSDictionary fromMap(Map<?, ?> map) {
        NSDictionary nSDictionary = new NSDictionary();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Maps need a String key for mapping to NSDictionary.");
            }
            nSDictionary.put((String)entry.getKey(), NSObject.fromJavaObject(entry.getValue()));
        }
        return nSDictionary;
    }

    private static NSObject fromArray(Object object, Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == Byte.TYPE || clazz2 == Byte.class) {
            return NSObject.fromData(object);
        }
        int n2 = Array.getLength(object);
        NSObject[] nSObjectArray = new NSObject[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nSObjectArray[i2] = NSObject.fromJavaObject(Array.get(object, i2));
        }
        return new NSArray(nSObjectArray);
    }

    private static NSData fromData(Object object) {
        int n2 = Array.getLength(object);
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (Byte)Array.get(object, i2);
        }
        return new NSData(byArray);
    }

    private static NSArray fromCollection(Collection<?> collection) {
        ArrayList<NSObject> arrayList = new ArrayList<NSObject>(collection.size());
        for (Object obj : collection) {
            arrayList.add(NSObject.fromJavaObject(obj));
        }
        return new NSArray(arrayList.toArray(new NSObject[arrayList.size()]));
    }

    private static NSSet fromSet(Set<?> set) {
        NSSet nSSet = new NSSet();
        for (Object obj : set) {
            nSSet.addObject(NSObject.fromJavaObject(obj));
        }
        return nSSet;
    }
}

